

/*
 * Copyright (c) 1983, 1988 The Regents of the University of California.
 * All rights reserved
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


/*
 * Figure out the type of system that we're running on
 *
 * Try to determine the environment automatically from the C compiler's
 * predefined symbols.
 * The followin can be determined automatically:
 * BSD VAX, Pyramid, Xenix, AT&T 3b1, AT&T 80386, Celerity and MS-DOS.
 * If this doesn't work on some new system, ifdef this out, and set it
 * by hand.
 */

#ifdef  unix            /* true for most UNIX systems, BSD and SYSV */
                        /* but not for Xenix !! */
#define UNIX    1       /* OS type */

#ifdef  vax             /* true for BSD on a VAX */
/* also true for VAX SYSV, but we don't have to worry about that (for now) */
#define VAX     1       /* hardware */
#define BSD     1       /* OS type */
#else
#ifdef  pyr

#define PYRAMID 1       /* hardware */
#define BSD     1       /* OS type */
#else
#ifdef  mc68k           /* assume AT&T UNIX pc, aka 7300 or 3b1 */
                        /* what about other 68000 unix systems ?? */
#define UNIXPC  1       /* hardware */
#define SYSV    1       /* OS type */
#else
#ifdef  i386            /* Linux */
#define IBMPC    1      /* hardware */
#define SYSV     1      /* OS type */
#else
#ifdef  accel

#define CELERITY 1      /* hardware */
#define BSD      1      /* OS type */
#else
#ifdef sparc

#define sun4     1      /* OS type */
#define BSD      1      /* OS type */
#else
what type of unix system is this
#endif  /* sparc */
#endif  /* accel */
#endif  /* i386 */
#endif  /* mc68k */
#endif  /* pyr */
#endif  /* vax */

#endif /* unix */

#ifdef M_XENIX          /* true for SCO Xenix */
#define UNIX   1        /* OS type */
#define XENIX  1        /* OS type */
#define SYSV   1        /* OS type */
#define IBMPC  1        /* hardware */
#endif  /* M_XENIX */

/*
 * Define replacement names for the BSD names that we use.
 */


#ifdef  MICROSOFT
#define rindex          strrchr
#define index           strchr

#define u_char          unchar
#define u_short         ushort
#define u_int           uint
#define u_long          ulong
#endif
