/* chkperm.c 
   Check permissions on the safedelete directory
   and the user's .safedelete.log.

   Passed: pointer to directory name or NULL
           pointer to file name or NULL

   Returns: 0 permission granted
              1 permission not granted
*/

#include <unistd.h>
#include <sys/stat.h>
#include <stdio.h>

int  CheckPerms(char *DirName, char *FileName, char *Cmd)
{
int ccode, LinkFlag;
struct stat DirInfo, FileInfo;

  LinkFlag=0;

  if(DirName != NULL)
  {
    if((ccode=stat(DirName, &DirInfo)) != 0)
    {
      fprintf(stderr, "%s: %s: directory not found\n",
              Cmd, DirName);
      return 1;
    }

    if(! S_ISDIR(DirInfo.st_mode))
    {
      fprintf(stderr, "%s: %s is not a directory\n",
              Cmd, DirName);
      return 1;
    }

    if(access(DirName, W_OK) != 0)
    {
      fprintf(stderr, "%s: %s: permission denied\n",
              Cmd, DirName);
      return 1;
    }
  }

  if(FileName != NULL)
  {
    if((ccode=lstat(FileName, &FileInfo)) == 0)
      LinkFlag=1;
    else
    {
      if((ccode=stat(FileName, &FileInfo)) != 0)
      {
        fprintf(stderr, "%s: %s: file not found\n",
                Cmd, FileName);
        return 1;
      }
    }

    if(! LinkFlag && S_ISDIR(FileInfo.st_mode))
    {
      fprintf(stderr, "%s: %s is not a file\n",
              Cmd, FileName);
      return 1;
    }

    if(strcmp(FileName+strlen(FileName)-15, ".safedelete.log") == 0)
    {
      if(access(FileName, R_OK | W_OK) != 0)
      {
        fprintf(stderr, "%s: %s: update access to log needed\n",
                Cmd, FileName); 
        return 1;
      }
    }
    else
    {
      if(! LinkFlag && access(FileName, R_OK) != 0)
      {
        fprintf(stderr, "%s: %s: permission denied\n",
                Cmd, FileName);
        return 1;
      }
    }
  }

  return 0;
}
