#include <string.h>
#include "safedelete.h"

/* CheckFilePattern

   Scans filename looking for a match with a pattern
   specified in the users .Safedelrc file.

   Passed: pointer to filename
           pointer to compression_struct structure

   Returns: 0 - filename matches pattern
            1 - filename does not match pattern
*/

int  CheckFilePattern(char *FileName, compression_struct *cs)
{
  switch(cs->Type)
  {
    case PREFIX   : if(strncmp(FileName, cs->FileName, cs->PreLen) == 0)
                      return 0;
                    else
                      return 1;

    case SUFFIX   : if(strncmp(FileName+strlen(FileName)-cs->SufLen,
                              cs->FileName+1, cs->SufLen) == 0)
                      return 0;
                    else
                      return 1;

    case INFIX    : if(strncmp(FileName, cs->FileName, cs->PreLen) == 0)
                    {
                      if(strncmp(FileName+strlen(FileName)-cs->SufLen,
                                cs->FileName+strlen(cs->FileName)-cs->SufLen,
                                cs->SufLen) == 0)
                        return 0;
                      else
                        return 1;
                    }
                    else
                      return 1;

    case FULLNAME : if(strcmp(FileName, cs->FileName) == 0)
                      return 0;
                    else
                      return 1;

    case ALLFILES : return 0;
  }
  return 1; 
}
