#include <stdio.h>
#include <string.h>
#include <ncurses.h>

#include "ncd.h"

/*************************************************************************/

void paintLayout(void)
{
	char *title = "Ninux Change Directory";
	size_t len;
	
	_refCurrent = _refRest = _refCurDir = _refSearch = 1;

	attrset(getColorMode(0));
	border(0, 0, 0, 0, 0, 0, 0, 0);

	mvaddch(_lines - 4, 0, ACS_LTEE);
	hline(ACS_HLINE, COLS - 2);
	mvaddch(_lines - 4, COLS - 1, ACS_RTEE);

	mvaddstr(_lines - 2, 2, "Search:");
	mvaddstr(_lines - 2, COLS - 13, "HELP=Ctrl+i");

	attrset(getColorMode(1));
	len = strlen(title);
	if (len > COLS - 4)
		len = COLS - 4;
	mvaddch(0, (COLS - len) / 2 - 1, ' ');
	waddnstr(stdscr, title, len);
	addch(' ');
	

}

/*************************************************************************/

char *truncString(char *s, int maxlen)
{
	int len;

	len = strlen(s);

	if (len > maxlen) {
		s += (len - maxlen);
		s[0] = s[1] = s[2] = '.';
	}

	return s;
}

/*************************************************************************/

void updateLine(int i)
{
	int j, len, n, sel;
	char *s;

	s = getTreeLine(getLastNodeInLevel(_rootNode, _y0 + i), _lineart, 1);
	move(i + 1, 2);
	attrset(getColorMode(0));
	hline(' ', _cols - 3);
	sel = 0;

	if (s) {
		len = strlen(s);
		n = 2;
		for (j = _x0; j < len; j++) {
			if (n > _cols - 3)
				break;
			switch (s[j]) {
			case __ACS_HL:
				addch(ACS_HLINE);
				break;
			case __ACS_VL:
				addch(ACS_VLINE);
				break;
			case __ACS_LT:
				addch(ACS_LTEE);
				break;
			case __ACS_LLC:
				addch(ACS_LLCORNER);
				break;
			case __ACS_TT:
				addch(ACS_TTEE);
				break;
			case __SEL_ON:
				attrset(getColorMode(1));
				sel = 1;
				n--;
				break;
			case __SEL_OFF:
				attrset(getColorMode(0));
				sel = 0;
				n--;
				break;
			default:
				addch(s[j]);
			}
			n++;
		}
		if ((sel) && (s[j] != __SEL_OFF))
			mvaddstr(i + 1, _cols - 5, "...");
	}
	leaveok(stdscr, FALSE);
	attrset(getColorMode(0));
}

/*************************************************************************/

void dataRefresh(int newx, int newy, DirNode * newNode)
{
	int i, len, y;
	char *s;
	DirNode * oNode;
	int oy;
	
	if (newNode == NULL)
		newNode = _curNode;

	if (newy < 0)
		newy = 0;
	if (newy > newNode->y)
		newy = newNode->y;
	if (newNode->y - newy > _lines - 6)
		newy = newNode->y - (_lines - 6);

	if (newx >= newNode->x)
		newx = newNode->x - 2;
	if (newx < 0)
		newx = 0;
	len = strlen(getNodeName(newNode, (_showlink?1:-1)));
	if (len > _cols - 4)
		len = _cols - 4;
	if (newNode->x - newx + len > _cols - 4)
		newx = newNode->x + len - (_cols - 4);

	len = strlen(_searchPath);
	y = newNode->y - newy;
	
	if ((newx!=_x0)||(newy!=_y0)) {
		_refCurrent = 1;
		_refRest = 1;
	}
	if (_searchPLen!=len)
		_refSearch = 1;
	if ((_curNode!=newNode)||(_curNode->y-_y0!=y)) 
		_refCurrent = 1;
 	if (_curNode!=newNode) 
 		_refCurDir = 1;
 	
	
	oNode = _curNode;
	oy = oNode->y-_y0;
	
	_x0 = newx;
	_y0 = newy;
	_curNode = newNode;

	leaveok(stdscr, TRUE);

	if (_refSearch) {
		_refSearch = 0;
		_searchPLen = len;
		move(_lines - 2, 10);
		attrset(getColorMode(1));
		if (COLS - 25 > SEARCHWIN_LEN) {
			hline(' ', SEARCHWIN_LEN);
			_searchPX = SEARCHWIN_LEN;
		}
		else {
			hline(' ', COLS - 25);
			_searchPX = COLS - 25;
		}
		if (len < _searchPX) {
			waddstr(stdscr, _searchPath);
			_searchPX = len;
		}
		else {
			_searchPX--;
			waddstr(stdscr, _searchPath + len - _searchPX);
			mvaddstr(_lines - 2, 10, "...");
		}
	}

	attrset(getColorMode(0));

	if (_refCurrent) {
		_refCurrent = 0;
		updateLine(y);
	}

	if (kbHit()) {  
		if (y!=oy)
			_refRest = 1;
		return;
	}
	if (y!=oy)
		updateLine(oy);

 	if (_refCurDir) {
		if (kbHit())  
			return; 
		_refCurDir = 0;
		s = truncString(getNodeFullPath(newNode, 1, (_scope == -1), NULL, 0), _cols - 4); 
		attrset(getColorMode(0));
		mvaddstr(_lines - 3, 2, s);
		hline(' ', _cols - 4 - strlen(s));
	}

	if (_refRest) {
		for (i = 0; i < _lines - 5; i++) { 
			if (kbHit()) 
				return;
			if ((i != y) && (i != oy))
				updateLine(i);
	
		}
		_refRest = 0;
	}
	leaveok(stdscr, FALSE);
	move(_lines - 2, 10 + _searchPX);
}

/*************************************************************************/

void editSearch(int ch)
{
	DirNode * dn;
	int len;
	int be;

	be = 0;
	len = strlen(_searchPath);
	dn = _curNode;

	if ((ch == 8) || (ch == 127) || (ch == 4)) {
		if (len) {
			_searchPath[len - 1] = 0;
		}
		ch = -1;
	}
	
	if ((ch>0)&&(ch < 32)) {
		be = 1;
	}
	else {
		if (ch) {
			if (ch>0) {
				_searchPath[len] = ch;
				_searchPath[len + 1] = '\0';
			}
			dn = findDirInCicle(_rootNode, _curNode, _searchPath); 
		}
		else if (len)
			dn = findDirInCicle(_rootNode, nextNodeCiclic(_rootNode, _curNode), _searchPath);
		else
			dn = NULL;
			
		if (dn==NULL) {
			_searchPath[len] = '\0';
			be = 1;
			dn = _curNode;
		}
	}

	dataRefresh(_x0, _y0, dn);
/*
	if (be)
		beep();
*/
}

/*************************************************************************/

void showHelpScreen()
{
	char *title = " HELP ";
	char *msg = 
	"                                                            "
	"     ______________MOVE______________   ____SEARCH_____     "
	"     ^P/Up.........Up  ^A/Home...Home   ^K/F9......Next     "
	"     ^N/Down.....Down  ^E/End.....End   ^H/BSpc...DelCh     "
	"     ^B/Left.....Left  ^U/PgUp...PgUp   ^D/Del....Clear     "
	"     ^F/Right...Right  ^V/PgDn...PgDn   _____LINKS_____     "
	"     ^F/Right....Next  ^O/F7.....LnUp   ^L|F5....Follow     "
	"     ^T..........Prev  ^J/F8.....LnDn   ^G|F6......View     "
	"     ______________MISC______________   _______________     "
	"     ^R/F2.....Rescan  ^Y/F3....Scope   ^M/Return....OK     "
	"     ^W/F4....Repaint  ^I/F1.....Help   ^X/F10.....Quit     "	
	"                                                            "
	"";
	
	WINDOW * w;
	int x, y;
	
	y = (_lines-HLP_LINES)/2;
	x = (_cols-HLP_COLS)/2;
	w = newwin(HLP_LINES,HLP_COLS,y,x);
	
	leaveok(w, TRUE);
	wattrset(w,getColorMode(1));

	mvwprintw(w,1,0,"%s",msg);
	box(w,ACS_VLINE,ACS_HLINE);
	mvwprintw(w,HLP_LINES-1,HLP_COLS-30," 1995 (c)  Borja Etxebarria ");
	mvwaddstr(w,0,(HLP_COLS-strlen(title))/2,title);	

	wrefresh(w);
	
	delwin(w);
	
}

/*************************************************************************/

void showHelpNoSpace()
{
	char *msg1 = " This screen is too small ";
	char *msg2 = "  to display help window  ";
	WINDOW * w;
	int x, y;
	
	y = (_lines-4)/2;
	x = (_cols-strlen(msg1)-2)/2;
	w = newwin(4,strlen(msg1)+2,y,x);

	leaveok(w, TRUE);	
	wattrset(w,getColorMode(1));
	box(w,ACS_VLINE,ACS_HLINE);
	mvwaddstr(w,1,1,msg1);
	mvwaddstr(w,2,1,msg2);

	wrefresh(w);
	
	delwin(w);
}

/*************************************************************************/

void cursRebuildMsg()
{
	char *msg1 = " Rebuilding directory ";
	char *msg2 = " tree, please wait... ";
	WINDOW * w;
	int x, y;
	
	y = (_lines-4)/2;
	x = (_cols-strlen(msg1)-2)/2;
	w = newwin(4,strlen(msg1)+2,y,x);

	leaveok(w, TRUE);	
	wattrset(w,getColorMode(1));
	box(w,ACS_VLINE,ACS_HLINE);
	mvwaddstr(w,1,1,msg1);
	mvwaddstr(w,2,1,msg2);

	wrefresh(w);
	
	delwin(w);
}

/*************************************************************************/
