#include	"def.h"

#include	<errno.h>
#include	<unistd.h>
#include	<signal.h>
#ifdef	CURSESX
#include	<cursesX.h>
#else
#include	<curses.h>
#endif
#include	<time.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<sys/dir.h>
#include	<sys/param.h>

extern char* getenv();
extern alphasort();
extern int errno;

char *header;
int entries;
struct direct **namelist;
struct stat buf;

extern char editor[];
extern char *pager;
extern char *defaultEditor;

static char retain[MAXFNAME+1];
static char tstr[MAXFNAME+2], cdir[MAXFNAME+2], dest[MAXFNAME+2];
static int quit, samedir, cur, top, oldtop, result;

static int startingRow, Rows;

static mxselect(dir)
struct direct *dir;
{
	return(strcmp(dir->d_name, ".") != 0);
}

prompt(p, dest)
char *p, *dest;
{
	int i = 0, x,  c;

	move(PROMPT, 0); clrtoeol();
	x = strlen(p); addstr(p);
	if (dest) {
	    for (;;) {
		refresh();
		c = getch();
		if (c == erasech) {
			if  (i) {
				i = i - 1;
				move(PROMPT, x+i);
				clrtoeol();
			} else
				break;
		} else if (c == '\n' || c == '\r')
			break;
		else {
			dest[i++] = c;
			addch(c);
		}
	    }
	    dest[i] = '\0';
	} else {
	    refresh();
	    sleep(3);
	}
	move(PROMPT, 0); clrtoeol();
}

static overwrite_2(f)
char *f;
{
	FILE *fd = fopen(f, "r");
	if (fd) {
		fclose(fd);
		sprintf(tstr, "Overwrite `%s'? ", f);
		prompt(tstr, tstr);
		return(toupper(tstr[0]) == 'Y');
	} else
		return(1);
}

static mode(v)
{
	addch(v & 4 ? 'r' : '-');
	addch(v & 2 ? 'w' : '-');
	addch(v & 1 ? 'x' : '-');
}

static makeMark(i, c)
{
	move(startingRow+i, 44); addch(c);
}

struct trig {
	char key;
	char cmdstr[MAXLINELENGTH];
} triggers[MAXTRIGGERS];
int ntrigger;

static enter(trigger, cmd)
char trigger;
char *cmd;
{
	triggers[ntrigger].key = trigger;
	strcpy(triggers[ntrigger].cmdstr, cmd);
	ntrigger++;
}

static char *
lookup(trigger)
char trigger;
{
	int  i;

	for (i = 0; i<ntrigger; i++)
		if (triggers[i].key == trigger)
			return(triggers[i].cmdstr);
	return(NULL);
}

static processOptions(s)
char *s;
{
	static char buf[MAXLINELENGTH];
	char dest[MAXLINELENGTH];
	extern interpolate();

	ntrigger = 0; header = NULL;
	if (s == NULL) return;
	while (*s)
	    if (*s == ' ' || *s == '\t')
		s++;
	    else if (*s == '-') {
		char trigger, *cmd;
		s++;
		trigger = *s++;
		cmd = dest;
		if (*s != ' ' && *s != '\t' && *s != '\0') {
		    while (*s != ' ' && *s != '\t' && *s != '\0') {
			if (*s == '\\') s++;
			if (*s) { *cmd++ = *s++; }
		    }
		    *cmd = '\0';
		    enter(trigger, dest);
		}
	    } else {
		header = s; while (s[strlen(s)-1] == ' ') s[strlen(s)-1]=0;
		break;
	    }
}

static newdir()
{
	clear(); attribNormal();
	if (header && header[0])
	    if (header[0] == '<') {
		FILE* fp = fopenWithSearchPath(&header[1], "r");
		int c;
		startingRow = 3;
		if (fp) {
		    while ((c = getc(fp)) != EOF) {
			addch(c);
			if (c == '\n') startingRow++;
		    }
		    fclose(fp);
		} else {
		    sprintf(tstr, "%s does not exist", &header[1]);
		    prompt(tstr, 0);
		}
	    } else {
		addstr(header); addch('\n');
		startingRow = 4;
	    }
	else {
        addstr("                                   HYBROW\n");
        addstr("                    hypertext Unix directory browser\n\n");
        addstr("Arrow keys to move, <CR> selects,  c)opy  d)elete  e)dit  ?)help  r)ename  u)nix");
	startingRow = 8;
	}
	addstr("\nCurrent directory: ");
	getwd(cdir); addstr(cdir);
}

static disposeEntries()
{
	int i;

	for (i=0; i<entries; i++)
		free(namelist[i]);
 	if (namelist)
		free(namelist);
}

static searchEntry(name)
char *name;
{
	int i;

	for (i=0; i<entries; i++)
		if (strcmp(namelist[i]->d_name, name) == 0)
			return(i);
	return(0);
}

static displayFile(fname)
char* fname;
{
	FILE *fp = fopenWithSearchPath(fname, "r");

	clear();
	if (fp) {
		char ln[MAXLINELENGTH];
		while (fgets(ln, MAXLINELENGTH, fp))
			addstr(ln);
		fclose(fp);
	}
	prompt("Press return to continue ", tstr);
}

static display()
{
	int i;

	move(startingRow-1, 0); clrtobot();
	move(startingRow-1, 0); /* just to play safe for CONVEX */
	addstr("  Mode        Bytes       Last modified      Name");
	for (i=top; i<min(entries,top+(SCREENSIZE-startingRow)); i++) {
		move(startingRow+i-top, 0);
		stat(namelist[i]->d_name, &buf);
		mode((buf.st_mode & 0700) >> 6);
		mode((buf.st_mode & 070) >> 3);
		mode(buf.st_mode & 007);
		if ((buf.st_mode & S_IFDIR) == S_IFDIR)
			addstr("      <DIR>  ");
		else {
			sprintf(tstr, " %10d  ", buf.st_size); addstr(tstr);
		}
		strcpy(tstr,ctime(&buf.st_mtime));
		tstr[strlen(tstr)-1] = '\0';
		addstr(&tstr[4]);
		addstr("    ");
		addstr(namelist[i]->d_name);
		addch('\n');
	}
}

static down(n)
{
	cur = min(cur+n, entries-1);
	if (cur-top >= (SCREENSIZE-startingRow))
		top = min(top + (SCREENSIZE-startingRow)-1, entries);
}

static up(n)
{
	cur = max(0, cur-n);
	if (cur < top)
		top = max(0, top - (SCREENSIZE-startingRow)+1);
}

static canExecute(b)
struct stat *b;
{
	return((b->st_uid == getuid() || b->st_uid == geteuid()) &&
		(b->st_mode & 0100) ||
		(b->st_uid == getgid() || b->st_uid == getegid()) &&
		(b->st_mode & 0010) ||
		(b->st_mode & 0001)
		);
}

static execute(file, arg, arg2)
char *file, *arg, *arg2;
{
	int pid;

	pid = fork();
	if (pid == 0) {
		stopCurses();
		execl(file, file, arg, arg2, 0);
		printf("\nCannot execl(%s)\n", file);
		fflush(stdout);
		exit(-1);
	} else if (pid > 0) {
		while (wait(0) != pid)
			;
		startCurses();
		newdir();
		samedir = FALSE;
		strcpy(retain, (arg?arg:file));
	} else {
		stopCurses();
		printf("\nCannot fork()\n");
		fflush(stdout);
		exit(-1);
	}
}

char* mx(arg)
char *arg;
{
    int c;

    char *xcmd;

    processOptions(arg);
    namelist = NULL; entries = 0;
    quit = FALSE;

    retain[0] = '\0';
    while (!quit) {
	entries = scandir(".", &namelist, mxselect, alphasort);
	newdir();
	samedir = TRUE; top = 0; cur = 0; oldtop = -1;
	while ((!quit) && samedir) {
	    if (retain[0]) {
		cur = searchEntry(retain);
		if (cur-top <= 0 || cur-top > (SCREENSIZE-startingRow))
		    top = max(0, cur - (SCREENSIZE-startingRow)/2);
		retain[0] = '\0';
	    }
	    if (oldtop != top) {
		display();
		oldtop = top;
	    }
	    makeMark(cur-top, '>');
	    refresh();
	    c = mygetch();
	    makeMark(cur-top, ' ');
	    xcmd = lookup(c);
	    if (xcmd) {
		/* execute trigger */
#ifdef	XIFILE
		char fullname[MAXFNAME+2];
		sprintf(fullname, "%s/%s", cdir, namelist[cur]->d_name);
		setvalue(fullname, "XIFILE");
		execshell(xcmd);
#else
		char cmd[MAXLINELENGTH];
		sprintf(cmd, "%s %s/%s", xcmd, cdir, namelist[cur]->d_name);
		execshell(cmd);
#endif
		returnToContinue();
		newdir();
		samedir = FALSE;
		strcpy(retain, namelist[cur]->d_name);
	    } else
	    switch (toupper(c)) {
	    case 'C':
		sprintf(tstr, "Copy `%s' to: ", namelist[cur]->d_name);
		prompt(tstr, dest);
		if (dest[0] != '\0' && overwrite_2(dest))
		     execute("/bin/cp", namelist[cur]->d_name, dest);
		break;
	    case 'D':
		sprintf(tstr, "Delete `%s'? ", namelist[cur]->d_name);
		prompt(tstr, dest);
		if (toupper(dest[0]) == 'Y') {
		    stat(namelist[cur]->d_name, &buf);
		    if ((buf.st_mode & S_IFDIR) == S_IFDIR) {
			result = rmdir(namelist[cur]->d_name);
			if (result != 0 && errno == ENOTEMPTY) {
			   prompt("Cannot remove non-empty directory", 0);
			   break;
			}
		    } else {
			result = unlink(namelist[cur]->d_name);
		    }
		    samedir = FALSE;
		    if (cur) strcpy(retain, namelist[cur-1]->d_name);
		}
		break;
	    case 'E':
		execute(editor, namelist[cur]->d_name,0);
		break;
	    case '?':
		displayFile("help.brow");
		newdir();
		oldtop = -1;
		break;
	    case 'I':
	        displayFile("info.brow");
	        newdir();
	        oldtop = -1;
	        break;
	    case 'J':
	    case DNARROW:
		down(1);
		break;
	    case 'K':
	    case UPARROW:
		up(1);
		break;
	    case '\004': /*  Control-D */
		down((SCREENSIZE-startingRow)/2);
		break;
	    case '\025': /*  Control-U */
		up((SCREENSIZE-startingRow)/2);
		break;
	    case 'M':
		prompt("Make Directory called : ", dest);
		if (dest[0] == '\0') break;
		result = mkdir(dest, 0777);
		if (result) {
		   sprintf(tstr, "Cannot create directory `%s'", dest);
		   prompt(tstr, 0);
		}
		samedir = FALSE;
		strcpy(retain, namelist[cur]->d_name);
		break;
	    case 'N':
		prompt("jump to New directory called : ", dest);
		if (dest[0] == '\0') break;
		if (chdir(dest) == 0)
		    samedir = FALSE;
		else {
		    sprintf(tstr, "cannot jump into directory %s", dest);
		    prompt(tstr, 0);
		}
		break;
	    case 'L':
	    case '\n':
	    case RTARROW:
		stat(namelist[cur]->d_name, &buf);
		if ((buf.st_mode & S_IFDIR) == S_IFDIR) {
			chdir(namelist[cur]->d_name);
			samedir = FALSE;
		} else if (canExecute(&buf))
			execute(namelist[cur]->d_name,0,0);
		else
			execute(pager, namelist[cur]->d_name,0);
		break;
	    case 'Q':
	    case 'H':
            case LTARROW:
	    case 27:
		quit = TRUE;
		break;
	    case 18: /* ^R */
		strcpy(retain, namelist[cur]->d_name); samedir = FALSE;
		break;
	    case 'R':
		sprintf(tstr, "Rename `%s' to: ", namelist[cur]->d_name);
		prompt(tstr, dest);
		if (dest[0] != '\0' && overwrite_2(dest)) {
		     unlink(dest);
		     result = link(namelist[cur]->d_name, dest);
		     if (result) {
			sprintf(tstr, "Cannot rename `%s' to `%s'",
					namelist[cur]->d_name, dest);
			prompt(tstr, 0);
		     } else {
			unlink(namelist[cur]->d_name);
			samedir = FALSE;
			strcpy(retain, dest);
		     }
		}
		break;
	    case 'S':
		sprintf(tstr, "Full path name of editor [initial:%s] : ",
				defaultEditor);
		prompt(tstr, dest);
		strcpy(editor, (dest[0] == '\0' ? defaultEditor : dest));
	        break;
	    case 'T':
	        execute(pager, "+G", namelist[cur]->d_name);
        	break;
	    case '!':
	    case 'U':
		prompt("! ", tstr);
		if (tstr[0] == '\0') break;
		stopCurses();
		printf("\n"); fflush(stdout);
		system(tstr);
		printf("\nPress return to continue"); fflush(stdout);
		while (getchar() != '\n') ;
		startCurses();
		samedir = FALSE;
		strcpy(retain, namelist[cur]->d_name);
		break;
	    case 'V':
		execute(pager, namelist[cur]->d_name,0);
		break;
	    } /* of switch */
	}
	sprintf(dest, "%s/%s", cdir, namelist[cur]->d_name);
	disposeEntries();
    }
    return(dest);
}
