static void (*root_map[128])(void) =
  {
      most_beep,                 /* ^@ */
      most_beep,                 /* ^A */
      most_beep,                 /* ^B */
      most_beep,                 /* ^C */
      page_down_cmd,            /* ^D */
      most_beep, /* ^E */
      search_cmd,               /* ^F */
      most_beep, /* ^G */
      help_cmd,                 /* ^H */
      page_right_cmd,           /* ^I */
      next_line_cmd,            /* ^J */
      ctrl_k_map_cmd,           /* ^K */
      most_beep, /* ^L */
      next_line_cmd,            /* ^M */
      next_line_cmd,            /* ^N */
      most_beep, /* ^O */
      previous_line_cmd,        /* ^P */
      most_beep, /* ^Q */
      redraw_cmd,               /* ^R */
      most_beep, /* ^S */
      time_cmd,                 /* ^T */
      page_up_cmd,              /* ^U */
      page_down_cmd,            /* ^V */
      ctrl_w_map_cmd,           /* ^W */
      ctrl_x_map_cmd,           /* ^X */
      most_beep, /* ^Y */
      sys_spawn_cmd,            /* ^Z */
      esc_map_cmd,              /* ^[ */
      most_beep, /* ^\ */
      most_beep, /* ^] */
      most_beep, /* ^^ */
      most_beep, /* ^_ */
      page_down_cmd,            /*   */
      most_beep, /* ! */
      most_beep, /* " */
      most_beep, /* # */
      sys_spawn_cmd,            /* $ */
      goto_percent_cmd,         /* % */
      most_beep, /* & */
      most_beep, /* ' */
      most_beep, /* ( */
      most_beep, /* ) */
      most_beep, /* * */
      most_beep, /* + */
      goto_mark_cmd,            /* , */
      digit_arg_cmd,            /* - */
      most_beep, /* . */
      search_cmd,               /* / */
      digit_arg_cmd,            /* 0 */
      digit_arg_cmd,            /* 1 */
      digit_arg_cmd,            /* 2 */
      digit_arg_cmd,            /* 3 */
      digit_arg_cmd,            /* 4 */
      digit_arg_cmd,            /* 5 */
      digit_arg_cmd,            /* 6 */
      digit_arg_cmd,            /* 7 */
      digit_arg_cmd,            /* 8 */
      digit_arg_cmd,            /* 9 */
     most_extended_key_cmd,         /* : */
      most_beep, /* ; */
      page_left_cmd,            /* < */
      most_beep, /* = */
      page_right_cmd,           /* > */
      search_back_cmd,          /* ? */
      most_beep, /* @ */
      most_beep, /* A */
      end_of_buffer_cmd,        /* B */
      most_beep, /* C */
      page_down_cmd,            /* D */
      most_edit_cmd, /* E */
      search_cmd,               /* F */
      goto_line_cmd,            /* G */
      help_cmd,                 /* H */
      most_beep, /* I */
      goto_line_cmd,            /* J */
      most_beep, /* K */
      most_toggle_lock,              /* L */
      set_mark_cmd,             /* M */
      find_next_cmd,            /* N */
      other_window_cmd,         /* O */
      most_beep, /* P */
      most_exit_most,                 /* Q */
      redraw_cmd,               /* R */
      search_cmd,		       /* S */
      top_of_buffer_cmd,        /* T */
      page_up_cmd,              /* U */
      next_line_cmd,            /* V */
      toggle_width_cmd,         /* W */
      most_exit_most, /* X */
      most_beep, /* Y */
      most_beep, /* Z */
      most_beep, /* [ */
      most_beep, /* \ */
      most_beep, /* ] */
      previous_line_cmd, /* ^ */
      most_beep, /* _ */
      most_beep, /* ` */
      most_beep, /* a */
      end_of_buffer_cmd,        /* b */
      most_beep, /* c */
      page_down_cmd,            /* d */
      most_edit_cmd, /* e */
      search_cmd,               /* f */
      goto_line_cmd,            /* g */
      help_cmd,                 /* h */
      most_beep, /* i */
      goto_line_cmd,            /* j */
      most_beep, /* k */
      most_toggle_lock,              /* l */
      set_mark_cmd,             /* m */
      find_next_cmd,            /* n */
      other_window_cmd,         /* o */
      most_beep, /* p */
      most_exit_most,                 /* q */
      redraw_cmd,               /* r */
      search_cmd,		       /* s */
      top_of_buffer_cmd,        /* t */
      page_up_cmd,              /* u */
      next_line_cmd,            /* v */
      toggle_width_cmd,         /* w */
      most_exit_most, /* x */
      most_beep, /* y */
      most_beep, /* z */
      most_beep, /* { */
      most_beep, /* | */
      most_beep, /* } */
      most_beep, /* ~ */
      page_up_cmd               /* ^? */
    };

/*  escape map  */
static void (*escape_map[128])(void) =
  {
      most_beep, /* ^@ */
      most_beep, /* ^A */
      most_beep, /* ^B */
      most_beep, /* ^C */
      most_beep, /* ^D */
      most_beep, /* ^E */
      most_beep, /* ^F */
      most_beep, /* ^G */
      most_beep, /* ^H */
      most_beep, /* ^I */
      most_beep, /* ^J */
      most_beep, /* ^K */
      most_beep, /* ^L */
      most_beep, /* ^M */
      most_beep, /* ^N */
      most_beep, /* ^O */
      most_beep, /* ^P */
      most_beep, /* ^Q */
      most_beep, /* ^R */
      most_beep, /* ^S */
      most_beep, /* ^T */
      most_beep, /* ^U */
      most_beep, /* ^V */
      most_beep, /* ^W */
      most_beep, /* ^X */
      most_beep, /* ^Y */
      most_beep, /* ^Z */
      most_beep, /* ^[ */
      most_beep, /* ^\ */
      most_beep, /* ^] */
      most_beep, /* ^^ */
      most_beep, /* ^_ */
      most_beep, /*   */
      most_beep, /* ! */
      most_beep, /* " */
      most_beep, /* # */
      sys_spawn_cmd,            /* $ */
      most_beep, /* % */
      most_beep, /* & */
      most_beep, /* ' */
      most_beep, /* ( */
      most_beep, /* ) */
      most_beep, /* * */
      most_beep, /* + */
      most_beep, /* , */
      digit_arg_cmd,            /* - */
      most_beep, /* . */
      most_beep, /* / */
      most_beep, /* 0 */
      digit_arg_cmd,            /* 1 */
      digit_arg_cmd,            /* 2 */
      digit_arg_cmd,            /* 3 */
      digit_arg_cmd,            /* 4 */
      digit_arg_cmd,            /* 5 */
      digit_arg_cmd,            /* 6 */
      digit_arg_cmd,            /* 7 */
      digit_arg_cmd,            /* 8 */
      digit_arg_cmd,            /* 9 */
      most_beep, /* : */
      most_beep, /* ; */
      top_of_buffer_cmd,        /* < */
      most_beep, /* = */
      end_of_buffer_cmd,        /* > */
      most_beep, /* ? */
      most_beep, /* @ */
      most_beep, /* A */
      most_beep, /* B */
      most_beep, /* C */
      most_beep, /* D */
      most_beep, /* E */
      most_beep, /* F */
      most_beep, /* G */
      most_beep, /* H */
      most_beep, /* I */
      most_beep, /* J */
      most_beep, /* K */
      most_beep, /* L */
      most_beep, /* M */
      most_beep, /* N */
      O_map_cmd,                /* O */
      most_beep, /* P */
      most_beep, /* Q */
      most_beep, /* R */
      most_beep, /* S */
      most_beep, /* T */
      most_beep, /* U */
      most_beep, /* V */
      most_beep, /* W */
      most_beep, /* extended_cmd_cmd, */         /* X */
      most_beep, /* Y */
      most_beep, /* Z */
      O_map_cmd,                /* [ */
      most_beep, /* \ */
      most_beep, /* ] */
      most_beep, /* ^ */
      most_beep, /* _ */
      most_beep, /* ` */
      most_beep, /* a */
      most_beep, /* b */
      most_beep, /* c */
      most_beep, /* d */
      most_beep, /* e */
      most_beep, /* f */
      most_beep, /* g */
      most_beep, /* h */
      most_beep, /* i */
      most_beep, /* j */
      most_beep, /* k */
      most_beep, /* l */
      most_beep, /* m */
      most_beep, /* n */
      most_beep, /* o */
      most_beep, /* p */
      most_beep, /* q */
      most_beep, /* r */
      most_beep, /* s */
      most_beep, /* t */
      most_beep, /* u */
      most_beep, /* v */
      most_beep, /* w */
     most_beep, /* extended_cmd_cmd, */        /* x */
      most_beep, /* y */
      most_beep, /* z */
      most_beep, /* { */
      most_beep, /* | */
      most_beep, /* } */
      most_beep, /* ~ */
      most_beep  /* ^? */
  };

static void (*ctrl_x_map[128])(void) =
  {
      most_beep, /* ^@ */
      most_beep, /* ^A */
      most_beep, /* ^B */
      most_exit_most, /* ^C */
      most_beep, /* ^D */
      most_beep, /* ^E */
      find_file_cmd,            /* ^F */
      most_beep, /* ^G */
      most_beep, /* ^H */
      most_beep, /* ^I */
      most_beep, /* ^J */
      most_beep, /* ^K */
      most_beep, /* ^L */
      most_beep, /* ^M */
      most_beep, /* ^N */
      most_beep, /* ^O */
      most_beep, /* ^P */
      most_beep, /* ^Q */
      most_beep, /* ^R */
      most_beep, /* ^S */
      most_beep, /* ^T */
      most_beep, /* ^U */
      most_beep, /* ^V */
      most_beep, /* ^W */
      most_beep, /* ^X */
      most_beep, /* ^Y */
      most_beep, /* ^Z */
      most_beep, /* ^[ */
      most_beep, /* ^\ */
      most_beep, /* ^] */
      most_beep, /* ^^ */
      most_beep, /* ^_ */
      most_beep, /*   */
      most_beep, /* ! */
      most_beep, /* " */
      most_beep, /* # */
      most_beep, /* $ */
      most_beep, /* % */
      most_beep, /* & */
      most_beep, /* ' */
      most_beep, /* ( */
      most_beep, /* ) */
      most_beep, /* * */
      most_beep, /* + */
      most_beep, /* , */
      most_beep, /* - */
      most_beep, /* . */
      most_beep, /* / */
      del_window_cmd,           /* 0 */
      one_window_cmd,           /* 1 */
      two_window_cmd,           /* 2 */
      most_beep, /* 3 */
      most_beep, /* 4 */
      most_beep, /* 5 */
      most_beep, /* 6 */
      most_beep, /* 7 */
      most_beep, /* 8 */
      most_beep, /* 9 */
      most_beep, /* : */
      most_beep, /* ; */
      most_beep, /* < */
      most_beep, /* = */
      most_beep, /* > */
      most_beep, /* ? */
      most_beep, /* @ */
      most_beep, /* A */
      most_beep, /* B */
      most_beep, /* C */
      most_beep, /* D */
      most_beep, /* E */
      most_beep, /* F */
      most_beep, /* G */
      most_beep, /* H */
      most_beep, /* I */
      most_beep, /* J */
      most_beep, /* K */
      most_beep, /* L */
      most_beep, /* M */
      most_beep, /* N */
      other_window_cmd,         /* O */
      most_beep, /* P */
      most_beep, /* Q */
      most_beep, /* R */
      most_beep, /* S */
      most_beep, /* T */
      most_beep, /* U */
      most_beep, /* V */
      most_beep, /* W */
      most_beep, /* X */
      most_beep, /* Y */
      most_beep, /* Z */
      most_beep, /* [ */
      most_beep, /* \ */
      most_beep, /* ] */
      most_beep, /* ^ */
      most_beep, /* _ */
      most_beep, /* ` */
      most_beep, /* a */
      most_beep, /* b */
      most_beep, /* c */
      most_beep, /* d */
      most_beep, /* e */
      most_beep, /* f */
      most_beep, /* g */
      most_beep, /* h */
      most_beep, /* i */
      most_beep, /* j */
      most_beep, /* k */
      most_beep, /* l */
      most_beep, /* m */
      most_beep, /* n */
      other_window_cmd,         /* o */
      most_beep, /* p */
      most_beep, /* q */
      most_beep, /* r */
      most_beep, /* s */
      most_beep, /* t */
      most_beep, /* u */
      most_beep, /* v */
      most_beep, /* w */
      most_beep, /* x */
      most_beep, /* y */
      most_beep, /* z */
      most_beep, /* { */
      most_beep, /* | */
      most_beep, /* } */
      most_beep, /* ~ */
      most_beep  /* ^? */
  };

static void (*ctrl_w_map[128])(void) =
  {
      most_beep, /* ^@ */
      most_beep, /* ^A */
      most_beep, /* ^B */
      most_beep, /* ^C */
      most_beep, /* ^D */
      most_beep, /* ^E */
      most_beep, /* ^F */
      most_beep, /* ^G */
      most_beep, /* ^H */
      most_beep, /* ^I */
      most_beep, /* ^J */
      most_beep, /* ^K */
      most_beep, /* ^L */
      most_beep, /* ^M */
      most_beep, /* ^N */
      most_beep, /* ^O */
      most_beep, /* ^P */
      most_beep, /* ^Q */
      most_beep, /* ^R */
      most_beep, /* ^S */
      most_beep, /* ^T */
      most_beep, /* ^U */
      most_beep, /* ^V */
      most_beep, /* ^W */
      most_beep, /* ^X */
      most_beep, /* ^Y */
      most_beep, /* ^Z */
      most_beep, /* ^[ */
      most_beep, /* ^\ */
      most_beep, /* ^] */
      most_beep, /* ^^ */
      most_beep, /* ^_ */
      most_beep, /*   */
      most_beep, /* ! */
      most_beep, /* " */
      most_beep, /* # */
      most_beep, /* $ */
      most_beep, /* % */
      most_beep, /* & */
      most_beep, /* ' */
      most_beep, /* ( */
      most_beep, /* ) */
      most_beep, /* * */
      most_beep, /* + */
      most_beep, /* , */
      most_beep, /* - */
      most_beep, /* . */
      most_beep, /* / */
      del_window_cmd,           /* 0 */
      one_window_cmd,           /* 1 */
      two_window_cmd,           /* 2 */
      most_beep, /* 3 */
      most_beep, /* 4 */
      most_beep, /* 5 */
      most_beep, /* 6 */
      most_beep, /* 7 */
      most_beep, /* 8 */
      most_beep, /* 9 */
      most_beep, /* : */
      most_beep, /* ; */
      most_beep, /* < */
      most_beep, /* = */
      most_beep, /* > */
      most_beep, /* ? */
      most_beep, /* @ */
      most_beep, /* A */
      most_beep, /* B */
      most_beep, /* C */
      most_beep, /* D */
      most_beep, /* E */
      most_beep, /* F */
      most_beep, /* G */
      most_beep, /* H */
      most_beep, /* I */
      most_beep, /* J */
      most_beep, /* K */
      most_beep, /* L */
      most_beep, /* M */
      most_beep, /* N */
      other_window_cmd,         /* O */
      most_beep, /* P */
      most_beep, /* Q */
      most_beep, /* R */
      most_beep, /* S */
      most_beep, /* T */
      most_beep, /* U */
      most_beep, /* V */
      most_beep, /* W */
      most_beep, /* X */
      most_beep, /* Y */
      most_beep, /* Z */
      most_beep, /* [ */
      most_beep, /* \ */
      most_beep, /* ] */
      most_beep, /* ^ */
      most_beep, /* _ */
      most_beep, /* ` */
      most_beep, /* a */
      most_beep, /* b */
      most_beep, /* c */
      most_beep, /* d */
      most_beep, /* e */
      most_beep, /* f */
      most_beep, /* g */
      most_beep, /* h */
      most_beep, /* i */
      most_beep, /* j */
      most_beep, /* k */
      most_beep, /* l */
      most_beep, /* m */
      most_beep, /* n */
      other_window_cmd, /* o */
      most_beep, /* p */
      most_beep, /* q */
      most_beep, /* r */
      most_beep, /* s */
      most_beep, /* t */
      most_beep, /* u */
      most_beep, /* v */
      most_beep, /* w */
      most_beep, /* x */
      most_beep, /* y */
      most_beep, /* z */
      most_beep, /* { */
      most_beep, /* | */
      most_beep, /* } */
      most_beep, /* ~ */
      most_beep  /* ^? */
  };

static void (*ctrl_k_map[128])(void) =
  {
      most_beep, /* ^@ */
      most_beep, /* ^A */
      set_mark_cmd,             /* ^B */
      most_beep, /* ^C */
      most_beep, /* ^D */
      most_beep, /* ^E */
      most_beep, /* ^F */
      most_beep, /* ^G */
      most_beep, /* ^H */
      most_beep, /* ^I */
      goto_mark_cmd,            /* ^J */
      most_beep, /* ^K */
      most_beep, /* ^L */
      goto_mark_cmd,            /* ^M */
      most_beep, /* ^N */
      most_beep, /* ^O */
      most_beep, /* ^P */
      most_beep, /* ^Q */
      most_beep, /* ^R */
      most_beep, /* ^S */
      most_beep, /* ^T */
      most_beep, /* ^U */
      most_beep, /* ^V */
      most_beep, /* ^W */
      most_beep, /* ^X */
      most_beep, /* ^Y */
      most_beep, /* ^Z */
      most_beep, /* ^[ */
      most_beep, /* ^\ */
      most_beep, /* ^] */
      most_beep, /* ^^ */
      most_beep, /* ^_ */
      most_beep, /*   */
      most_beep, /* ! */
      most_beep, /* " */
      most_beep, /* # */
      most_beep, /* $ */
      most_beep, /* % */
      most_beep, /* & */
      most_beep, /* ' */
      most_beep, /* ( */
      most_beep, /* ) */
      most_beep, /* * */
      most_beep, /* + */
      most_beep, /* , */
      most_beep, /* - */
      most_beep, /* . */
      most_beep, /* / */
      most_beep, /* 0 */
      most_beep, /* 1 */
      most_beep, /* 2 */
      most_beep, /* 3 */
      most_beep, /* 4 */
      most_beep, /* 5 */
      most_beep, /* 6 */
      most_beep, /* 7 */
      most_beep, /* 8 */
      most_beep, /* 9 */
      most_beep, /* : */
      most_beep, /* ; */
      most_beep, /* < */
      most_beep, /* = */
      most_beep, /* > */
      most_beep, /* ? */
      most_beep, /* @ */
      most_beep, /* A */
      most_beep, /* B */
      most_beep, /* C */
     most_beep, /* extended_cmd_cmd, */        /* D */
      most_exit_most,                 /* E */
      most_beep, /* F */
      find_file_cmd,            /* G */
      most_beep, /* H */
      most_beep, /* I */
      most_beep, /* J */
      most_beep, /* K */
      most_beep, /* L */
      set_mark_cmd,             /* M */
      most_beep, /* N */
      most_beep, /* O */
      most_beep, /* P */
      most_beep, /* Q */
      most_beep, /* R */
      most_beep, /* S */
      most_beep, /* T */
      most_beep, /* U */
      most_beep, /* V */
      most_beep, /* W */
      most_beep, /* X */
      most_beep, /* Y */
      most_beep, /* Z */
      most_beep, /* [ */
      most_beep, /* \ */
      most_beep, /* ] */
      most_beep, /* ^ */
      most_beep, /* _ */
      most_beep, /* ` */
      most_beep, /* a */
      most_beep, /* b */
      most_beep, /* c */
      most_beep, /* extended_cmd_cmd,  */       /* d */
      most_exit_most,                 /* e */
      most_beep, /* f */
      find_file_cmd,            /* g */
      most_beep, /* h */
      most_beep, /* i */
      most_beep, /* j */
      most_beep, /* k */
      most_beep, /* l */
      set_mark_cmd,             /* m */
      most_beep, /* n */
      most_beep, /* o */
      most_beep, /* p */
      most_beep, /* q */
      most_beep, /* r */
      most_beep, /* s */
      most_beep, /* t */
      most_beep, /* u */
      most_beep, /* v */
      most_beep, /* w */
      most_beep, /* x */
      most_beep, /* y */
      most_beep, /* z */
      most_beep, /* { */
      most_beep, /* | */
      most_beep, /* } */
      most_beep, /* ~ */
      most_beep  /* ^? */
  };

static void (*esc_O_map[128])(void) =
  {
      most_beep, /* ^@ */
      most_beep, /* ^A */
      most_beep, /* ^B */
      most_beep, /* ^C */
      most_beep, /* ^D */
      most_beep, /* ^E */
      most_beep, /* ^F */
      most_beep, /* ^G */
      most_beep, /* ^H */
      most_beep, /* ^I */
      most_beep, /* ^J */
      most_beep, /* ^K */
      most_beep, /* ^L */
      most_beep, /* ^M */
      most_beep, /* ^N */
      most_beep, /* ^O */
      most_beep, /* ^P */
      most_beep, /* ^Q */
      most_beep, /* ^R */
      most_beep, /* ^S */
      most_beep, /* ^T */
      most_beep, /* ^U */
      most_beep, /* ^V */
      most_beep, /* ^W */
      most_beep, /* ^X */
      most_beep, /* ^Y */
      most_beep, /* ^Z */
      most_beep, /* ^[ */
      most_beep, /* ^\ */
      most_beep, /* ^] */
      most_beep, /* ^^ */
      most_beep, /* ^_ */
      most_beep, /*   */
      most_beep, /* ! */
      most_beep, /* " */
      most_beep, /* # */
      most_beep, /* $ */
      most_beep, /* % */
      most_beep, /* & */
      most_beep, /* ' */
      most_beep, /* ( */
      most_beep, /* ) */
      most_beep, /* * */
      most_beep, /* + */
      most_beep, /* , */
      most_beep, /* - */
      most_beep, /* . */
      most_beep, /* / */
      dec_extended_map_cmd,     /* 0 */
      dec_extended_map_cmd,     /* 1 */
      dec_extended_map_cmd,     /* 2 */
      dec_extended_map_cmd,     /* 3 */
      dec_extended_map_cmd,     /* 4 */
      dec_extended_map_cmd,     /* 5 */
      dec_extended_map_cmd,     /* 6 */
      dec_extended_map_cmd,     /* 7 */
      dec_extended_map_cmd,     /* 8 */
      dec_extended_map_cmd,     /* 9 */
      most_beep, /* : */
      most_beep, /* ; */
      most_beep, /* < */
      most_beep, /* = */
      most_beep, /* > */
      most_beep, /* ? */
      most_beep, /* @ */
      previous_line_cmd,        /* A */
      next_line_cmd,            /* B */
      page_right_cmd,           /* C */
      page_left_cmd,            /* D */
      most_beep, /* E */
      most_beep, /* F */
      most_beep, /* G */
      most_beep, /* H */
      most_beep, /* I */
      most_beep, /* J */
      most_beep, /* K */
      most_beep, /* L */
      next_line_cmd, /* M */
      most_beep, /* N */
      most_beep, /* O */
      pf1_map_cmd, /* P */	/* PF1 */
      help_cmd, /* Q */ /* PF2 */
      edt_find_next_cmd, /* R */ /* PF3 */
      most_beep, /* S */ /* PF4 */
      most_beep, /* T */
      most_beep, /* U */
      most_beep, /* V */
      most_beep, /* W */
      most_beep, /* X */
      most_beep, /* Y */
      most_beep, /* Z */
      most_beep, /* [ */
      most_beep, /* \ */
      most_beep, /* ] */
      most_beep, /* ^ */
      most_beep, /* _ */
      most_beep, /* ` */
      most_beep, /* a */
      most_beep, /* b */
      most_beep, /* c */
      most_beep, /* d */
      most_beep, /* e */
      most_beep, /* f */
      most_beep, /* g */
      most_beep, /* h */
      most_beep, /* i */
      most_beep, /* j */
      most_beep, /* k */
      most_beep, /* l */
      most_beep, /* m */
      set_mark_cmd, /* n */
      most_beep, /* o */
      edt_line_cmd, /* p */ /* KP0 */
      most_beep, /* q */ /* KP1 */
      most_beep, /* r */ /* KP2 */
      most_beep, /* s */ /* KP3 */
      edt_forward_cmd, /* t */ /* KP4 */
      edt_back_cmd, /* u */ /* KP5 */
      most_beep, /* v */ /* KP6 */
      most_beep, /* w */ /* KP7 */
      edt_page_cmd, /* x */ /* KP8 */
      most_beep, /* y */ /* KP9 */
      most_beep, /* z */
      most_beep, /* { */
      most_beep, /* | */
      most_beep, /* } */
      most_beep, /* ~ */
      most_beep  /* ^? */
  };

static void (*pf1_map[128])(void) =	/* Gold */
  {
      most_beep, /* ^@ */
      most_beep, /* ^A */
      most_beep, /* ^B */
      most_beep, /* ^C */
      most_beep, /* ^D */
      most_beep, /* ^E */
      most_beep, /* ^F */
      most_beep, /* ^G */
      most_beep, /* ^H */
      most_beep, /* ^I */
      most_beep, /* ^J */
      most_beep, /* ^K */
      most_beep, /* ^L */
      most_beep, /* ^M */
      most_beep, /* ^N */
      most_beep, /* ^O */
      most_beep, /* ^P */
      most_beep, /* ^Q */
      most_beep, /* ^R */
      most_beep, /* ^S */
      most_beep, /* ^T */
      most_beep, /* ^U */
      most_beep, /* ^V */
      most_beep, /* ^W */
      most_beep, /* ^X */
      most_beep, /* ^Y */
      most_beep, /* ^Z */
      pf1_esc_map_cmd, /* ^[ */
      most_beep, /* ^\ */
      most_beep, /* ^] */
      most_beep, /* ^^ */
      most_beep, /* ^_ */
      most_beep, /*   */
      most_beep, /* ! */
      most_beep, /* " */
      most_beep, /* # */
      most_beep, /* $ */
      most_beep, /* % */
      most_beep, /* & */
      most_beep, /* ' */
      most_beep, /* ( */
      most_beep, /* ) */
      most_beep, /* * */
      most_beep, /* + */
      most_beep, /* , */
      most_beep, /* - */
      most_beep, /* . */
      most_beep, /* / */
      digit_arg_cmd, /* 0 */
      digit_arg_cmd, /* 1 */
      digit_arg_cmd, /* 2 */
      digit_arg_cmd, /* 3 */
      digit_arg_cmd, /* 4 */
      digit_arg_cmd, /* 5 */
      digit_arg_cmd, /* 6 */
      digit_arg_cmd, /* 7 */
      digit_arg_cmd, /* 8 */
      digit_arg_cmd, /* 9 */
      most_beep, /* : */
      most_beep, /* ; */
      most_beep, /* < */
      most_beep, /* = */
      most_beep, /* > */
      most_beep, /* ? */
      most_beep, /* @ */
      most_beep, /* A */
      most_beep, /* B */
      most_beep, /* C */
      most_beep, /* D */
      most_beep, /* E */
      most_beep, /* F */
      most_beep, /* G */
      most_beep, /* H */
      most_beep, /* I */
      most_beep, /* J */
      most_beep, /* K */
      most_beep, /* L */
      most_beep, /* M */
      most_beep, /* N */
      one_window_cmd, /* O */
      most_beep, /* P */
      most_exit_most, /* Q */
      most_beep, /* R */
      sys_spawn_cmd, /* S */
      most_beep, /* T */
      most_beep, /* U */
      del_window_cmd, /* V */
      most_beep, /* W */
      two_window_cmd, /* X */
      most_beep, /* Y */
      most_beep, /* Z */
      most_beep, /* [ */
      most_beep, /* \ */
      most_beep, /* ] */
      most_beep, /* ^ */
      most_beep, /* _ */
      most_beep, /* ` */
      most_beep, /* a */
      most_beep, /* b */
      most_beep, /* c */
      most_beep, /* d */
      most_beep, /* e */
      most_beep, /* f */
      most_beep, /* g */
      most_beep, /* h */
      most_beep, /* i */
      most_beep, /* j */
      most_beep, /* k */
      most_beep, /* l */
      most_beep, /* m */
      most_beep, /* n */
      one_window_cmd, /* o */
      most_beep, /* p */
      most_exit_most, /* q */
      most_beep, /* r */
      sys_spawn_cmd, /* s */
      most_beep, /* t */
      most_beep, /* u */
      del_window_cmd, /* v */
      most_beep, /* w */
      two_window_cmd, /* x */
      most_beep, /* y */
      most_beep, /* z */
      most_beep, /* { */
      most_beep, /* | */
      most_beep, /* } */
      most_beep, /* ~ */
      most_beep  /* ^? */
  };


static void ctrl_x_map_cmd(void)
{
    char ch;

    ch = most_getkey();
    (*ctrl_x_map[ (int) ch ])();
}

static void ctrl_k_map_cmd(void)
{
    char ch;

    ch = most_getkey();
    (*ctrl_k_map[ (int) ch ])();
}

static void ctrl_w_map_cmd(void)
{
    char ch;

    ch = most_getkey();
    (*ctrl_w_map[ (int) ch ])();
}

static void O_map_cmd(void)
{
    char ch;

    ch = most_getkey();
    Last_Char = ch;
    (*esc_O_map[ (int) ch ])();
}

static void esc_map_cmd(void)
{
    char ch;

    ch = most_getkey();
    Last_Char = ch;
    (*escape_map[ (int) ch ])();
}

/* weird sequences of form ^[[n~ where n is an integer */
static void dec_extended_map_cmd(void)
{
    char ch, numstr[5];
    int i, num;
    
    ch = Last_Char;  /* should be integer */
    i = 0;
    numstr[i++] = ch;
 
    while (ch = most_getkey(), isdigit(ch)) numstr[i++] = ch;
    if (ch == '~')
      {
          numstr[i++] =  '\0';
          sscanf(numstr,"%d",&num);
          switch (num)
            {
              case 5:
                page_up_cmd(); break; /* prev screen */
              case 6:
                page_down_cmd(); break; /* next screen */
              case 1:
                search_cmd(); break; /* find */
              case 4:
                set_mark_cmd(); break; /* select */
              case 2:   
                goto_mark_cmd(); break; /* insert here */
              case 28:
                help_cmd(); break; /* Help */
              case 29:  /* do */
                /* extended_cmd_cmd(); break; */
              default:
                most_beep(); break;
            }
      }
    else most_beep();
}

/* weird sequences of form ^[[n~ where n is an integer */
static void pf1_esc_map_cmd(void)
{
    char ch;
    
    Last_Char = ch = most_getkey();
    switch (ch)
	{
	case 'O':
	    Last_Char = ch = most_getkey();
	    switch (ch)
		{
		case 't': /* KP4 */
		    end_of_buffer_cmd(); break;
		case 'u': /* KP5 */
		    top_of_buffer_cmd(); break;
		case 'n': /* KP7 */
		    goto_mark_cmd(); break;
		case 'R': /* PF3 */
		    edt_find_cmd(); break;
		case 'w': /* KP7 */
		   /* extended_cmd_cmd(); break; */
		default :
		    most_beep(); break;
		}
	    break;
	case '[':
	    Last_Char = ch = most_getkey();
	    switch (ch)
		{
		case 'A':
		    other_window_cmd(); break;
		case 'B':
		    other_window_cmd(); break;
		case 'C':
		    page_right_cmd(); break;
		case 'D':
		    page_left_cmd(); break;
		default :
		    most_beep(); break;
		};
	    break;
	default :
            most_beep(); break;
	}
}

static void pf1_map_cmd(void)
{
    char ch;

    ch = most_getkey();
    Last_Char = ch;
    (*pf1_map[ (int) ch ])();
}
