#include "hd.h"
#include "mydir.h"
#include "command.h"
#include <pwd.h>
#include <grp.h>

#define SHIFT1	13
#define SHIFT2	6
#define SHIFT3	3
#define MASK	07

/* long listing of a file */
static char *mchar[3][8] = 
{
	"---", "--x", "-w-", "-wx",
	"r--", "r-x", "rw-", "rwx",
	"--S", "--s", "-wS", "-ws",
	"r-S", "r-s", "rwS", "rws",
	"--T", "--t", "-wT", "-wt",
	"r-T", "r-t", "rwT", "rwt"
} ;

static char fformat[8] = 
{
#ifdef	VENIX
	'0', '1', '2', '3', ' ', 'c', 'd', 'b'
#else
#ifdef	V6
	'0', '1', '2', '3', ' ', 'c', 'd', 'b'
#else
	'p', 'c', 'd', 'b', '-', 'l', 's', '?'
#endif
#endif
} ;

int didlong, longtoggle;

char *pfstatus(fname, key)
char *fname; int key;
{
    register mode, n;
    struct passwd *getpwuid();
    static struct passwd *p;
    static struct group *g;
    static char s[STRMAX], t[STRMAX], *q;
    FILE *fp, *popen();
#ifdef	SYMLINK
    int sflag;
#endif

    if (key > 1) {
	/* bug: we should handle single quotes in filenames, too */
	sprintf(s, "%s '%s'", FILECMD, fname);
	if ((fp = popen(s, "r")) == NULL) {
	    printf("Cannot pipe from \"%s\"", FILECMD);
	    return 0;
	}
	if (fgets(t, STRMAX, fp) != NULL) {
	    for (q = t, n = 0;
	      !(*q == '\0' || *q == ':' && (*(q+1) == '\t' || *(q+1) == ' '));
	      q++, n++);
	    if (*q != '\0') { q++; n++; }
	    for (; *q == '\t' || *q == ' '; q++, n++);
	    if (*q == '\0') { q = t; n = 0; }
	    q[(57+xoff < STRMAX-n-1) ? 57+xoff : STRMAX-n-1] = '\0';
	    unbufout();
	    printf("%s", q);
	    bufout();
	}
	pclose(fp);
	return 0;
    }

#ifdef	SYMLINK
    sflag = 0;
    if (lstat (fname, &scr_stb)) 
#else
    if (stat (fname, &scr_stb)) 
#endif
    {
	printf ("Cannot access file");
	return 0;
    }
    mode = scr_stb.st_mode;

#ifdef	SYMLINK
	if ((mode&S_IFLNK) == S_IFLNK) {
		mode = readlink(fname, s, STRMAX-1);	
		if (mode == -1) {
			printf ("Cannot read symlink");
			return 0;
		}
		s[mode] = 0;
		sflag++;
		if (key) {
			if (stat (fname, &scr_stb)) {
				printf ("Cannot access");
				return s;
			}
			mode = scr_stb.st_mode;
		} else {
			printf ("%s", s);
			return s;
		}
	}
#endif

    printf ("%c%s%s%s%s%2d",
	fformat [(mode >> SHIFT1) & MASK],
	mchar [(mode & S_ISUID) != 0] [(mode >> SHIFT2) & MASK],
	mchar [(mode & S_ISGID) != 0] [(mode >> SHIFT3) & MASK],
	mchar [(mode & S_ISVTX) ? 2 : 0] [mode & MASK],
	scr_stb.st_nlink > 99 ? "" : " ",
	scr_stb.st_nlink);
	/* dyt */
    if (longtoggle == 0) {
	if (p == 0 || p->pw_uid != scr_stb.st_uid)
	    p = getpwuid(scr_stb.st_uid);
	if (p)
	    printf(" %8s", p->pw_name);
	else
	    printf(" %8d", scr_stb.st_uid);
    } else if (longtoggle == 1) {
	if (g == 0 || g->gr_gid != scr_stb.st_gid)
	    g = getgrgid(scr_stb.st_gid);
	if (g)
	    printf(" %8s", g->gr_name);
	else
	    printf(" %8d", scr_stb.st_gid);
    } else
	printf(" %8s", "other");
    mode &= S_IFMT;
    if (mode == S_IFCHR || mode == S_IFBLK)
	printf ("%5d, %3d",
#ifdef	V6
	major (scr_stb.st_addr[0]), minor (scr_stb.st_addr[0]));
#else
	major (scr_stb.st_rdev), minor (scr_stb.st_rdev));
#endif
    else
#ifdef	V6
	printf ("%10ld", (((long)scr_stb.st_size0&0377)<<16L)
		+ (unsigned)scr_stb.st_size1);
#else
	printf ("%10ld", scr_stb.st_size);
#endif
    if (longtoggle == 0)
	printf (" %.24s", ctime (&scr_stb.st_mtime));
    else if (longtoggle == 1)
	printf (" %.24s", ctime (&scr_stb.st_atime));
    else
	printf (" %.24s", ctime (&scr_stb.st_ctime));
#ifdef	SYMLINK
    return (sflag ? s : 0);
#endif
}

/* long listing without following symlinks */
longlist()
{
	return listlong(0);
}

/* long listing following symlinks */
llonglist()
{
	return listlong(1);
}

/* listing using file(1) command */
filelist()
{
	longtoggle = 2;
	return listlong(2);
}

listlong (key) int key;
{		/* long listing for entire page */
    register i, j;
	
    bufout ();
    j = pgend();
    for (i=0; i < j; i++)
	longfile (i, key);
    didlong = j;
    longtoggle = (longtoggle + 1) % 3;
    unbufout ();

    return CMD_DATE;	/* Run date command */
}

longfile (index, key) int index, key;
{
    register char *s;
    register int i;
    int putch();

    if (pageoff) {
	cpage += pageoff;
	pageoff = 0;
	i = column;
	column = 1;	/* Display only current page */
	dispdir(0);
	column = i;
    }
    atfile (index, 23);
    if (CE)
	tputs(CE, 0, putch);
    s = pfstatus (filename (index), key);
#ifdef	SYMLINK
    if (s && key == 1 && xoff >= 10)
	printf(" %-18.18s", s);
#endif
}

/* Warning: some systems have macros which define these in <sys/types.h> */
#ifdef	 MACMAJOR
major(i)
dev_t i;
{
    return (i>>8);
}

minor(i)
dev_t i;
{
    return (i&0377);
}
#endif
