/* softlabel.h --- This is the header file for the Softlabel class

    Copyright (C) 1993  A.Matthias

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _softlabel_h
#define _softlabel_h

extern "C" {
#include <ncurses/ncurses.h>
}

#include "config.h"
#include "globals.h"

class Softlabel
  {
  private:
    WINDOW *wptr;      /* Our window "handle" */
    char items[128][128];   /* Internal copy of **newintems */

  public:
    Softlabel( char **newitems );
    ~Softlabel();
    void show( void );
    void hide( void );
    void change( char **newitems );
  };

#endif
