/* nc.cc  ---  Main file
   
   Copyright (C) 1993, 1994  Andreas Matthias
   Contact 
     amatthi1@gwdg.de
     andreas_matthias@rollo.central.de
     2:2437/210.43 fidonet

   or the support address
     nc@gwdp88.gwdg.de

   (see the manpage for details).

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/stat.h>
extern "C" {
#include <ncurses/ncurses.h>
}
#include <term.h>
#include <sys/wait.h>


#include "globals.h"     // Global definitions
#include "config.h"      // Site-dependent setup options
#include "TDir.h"        // Directory manager class
#include "TList.h"       // Linked list class
#include "softlabel.h"   // Bottom line key labels 
#include "TElem.h"       // Directory entry definition 
#include "TPrompt.h"     // Command line emulation
#include "welcome.h"     // Copyright message 
#include "TFileWindow.h" // File window class
#include "THistory.h"    // History list class
#include "THistElem.h"   // One history list element
#include "readkeys.h"    // Softlabel assignment
#include "TArg.h"        // Class that prompts user for command args
#include "TClock.h"      // Clock functions class
#include "lineedit.h"    // Line editing
#include "TMsgDlg.h"     // Message dialog class


// reset_tty() resets the tty state (needed after emacs 19).
void reset_tty( WINDOW *std, TFileWindow *Left, TFileWindow*Right, 
	       TPrompt *Prompt, TClock *Clock )
{

  if (RTC==1) keypad( Clock->getwptr(), TRUE );
  keypad( std, TRUE ); 
  keypad( Left->getwptr(), TRUE ); 
  keypad( Right->getwptr(), TRUE ); 
  keypad( Prompt->getwptr(), TRUE );
  meta( std, TRUE ); 
  meta( Left->getwptr(), TRUE ); 
  meta( Right->getwptr(), TRUE ); 
  meta( Prompt->getwptr(), TRUE );
  cbreak();
  noecho();
}




int main( int argc, char *argv[] )
{
  WINDOW *std;          // The whole screen
  char *items[11];
  char *ctrl_items[] = { "Ctrl-X:", "1 ExecOnly", "2 BuildTree", "3 HexView", 
			 "4  ", 
			 "5  ", "6  ", "7  ", "8  ", "0 Tree", "" };
  char cwd[PATH_MAX];
  bool waitflag;        // Wait for key before return ?
  bool ul_dirty;        // userline has changed and must be repainted
  bool abortcmd;        // Don't execute the prepared command line
  bool program_exec;    // Was a program executed, or was it another command?
  int  ulpos = 0;       // Position of softcursor in userline
  int sh_exitcode;
  
  welcome();
  inithome();
  if ( readkeys() )     // Fills the global ;-) structure "action"
    {
      fprintf( stderr, "Fatal: File %s%s not found\n", homedir, KEYFILE );
      exit( 1 );
    }
  std=initscr();
  // Copy labels to expected Softlabel format
  for ( char c='1'; c<='8'; c++ ) 
    {
      items[c-'0']=new( char[11] );
      //    if ( action[c].defined==TRUE )
      //      strcpy( items[c-'0'], action[c].label );
      //    else 
      //      strcpy( items[c-'0'], " " );
    }
  items[0] =new( char[11] );
  items[9] =new( char[11] );
  items[10]=new( char[11] );  
  
  // Ignore any labels that are defined in .nc_keys, because
  // the built-in functions are no longer redefinable
  strcpy( items[0],  "ESC:" );
  strcpy( items[1], "1 Help" );
  strcpy( items[2], " " );      /* one space = don't display this one */
  strcpy( items[3], "3 View" );
  strcpy( items[4], "4 Edit" );
  strcpy( items[5], "5 Copy" );
  strcpy( items[6], "6 RenMv" );
  strcpy( items[7], "7 MkDir" );
  strcpy( items[8], "8 Del" );
  strcpy( items[9], "0 Quit" );
  strcpy( items[10], "" );
  
  Softlabel Footer( items );
  TFileWindow Right( std, RIGHT ), Left( std, LEFT );  
  TFileWindow *Active, *Nonactive;
  TPrompt Prompt;
  THistory  History;
  THistElem HistElem;
  
  leaveok( std, TRUE );
   
  Active = &Left;
  Nonactive = &Right;
  Left.fill( TRUE );
  Right.fill( TRUE );
  Footer.show();
  Prompt.setPS1( Active->telldir( cwd ) );
  Prompt.newprompt();
  
  TClock Clock;
  if ( RTC == 1 ) 
    {
      Clock.stop();
      keypad( Clock.getwptr(), TRUE );
    }
  
  char userline[PATH_MAX];
  
  /*** Here is the main event loop ***/
  int ch;
  
  do
    {
    loop:
      userline[0]='\0';
      strcpy( HistElem.cmd, "" );
      History.eol();             // Go to end of history list
      ulpos = 0;
      waitflag=TRUE;
      ul_dirty=TRUE;
      abortcmd=FALSE;
      
      do
	{
	  reset_tty( std, &Left, &Right, &Prompt, &Clock );
	  flushinp();
	  
	  if (RTC==1) Clock.start();
	  if ( Left.isactive() ) 
	    {
	      Active=&Left;
	      Nonactive=&Right;
	    }
	  else 
	    {
	      Active=&Right;
	      Nonactive=&Left;
	    }
	  
	  if ( ul_dirty == TRUE )
	    {
	      werase( Prompt.getwptr() );
#ifdef BUILTIN_PROMPT
	      Prompt.setPS1( Active->telldir( cwd ) );
#endif
	      Prompt.prompt();
	      wputline( Prompt.getwptr(), userline, ulpos, NORMAL );
	      Prompt.show();
	      ul_dirty=FALSE;
	    }
	  noecho();
	  
	  ch = wgetch( Active->getwptr() );
	  
	  if ( RTC == 1 ) Clock.stop();
	  if ( ch == TAB_CHAR )
	    {
	      ul_dirty=TRUE;
	      if ( Active == &Right )
		{ 
		  Active=&Left; 
		  Nonactive=&Right; 
		  Right.inactivate(); 
		  Left.activate(); 
		}
	      else
		{ 
		  Active=&Right; 
		  Nonactive=&Left; 
		  Left.inactivate(); 
		  Right.activate(); 
		}
	      continue;
	    }
	  
	  ul_dirty=FALSE;
	  
	  if ( ch == KEY_UP )
	    {
	      Active->sethilight( Active->gethilight() - 1 );
	      ch = 0;
	      continue;
	    }
	  if ( ch == KEY_DOWN )
	    {
	      Active->sethilight( Active->gethilight() + 1 );
	      ch = 0;
	      continue;
	    }
	  
	  if ( ch == KEY_PPAGE )
	    {
	      Active->pageup();
	      ch = 0;
	      continue;
	    }
	  if ( ch == KEY_NPAGE )
	    {
	      Active->pagedown();
	      ch = 0;
	      continue;
	    }
	  
	  // If command line is empty, cursor keys are for TFileWindow,
	  // else they are for command line editing
	  
	  if ( ch == KEY_LEFT )
	    if ( strlen( userline ) == 0 )
	      {
		Active->sethilight( 0 );
		ul_dirty=FALSE;
                continue;
	      }
	    else   // cursor one character to the left
	      {
		if (ulpos>0) ulpos--;
		ul_dirty=TRUE;
		continue;
	      }
	  
	  if ( ch == KEY_RIGHT )
	    if ( strlen( userline ) == 0 )
	      {
		Active->sethilight( Active->getmaxnum() );
		ul_dirty=FALSE;
		continue;
	      }
	    else   // cursor one character to the right
	      {
		if (ulpos<(int)strlen(userline)) ulpos++;
		ul_dirty=TRUE;
		continue;
	      }
	  
	  
	  // A menu selection
	  if ( ( ch==ESCAPE_CHAR ) || ( (ch>=KEY_F0) && (ch<=KEY_F(10)) ) )
	    {
	      bool doit = FALSE;   // doit==TRUE: Execute this line immediately
	      int escaped[3];
	      bool fkey = TRUE;

	      if ( ch == ESCAPE_CHAR ) 
		{
		  fkey = FALSE;
		  escaped[0] = wgetch( Active->getwptr() );
		  escaped[1] = '\0';
		}
	      else
		escaped[0] = ch;

	      switch( escaped[0] )
		{
		  char filename[PATH_MAX], dir[PATH_MAX], localname[PATH_MAX];
		  char defaults[PATH_MAX], arg[PATH_MAX], prtext[PATH_MAX];
		  
		case '1':                     /* builtin help */
		case KEY_F(1):
		  sprintf( userline, "man nc" );
		  doit=TRUE;
		  waitflag=FALSE;
		  break;

		case '3':                     /* builtin view */
		case KEY_F(3):
		  strcpy( filename, Active->gethilightedfname() );
		  Active->telldir( dir );
		  if ( strncmp( dir, "r0:", 3 ) != 0 )
		    // local filename
		    {
		      sprintf( userline, "%s %s", PAGER, filename );
		    }
		  else
		    // remote filename
		    {
		      sprintf( localname, "%s%s", localtmpdir, filename );
		      Active->RemGet( filename, localname );		    
		      sprintf( userline, "%s %s", PAGER, localname );
		    }
		  
		  doit=TRUE;
		  waitflag=FALSE;
		  break;
		  
		case '4':                     /* builtin edit */
		case KEY_F(4):
		  strcpy( filename, Active->gethilightedfname() );
		  Active->telldir( dir );
		  if ( strncmp( dir, "r0:", 3 ) != 0 )
		    // local filename
		    {
		      sprintf( userline, "%s %s", EDITOR, filename );
		      doit=TRUE;
		      waitflag=FALSE;
		      
		    }
		  else
		    // remote filename
		    {
		      sprintf( localname, "%s%s", localtmpdir, filename );
		      Active->RemGet( filename, localname );		    
		      sprintf( userline, "%s %s", EDITOR, localname );
		      nocbreak();
		      system( "clear" );
		      Footer.hide();
		      system( userline );
		      reset_tty( std, &Left, &Right, &Prompt, &Clock );
		      
		      TMsgDlg Dialog( "Remote edit", TRUE );
		      Dialog.print( "Write changed file to remote system?" );
		      if ( Dialog.getinput() == TRUE )
			Active->RemPut( localname, filename );
		      
		      // Now repaint everything
		      system( "clear" );
		      wclear( std );
		      wrefresh( std );
		      Active->fill( TRUE );
		      Nonactive->repaint();
		      Footer.show();
		      Prompt.newprompt();
		      
		      strcpy( userline, "" );
		      ulpos = 0;
		      
		      continue;
		    }
		  break;
		  
		case '5':                     /* builtin copy */
		case KEY_F(5):
		  waitflag=TRUE;
		  doit=TRUE;
		  Nonactive->telldir( defaults );			
		  strcpy( prtext, "Copy destination" );
		  {
		    TArg Arg( prtext, defaults );
		    Arg.show();
		    if ( Arg.input( arg ) == NULL )
		      {
			abortcmd=TRUE;
			ul_dirty=TRUE;
			doit=FALSE;
			waitflag=TRUE;
		      }
		    else
		      abortcmd = FALSE;

		    Active->top();
		    Nonactive->top();
		    if ( abortcmd == TRUE ) continue;
		  }  
		  Active->telldir( dir );
		  if ( strncmp( dir, "r0:", 3 ) != 0 )
		    // local filename
		    {
		      // Build a temporary parameter file
		      // Destination is last parameter
		      Active->makepfile( "m2", arg );
		      sprintf( userline, "cp `cat %s%s` %s", localtmpdir, 
			      PARAMFILE, arg );
		      doit=TRUE;
		      waitflag=FALSE;
		    }
		  else
		    // remote filename *** Unterscheiden nach Src/Trg remote?
		    {
		      // Build a temporary parameter file
		      // Destination is not in list
		      Active->makepfile( "m0", arg );		      

		      // Copy the files
		      char fparname[PATH_MAX];
		      char fname[PATH_MAX];
		      char localname[PATH_MAX];
		      
		      sprintf( fparname, "%s%s", localtmpdir, PARAMFILE );
		      ifstream fpar( fparname );

		      // All the parameters are in one line
		      while ( fpar )
			{
			  fpar >> fname;
			  strcpy( localname, fname );
			  if ( strcmp( fname, "" ) != 0 )
			    Active->RemGet( fname, localname );
			}

		      fpar.close();
		      Active->fill( TRUE );
		      // top() is needed if errors occured during rmdir
		      // to repaint the frame
		      Active->top();
		      Nonactive->top();
		      continue;


		      
		      
		      strcpy( userline, "" );
		      ulpos = 0;
		      continue;
		    }
		  break;
		  
		case '6':                     /* builtin move */
		case KEY_F(6):
		  waitflag=TRUE;
		  doit=TRUE;
		  Nonactive->telldir( defaults );			
		  strcpy( prtext, "Move destination" );
		  {
		    TArg Arg( prtext, defaults );
		    Arg.show();
		    if ( Arg.input( arg ) == NULL )
		      {
			abortcmd=TRUE;
			ul_dirty=TRUE;
			doit=FALSE;
			waitflag=TRUE;
		      }
		    else
		      abortcmd = FALSE;

		    Active->top();
		    Nonactive->top();
		    if ( abortcmd == TRUE ) continue;
		  }  
		  Active->telldir( dir );
		  if ( strncmp( dir, "r0:", 3 ) != 0 )
		    // local filename
		    {
		      // Build a temporary parameter file in $HOME
		      // Destination is last parameter
		      Active->makepfile( "m2", arg );
		      sprintf( userline, "mv `cat %s%s` %s", localtmpdir, 
			      PARAMFILE, arg );
		      doit=TRUE;
		      waitflag=FALSE;
		    }
		  else
		    {
		      // Build a temporary parameter file in $HOME
		      // Destination is not in list
		      Active->makepfile( "m0", arg );
		      
		      
		      
		      strcpy( userline, "" );
		      ulpos = 0;
		      continue;
		    }
		  break;
		  
		case '7':                     /* builtin mkdir */
		case KEY_F(7):
		  waitflag=TRUE;
		  doit=TRUE;
		  strcpy( defaults, "" );
		  strcpy( prtext, "Make new directory" );
		  {
		    TArg Arg( prtext, defaults );
		    Arg.show();
		    if (( Arg.input( arg ) == NULL ) ||
			( strcmp( arg, "" ) == 0 ) )
		      {
			abortcmd=TRUE;
			ul_dirty=TRUE;
			doit=FALSE;
			waitflag=TRUE;
		      }
		    else
		      abortcmd = FALSE;

		    Active->top();
		    Nonactive->top();
		    if ( abortcmd == TRUE ) continue;
		  }  
		  Active->telldir( dir );
		  if ( strncmp( dir, "r0:", 3 ) != 0 )
		    // local filename
		    {
		      mkdir( arg, 0777 );
		      Active->fill( TRUE );
		      Nonactive->repaint();
		      continue;
		    }
		  else
		    {
		      // Build a temporary parameter file in $HOME
		      // Destination is not in list
		      Active->makepfile( "m0", arg );
		      
		      
		      
		      strcpy( userline, "" );
		      ulpos = 0;
		      continue;
		    }
		  break;
		  		  
		case '8':                     /* builtin delete */
		case KEY_F(8):
		  waitflag=TRUE;
		  doit=TRUE;
		  strcpy( defaults, "n" );			
		  strcpy( prtext, "Delete marked files? (y/n)" );
		  {
		    TArg Arg( prtext, defaults );
		    Arg.show();
		    if (( Arg.input( arg ) == NULL ) ||
			( strcmp( arg, "n" ) == 0 ) )
		      {
			abortcmd=TRUE;
			ul_dirty=TRUE;
			doit=FALSE;
			waitflag=TRUE;
		      }
		    else
		      abortcmd = FALSE;

		    Active->top();
		    Nonactive->top();
		    if ( abortcmd == TRUE ) continue;
		  }  
		  Active->telldir( dir );
		  if ( strncmp( dir, "r0:", 3 ) != 0 )
		    // local filename
		    {
		      // Build a temporary parameter file in $HOME
		      Active->makepfile( "m0", arg );

		      // Remove the files or directories
		      char fparname[PATH_MAX];
		      char fname[PATH_MAX], tmp[PATH_MAX];
		      
		      sprintf( fparname, "%s%s", localtmpdir, PARAMFILE );
		      ifstream fpar( fparname );

		      // All the parameters are in one line
		      while ( fpar )
			{
			  fpar >> fname;

			  if ( strcmp( fname, "" ) != 0 )
			    if ( unlink( fname ) != 0 )
			      if ( (errno != EISDIR) && (errno != EPERM) )
				{
				  TMsgDlg Dialog( "File remove error", TRUE );
				  Dialog.print( sys_errlist[errno] );
				  Dialog.getinput();
				}
			      else
				{
				  sprintf( tmp, "rmdir %s", fname );
				  system( tmp );
				}
			}

		      fpar.close();
		      Active->fill( TRUE );
		      // top() is needed if errors occured during rmdir
		      // to repaint the frame
		      Active->top();
		      Nonactive->top();
		      continue;
		    }
		  else
		    {
		      // Build a temporary parameter file in $HOME
		      // Destination is not in list
		      Active->makepfile( "m0", arg );
		      
		      
		      
		      strcpy( userline, "" );
		      ulpos = 0;
		      continue;
		    }
		  break;

		  
		default:                       /* call action script */
		  abortcmd=FALSE;
		  if ( action[escaped[0]].defined==TRUE )
		    {
		      doit=action[escaped[0]].doit;
		      waitflag=action[escaped[0]].wait;
		      if (doit==FALSE) ul_dirty=TRUE;
		      if (action[escaped[0]].needarg==TRUE) 
			{
			  char defaults[PATH_MAX];
			  if ( action[escaped[0]].defaults == TRUE )
			    Nonactive->telldir( defaults );
			  else
			    strcpy( defaults, "" );
			  TArg Arg( action[escaped[0]].prompt, defaults );
			  Arg.show();
			  if ( Arg.input( action[escaped[0]].arg ) == NULL )
			    {
			      abortcmd=TRUE;
			      ul_dirty=TRUE;
			      doit=FALSE;
			      waitflag=TRUE;
			    }
			  else
			    abortcmd = FALSE;

			  Active->top();
			  Nonactive->top();
			}
		      if ( abortcmd == FALSE )
			{
			  // Build a temporary parameter file
			  Active->makepfile( action[escaped[0]].params,
					    action[escaped[0]].arg );
			  switch ( action[escaped[0]].params[1] )
			    {
			    case '0':
			      sprintf( userline, "%s %s%s", 
				      action[escaped[0]].script,
				      localtmpdir, PARAMFILE );
			      break;
			    case '2':
			      sprintf( userline, "%s %s%s %s", 
				      action[escaped[0]].script,
				      localtmpdir, PARAMFILE,
				      action[escaped[0]].arg );
			      break;
			    case '1':
			      sprintf( userline, "%s %s %s%s", 
				      action[escaped[0]].script,
				      action[escaped[0]].arg,
				      localtmpdir, PARAMFILE );
			      
			      break;
			    }
			}
		      else continue; // User aborted in dialog box
		    }
		  break;
		  
		case '0':
		case KEY_F(10):
		  sprintf( userline, "quit" );
		  doit=TRUE;
		  waitflag=FALSE;
		  break;
		case 10:                             /* return */
		  strinsch( userline, ' ', ulpos );
		  ulpos++;
		  for ( int i=0; i<(int)strlen( Active->gethilightedfname() );
		       i++ )
		    strinsch( userline, 
			     *(Active->gethilightedfname()+i), ulpos++);
		  ul_dirty=TRUE;
		  doit=FALSE;
		  break;
		case ' ':
		  strcat( userline, " " );
		  ulpos++;
		  ul_dirty=TRUE;
		  doit=FALSE;
		  break;
		}
	      if ( doit==TRUE ) 
		{
		  ch=10;      // Simulated return key
		}
	      else ch=' ';
	      
	    } // end: A menu selection
	  
	  
	  if ( ch == META_CHAR ) // Ctrl-X was pressed for other builtins
	    {
	      Footer.change( ctrl_items );
	      ul_dirty=TRUE;
	      noecho();
	      ch = wgetch( Active->getwptr() );  
	      Footer.change( items );
	      switch( ch )
		{
		case READTREE_CHAR:
		  // Some magic necessary in order to start the tree
		  // read-in in the background
		  char tmp[PATH_MAX];
		  sprintf( tmp, "%s 2>/dev/null | grep -v \"/proc/\" >%s%s &", 
			  TREECMD, homedir, TREEFILE );
		  sprintf( userline, "echo \"%s\" > %s%s", 
			  tmp, localtmpdir, CMDFILE );
		  system( userline );
		  sprintf( userline, "chmod u+x %s%s", localtmpdir, CMDFILE );
		  system( userline );
		  sprintf( userline, "%s%s", localtmpdir, CMDFILE );
		  waitflag=FALSE;
		  ul_dirty=TRUE;
		  ch=10;
		  break;
		case HEXVIEW_CHAR:
		  sprintf( userline, "%s %s | %s", HEXVIEW_CMD, 
			  Active->gethilightedfname(), PAGER );
		  waitflag = TRUE;
		  ul_dirty = TRUE;
		  ch=10;
		  break;
		case EXECONLY_CHAR:
		  Active->setexeconly( !Active->getexeconly() );
		  waitflag=FALSE;
		  ul_dirty = TRUE;
		  Active->fill(TRUE);
		  break;
		}
	      
	      continue;
	    }
	  
	  if ( ch == HIST_PREV )
	    {
	      History.prev();
	      History.getcmd( userline );
	      ulpos = strlen( userline );
	      ul_dirty=TRUE;
	      continue;
	    }
	  
	  if ( ch == HIST_NEXT )
	    {
	      if ( History.next() != NULL )
		{
		  History.getcmd( userline );
		  ulpos = strlen( userline );
		}
	      else
		{
		  strcpy( userline, "" );
		  ulpos = 0;
		}
	      ul_dirty=TRUE;
	      continue;
	    }
	  

	  // MARK_CHAR marks the hilighted entry
	  if ( ( ch == MARK_CHAR ) && ( strlen(userline)==0 ) )
	    {
	      Active->toggleentry();
	      continue;
	    }
	  
	  // SELECT_CHAR marks entries that match a pattern
	  if ( ( ch == SELECT_CHAR ) && ( strlen(userline)==0 ) )
	    {
	      char arg[PATH_MAX];

	      TArg Arg( "Mark entries", "*" );
	      Arg.show();
	      if ( Arg.input( arg ) == NULL )
		abortcmd = TRUE;
	      else
		abortcmd = FALSE;

	      if ( abortcmd != TRUE ) Active->markpattern( arg );
	      Active->top();
	      Nonactive->top();

	      continue;
	    }
	  
	  // UNSELECT_CHAR unmarks entries that match a pattern
	  if ( ( ch == UNSELECT_CHAR ) && ( strlen(userline)==0 ) )
	    {
	      char arg[PATH_MAX];

	      TArg Arg( "Unmark entries", "*" );
	      Arg.show();
	      if ( Arg.input( arg ) == NULL )
		abortcmd = TRUE;
	      else
		abortcmd = FALSE;
	      
	      if ( abortcmd != TRUE ) Active->unmarkpattern( arg );
	      Active->top();
	      Nonactive->top();

	      continue;
	    }
	  

	  // DELLN_CHAR deletes the input line
	  if ( ch == DELLN_CHAR )
	    {
	      ulpos = 0;
	      userline[0]='\0';
	      ul_dirty=TRUE;
	      
	      continue;
	    }

	  /* delete character */
	  if ( ch == KEY_DC )
	    {
	      if ( ulpos < (strlen( userline )-1) ) 
		{
		  ul_dirty=TRUE;
		  strcpy( &userline[ulpos], &userline[ulpos+1] );
		}
	      continue;
	    }
	    	  

	  if ( ch == 10 ) 
	    {
	      continue;  /* don't append CR to line */
	    }
	  

	  if ( ( (ch == erasechar()) || (ch == BS_CHAR) ) && (ulpos>0) )
	    {
	      ul_dirty=TRUE;
	      strcpy( &userline[ulpos-1], &userline[ulpos] );
	      ulpos--;
	      continue;
	    }
	  else
	    if ( (ch != erasechar()) && (ch!=BS_CHAR) )
	      {
		ul_dirty=TRUE;
		strinsch( userline, ch, ulpos );
		ulpos++;
		continue;
	      }
	}
      while ( ch != 10 );
      
      if ( strlen( userline ) == 0 )  /* Return is for TFileWindow */
	{
	  if ( (*(Active->gethilightedfmode()) == 'd') ||
	      ( (Active->gethilightedtruemode() & S_IFDIR) == S_IFDIR ) )
	    {
	      if( Active->chdir( Active->gethilightedfname() ) == TRUE )
	      {
		waitflag=FALSE;
		program_exec = FALSE;
		ch = '\0';

		if (Active->fill( TRUE ) == FALSE)
		{
		  TMsgDlg Dialog( "Directory list error", TRUE );
		  Dialog.print( "Permission denied" );
		  Dialog.getinput();
		  Active->top();
		  Nonactive->top();
		}
	      }
	      else
	      {
		TMsgDlg Dialog( "Directory change error", TRUE );
		Dialog.print( "Permission denied" );
		Dialog.getinput();
		Active->top();
		Nonactive->top();
	      }
	      goto loop;
	    }
	  else
	    {
	      sprintf( userline, Active->gethilightedfname() );
	      program_exec = TRUE;
	    }
	}
      
      /* Remote connect request */
      if ( userline[0] == '@' )
	{
	  if ( strlen( userline ) != 1 )
	    Active->remote( &userline[1] );
	  else
	    Active->local();
	  ch = '\0';
	  strcpy( userline, "" );
	  ul_dirty = TRUE;
	  waitflag = FALSE;
	  program_exec = FALSE;
	  goto loop;
	}
      
      
      if ( strcmp(userline,"quit") != 0 )
	{
	  Footer.hide();
	  system( "clear" );
	  {
	    char tmp[PATH_MAX];
	    // Save userline in history list
	    if ( ulpos!=0 )
	      {
		strcpy( HistElem.cmd, userline );
		History.add( &HistElem );
	      }
	    
	    // Add cwd change checking to userline
	    if ( strncmp( userline, "ncd ", 4 ) != 0 )
	      {
		sprintf( tmp, "{ %s } ; pwd > %s%s", userline, 
			localtmpdir, CWDFILE );
		if ( strncmp( userline, "cd ", 3 ) == 0 )
		  waitflag = FALSE;
	      }
	    else
	      {
		sprintf( tmp, "%s", userline );
		waitflag = FALSE;
		program_exec = FALSE;
	      }
	    // EXECUTE THE USER COMMAND LINE
	    cbreak();
	    echo();
//	    system( tmp );
	    if ( fork() == 0 )
	      execlp( "bash", "bash", "-rcfile", RCFILE, "-i", "-c", tmp, NULL );
	    else
	      wait( &sh_exitcode );
	    cbreak();
	  }
	  if (waitflag==TRUE)
	    {
	      cout << "\nPress a key to continue\n";
	      getch();
	    }
	  Prompt.newprompt();
	  
	  if ( program_exec == TRUE )
	    Active->postprocess( userline );
	  else
	    Active->postprocess( "" );
	  
	  // Now repaint everything
	  noecho();
	  system( "clear" );
	  wclear( std );
	  wrefresh( std );
	  if (Active->fill( TRUE ) == FALSE)
	  {
	    TMsgDlg Dialog( "Directory list error", TRUE );
	    Dialog.print( "Permission denied" );
	    Dialog.getinput();
	    Active->top();
	    Nonactive->top();
	  }
	  
	  Nonactive->repaint();
	  Footer.show();
	}
    }
  while ( strcmp( userline, "quit" ) != 0 );
  
  // Kill the clock
  if (RTC==1) Clock.kill();
  
  endwin();
  
  // Clean up the user directory
  sprintf( userline, "rm -f %s%s %s%s %s%s %s%s %s%s %s%s &>/dev/null", 
	  localtmpdir, DIRFILE_L, localtmpdir, DIRFILE_R, 
	  localtmpdir, CWDFILE, localtmpdir, PS1FILE, 
	  localtmpdir, CMDFILE , localtmpdir, PARAMFILE );
  system( userline );
  
  // Remove the local tmp directory
  sprintf( userline, "rm -rf %s", localtmpdir );
  system( userline );
  
  system( "clear" );
  return 0;
}

