/* inithome.cc  ---  Attempts to find the home directory of user

    Copyright (C) 1993  A.Matthias

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* ! Probably non-portable ! (This one is for Linux 0.99) */

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "globals.h"
#include "config.h"

void inithome( void )  // This one is GLOBAL !!!
  {
  char tmp[PATH_MAX];
  char *envptr;

  // Get the name of the home directory
  strcpy( homedir, getenv( "HOME" ) );
  strcat( homedir, "/" );

  // Initialize the local tmp directory
  sprintf( localtmpdir, LOCALTMPDIR, getuid() );
  strcpy( tmp, localtmpdir );
  tmp[strlen(tmp)-1] = '\0';
  mkdir( tmp, 0666 );
  chmod( tmp, S_IXUSR|S_IRUSR|S_IWUSR );
  
  // Get the name of the preferred editor (D.Schmidt)
  if ( (envptr=getenv("EDITOR")) == NULL )
    strcpy( EDITOR, DEFAULT_EDITOR );
  else
    strcpy( EDITOR, envptr );

  // Determine the screen resolution
  if ( (envptr=getenv("LINES")) == NULL )
    SCR_Y=DEF_SCR_Y;
  else
    SCR_Y=atoi( envptr );

  if ( (envptr=getenv("COLS")) == NULL )
    SCR_X=DEF_SCR_X;
  else
    SCR_X=atoi( envptr );

  if ( (SCR_X<80) || (SCR_X>140) || (SCR_Y<24) || (SCR_Y>80) )
    {
    SCR_X=DEF_SCR_X;
    SCR_Y=DEF_SCR_Y;
    }
  
  // Adjust the length of the visible filename to use the extra
  // horizontal space
  if ( SCR_X==DEF_SCR_X ) 
    FNAME_LEN=DEF_FNAME_LEN;
  else 
    FNAME_LEN=DEF_FNAME_LEN+( (SCR_X-DEF_SCR_X)/2 );

  }

