/* TPrompt.h --- The command line window class 

    Copyright (C) 1993  A.Matthias

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _TPrompt_h
#define _TPrompt_h

extern "C" {
#include <ncurses/ncurses.h>
}
#include "globals.h"
#include "config.h"

void setPS1( char *ps1 );

class TPrompt
  {
  private:
    WINDOW *wptr;
    char PS1 [127];

    void getPS1( void )  // This should evaluate the real $PS1
      {
#ifndef BUILTIN_PROMPT
      char tmp[PATH_MAX];

      sprintf( tmp, "sh -login -i < %s%s > %s%s 2>/dev/null", homedir, GETPS1,
               localtmpdir, PS1FILE );
      system( tmp );
      sprintf( tmp, "%s%s", localtmpdir, PS1FILE );
      ifstream fin( tmp );
      if (!fin)
        setPS1( "no prompt" );
      else
        {
        fin.get( tmp, PATH_MAX, '\0' );
        setPS1( tmp );
        fin.close();
        }
#endif
      }


  public:
    TPrompt( void )
      {
	wptr = newwin( 1, SCR_X, SCR_Y-4, 0 );
	strcpy( PS1, "no prompt> " );
	cbreak();
	werase( wptr );
	waddstr( wptr, PS1 );
      }
    
    ~TPrompt()
      {
	delwin( wptr );
      }

    void show( void )
      { touchwin( wptr ); wrefresh( wptr ); }

    void prompt( void )
      { mvwaddstr( wptr, 0, 0, PS1 ); wclrtoeol( wptr ); show(); }
    
    void newprompt( void )
      { getPS1(); mvwaddstr( wptr, 0, 0, PS1 ); wclrtoeol( wptr ); show(); }
    
    // setPS1() adds a trailing separator
    void setPS1( char *ps1 )
      {
	strcpy( PS1, ps1 );
	strcat( PS1, PS1_SEPARATOR );
      }

    WINDOW* getwptr( void )
      { return( wptr ); }

  };


#endif


