/* THistory.h  ---  Double-linked history list class

    Copyright (C) 1993  A.Matthias

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _THistory_h
#define _THistory_h

#include "globals.h"
#include "THistElem.h"

class THistory   // List which holds the last commands
{
 private:
   THistElem *first, *last, *act;
   int nextnum;

 public:
  THistory()
    {
      THistElem *item = new THistElem;
      nextnum = 0;
      first = item;
      first->cmd[0] = '\0';
      first->num = 0;
      first->next = NULL;
      first->prev = NULL;
      last = first;
      act = first;
    }

  void add( THistElem *item  ) 
    { 
      THistElem *next = new THistElem;

      if ( next==NULL )
	{ endwin(); cerr << "Panic: malloc() failed\n"; exit(1); }

      // We make a real copy of the values, not just the reference, so
      // that the caller can overwrite the referenced data	

      strcpy( last->cmd, item->cmd );
      last->next = next;
      last->num = nextnum;
      last->next->next = NULL;
      last->next->prev = last;
      last = last->next;
      act = last;        // ???
      nextnum++;
    }

  THistElem* getelem( void )
    // At end of list, NULL is repeatedly returned, until the list is rewinded.
    {
      static THistElem *retval; // return value

      if ( act->next==last )  
	return (THistElem*)NULL;      
      retval=act;

      return retval;
    }

  int getnum( void )
    // Returns the field act->num, but does *not* change act itself
      {
        return( act->num );
      }

  char* getcmd( char* retval )
    // Returns the field act->cmd
      {
	strcpy( retval, act->cmd );
	return( retval );
      }

  char *getcmd( int num )
    {
      THistElem *tmp;
      tmp=first;
      do
	{
	  if ( tmp->num == num ) return( tmp->cmd );
	  tmp = tmp->next;
	} 
      while ( tmp->next != last );

      return( NULL );
    }


  void rewind( void )
    {
      act=first;
    }

  THistElem* next( void )
    {
      if ( (act->next!=last) && (act->next != NULL ) )
	{
	act = act->next;
	return( act );
        }
      else return( NULL );
    }

  void prev( void )
    {
      if ( (act!=first) && (act->prev != NULL ) )
	  act = act->prev;
    }

  // Goes to end of list
  void eol( void )
    {
      act=last;
    }

  void wipe( void )
    {
      act=last;
      while ( act != first )
	{
        act=act->prev;
	delete act->next;
	act->next=NULL;
        }
      last=act;
      nextnum = 0;
    }

};

#endif





