#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include "gcboth.h"
#include "gcerr.h"

/*
 * Variables common to gccc, gc3 and gcdump
 */

char		BUF[MAX_BUFFERS][BUFFER_SIZE];
char		bufStatus[MAX_BUFFERS] = { '\0' };
short		initialEntryPoint;
short		defaultEntryPoint;
short		codespace[CODESPACE];
char		stringspace[STRINGSPACE];
short		idents=0;
short		namemap[MAXVARS];
objectrecord	objects[MAXVARS];
int		lineno = 1;
short		stringp=0, codep=0;

#if	__STDC__
int getBuffer(int who) {
#else
int getBuffer(who)
	int who;
{
#endif
	int i = 1;
	while (i<MAX_BUFFERS) {
		if (bufStatus[i] == '\0') {
			bufStatus[i] = '\1';
			return i;
		} else i++;
	}
	fprintf(stderr,"Out of buffers - ID %d!\n",who);
	return 0; /* Reserved for this case to hopefully recover */
}

#if	__STDC__
void releaseBuffer(int buf, int who) {
#else
void releaseBuffer(buf, who)
	int buf, who;
{
#endif
	if (bufStatus[buf]) bufStatus[buf] = '\0';
	else fprintf(stderr,"releaseBuffer called in error, ID %d!\n",who);
}

/*******************************************************/

#if	__STDC__
void STRUPR(char *s) {
#else
void STRUPR(s)
	char *s;
{
#endif
	while (*s) { *s = (char)toupper(*s); s++; }
}

#if	__STDC__
int readcode(char *path) {
#else
int readcode(path)
	char *path;
{
#endif
#ifdef __MSDOS__
	FILE *codefile = fopen(path,"rb");
#else
	FILE *codefile = fopen(path,"r");
#endif
	if (codefile) {
		(void)fread(&initialEntryPoint,(unsigned)1,sizeof(short),codefile);
		(void)fread(&defaultEntryPoint,(unsigned)1,sizeof(short),codefile);
		(void)fread(&codep,(unsigned)1,sizeof(short),codefile);
		(void)fread(codespace,(unsigned)codep,sizeof(short),codefile);
		(void)fread(&stringp,(unsigned)1,sizeof(short),codefile);
		(void)fread(stringspace,(unsigned)stringp,sizeof(char),codefile);
		(void)fread(&idents,(unsigned)1,sizeof(short),codefile);
		(void)fread(namemap,(unsigned)idents,sizeof(namemap[0]),codefile);
		(void)fread(objects,(unsigned)idents,sizeof(objects[0]),codefile);
		fclose(codefile);
		return 0;
	} else return -1;
}

#if	__STDC__
int readFile(char *name, char *aname,int (*f)(char *)) {
#else
int readFile(name, aname, f)
	char *name, *aname;
	int (*f)();
{
#endif
	int rtn, buf = getBuffer(3);
	rtn = (*f)(name);
	if (rtn && getenv("GCPATH")) {
		strcpy(BUF[buf],getenv("GCPATH"));
		strcat(BUF[buf],aname);
		rtn = (*f)(BUF[buf]);
	}
#ifdef __MSDOS__
	if (rtn) {
		strcpy(BUF[buf],"C:");
		strcat(BUF[buf],aname);
		rtn = (*f)(BUF[buf]);
	}
#else
	if (rtn && getenv("HOME")) {
		strcpy(BUF[buf],getenv("HOME"));
		strcat(BUF[buf],aname);
		rtn = (*f)(BUF[buf]);
	}
#endif
	releaseBuffer(buf,502);
	return rtn;
}

#if __STDC__
void writecodefile(void) {
#else
void writecodefile() {
#endif
#ifdef __MSDOS__
	FILE *codefile = fopen(CODNAME,"wb");
#else
	FILE *codefile = fopen(CODNAME,"w");
#endif
	if (codefile) {
		(void)fwrite(&initialEntryPoint,(unsigned)1,sizeof(short),codefile);
		(void)fwrite(&defaultEntryPoint,(unsigned)1,sizeof(short),codefile);
		(void)fwrite(&codep,(unsigned)1,sizeof(short),codefile);
		(void)fwrite(codespace,(unsigned)codep,sizeof(short),codefile);
		(void)fwrite(&stringp,(unsigned)1,sizeof(short), codefile);
		(void)fwrite(stringspace,(unsigned)stringp,sizeof(char),codefile);
		(void)fwrite(&idents,(unsigned)1,sizeof(short),codefile);
		(void)fwrite(namemap,(unsigned)idents,sizeof(namemap[0]),codefile);
		(void)fwrite(objects,(unsigned)idents,sizeof(objects[0]),codefile);
		fclose(codefile);
	} else error(ERR_CODEFILE);
}

static char *(errormsg[]) = {
	"Identifier redefined",
	"Undefined identifier",
	"Not in a loop",
	"Bad RETURN command",
	"Bad command",

	"Bad relational operator",
	"Bad string",
	"Bad function key specifier",
	"Bad control key specifier",
	"Bad meta key specifier",

	"Bad character key specifier",
	"Bad key specifier",
	"Bad integer",
	"`;' expected",
	"`)' expected",

	"Identifier expected",
	"`(' expected",
	"`,' expected",
	"`[' expected",
	"`]' expected",

	"`OF' expected",
	"Syntax error",
	"Namestore overflow",
	"Malloc failure",
	"Too many variables",

	"Cannot open key definition file",
	"Cannot open key code compilation file",
	"Bad SHOW command argument",
	"Too many labels",
	"MARKED, ALL or a regular expression expected",

	"Variable expected",
	"Function name expected",
	"Variable or regular expression expected",
	"String expected",
	"Colour expected",

	"Numeric keyspec expected",
	"Option expected",
	"ON or OFF expected",
	"Invalid internal function in bind",
	"Error in expression",

	"Link unsuccessfull",
	"No gcstart routine found",
	"Cannot bind/unbind this keyspec",
	"Out of code space!",
	"Sort key expected"
};

#if __STDC__
void error(enum errort typ) {
#else
void error(typ)
	enum errort typ;
{
#endif
	if (lineno>=0)
		fprintf(stderr,"ERROR: %s (line %d)\n",errormsg[(int)typ],lineno);
	else fprintf(stderr,"ERROR: %s\n",errormsg[(int)typ]);
	exit(0);
}


