#ifndef _GCKEY_H
#define _GCKEY_H

#define MAX_KEYS	256
#define NUM_PRIM_KEYS	8	/* Primitive cursor ops		*/
#define NUM_CED_KEYS	17	/* Command line editing keys	*/
#define START_CED_KEYS	(MAX_KEYS-NUM_CED_KEYS)
#define START_ESC_KEYS	(START_CED_KEYS-8)
typedef struct {
	short ip;
	char  *hlp;
} keydef_t;

#if __MSDOS__

#define KEY_DOWN	0x5000   
#define KEY_UP		0x4800   
#define KEY_LEFT	0x4B00
#define KEY_RIGHT	0x4D00
#define KEY_PGUP	0x4900
#define KEY_PGDN	0x5100
#define KEY_PPAGE	0x4900	/* page up */
#define KEY_NPAGE	0x5100	/* page down */
#define KEY_SF		0x7600  /* ctrl-pgdn */
#define KEY_SR		0x8400	/* ctrl-pgup */
#define KEY_HOME	0x4700
#define KEY_END		0x4F00
#define KEY_HELP	0x5400	/* shift F1 */
#define KEY_DEL		0x5300
#define KEY_INS		0x5200
#define KEY_CTRL_HOME	0x7700
#define KEY_CTRL_END	0x7500
#define KEY_CTRL_LEFT	0x7300
#define KEY_CTRL_RIGHT	0x7400
#define KEY_CTRL_PGUP	0x8400
#define KEY_CTRL_PGDN	0x7600
#define KEY_BACKSPC	0x0008
#define KEY_F1		0x3B00
#define KEY_F2		0x3C00
#define KEY_F3		0x3D00
#define KEY_F4		0x3E00
#define KEY_F5		0x3F00
#define KEY_F6		0x4000
#define KEY_F7		0x4100
#define KEY_F8		0x4200
#define KEY_F9		0x4300
#define KEY_F0		0x4400
#define KEY_ALT_A	0x1E00
#define KEY_ALT_B	0x3000
#define KEY_ALT_C	0x2E00
#define KEY_ALT_D	0x2000
#define KEY_ALT_E	0x1200
#define KEY_ALT_F	0x2100
#define KEY_ALT_G	0x2200
#define KEY_ALT_H	0x2300
#define KEY_ALT_I	0x1700
#define KEY_ALT_J	0x2400
#define KEY_ALT_K	0x2500
#define KEY_ALT_L	0x2600
#define KEY_ALT_M	0x3200
#define KEY_ALT_N	0x3100
#define KEY_ALT_O	0x1800
#define KEY_ALT_P	0x1900
#define KEY_ALT_Q	0x1000
#define KEY_ALT_R	0x1300
#define KEY_ALT_S	0x1F00
#define KEY_ALT_T	0x1400
#define KEY_ALT_U	0x1600
#define KEY_ALT_V	0x2F00
#define KEY_ALT_W	0x1100
#define KEY_ALT_X	0x2D00
#define KEY_ALT_Y	0x1500
#define KEY_ALT_Z	0x2C00
#define KEY_ALT_0	0x8100
#define KEY_ALT_1	0x7800
#define KEY_ALT_2	0x7900
#define KEY_ALT_3	0x7A00
#define KEY_ALT_4	0x7B00
#define KEY_ALT_5	0x7C00
#define KEY_ALT_6	0x7D00
#define KEY_ALT_7	0x7E00
#define KEY_ALT_8	0x7F00
#define KEY_ALT_9	0x8000

#else /* not __MSDOS__ */
#endif /* not __MSDOS__ */

extern keydef_t KeyTbl[MAX_KEYS];

#if __STDC__
void clearKeyTable(void);
char *getPrevCmd(void);
char *getNextCmd(void);
#else
void clearKeyTable();
char *getPrevCmd();
char *getNextCmd();
#endif

#endif

