#ifndef _GCCC_H
#define _GCCC_H

#include "gcboth.h"
#include "gcerr.h"

/*
 * LEXICAL TOKEN TYPES
 */

enum symboltype {

/* RESERVED WORDS, COLOURS FIRST */

	SYM_BLACK, SYM_BLUE, SYM_GREEN, SYM_CYAN,
	SYM_RED, SYM_MAGENTA, SYM_BROWN, SYM_LIGHTGRAY,
	
	SYM_ACCESS, SYM_ALL, SYM_APPEND, SYM_ASCENDING, SYM_ATIME,
	SYM_BEEP, SYM_BDEV, SYM_BIND, SYM_BREAK, SYM_CALL,
	SYM_CD, SYM_CDEV, SYM_CLEAR, 
	SYM_COLORS, SYM_COLOURS, SYM_CONTINUE, SYM_COPY,
	SYM_DEBUG, SYM_DESCENDING, SYM_DIR, SYM_DIRSELECT,
	SYM_DIRSORT, SYM_DO,
	SYM_DOWN, SYM_ECHO, SYM_ELSE, SYM_END, SYM_ENDREC,
	SYM_EVAL, SYM_EXEC, SYM_EXECCATCH, SYM_EXPAND, SYM_EXTENS,
	SYM_FILTER, SYM_FOLLOW, SYM_GCDEFAULT, SYM_GCSTART, SYM_GROUP,
	SYM_HEAD, SYM_HELP, SYM_HOME, SYM_IF,
	SYM_IF_ANY, SYM_IF_DOS, SYM_IF_UNIX, SYM_IN, SYM_KEYCODE,
	SYM_LEFT, SYM_LENGTH, SYM_LINK, SYM_LOOKUP, SYM_LOOP, SYM_MARK, 
	SYM_MARKED, SYM_MATCHES, SYM_METAKEY,
	SYM_MOVE, SYM_MTIME, SYM_NAME, 
	SYM_NEXTLINE, SYM_NONE, SYM_NOT, SYM_OF, SYM_OFF, SYM_ON, 
	SYM_OPEN, SYM_OPTIONS, SYM_OWNER, 
	SYM_PAINT, SYM_PERMS, SYM_PGDN, SYM_PGUP, SYM_PIPE, SYM_PLAYMAC,
	SYM_QUIT, SYM_READ, SYM_RECMAC, SYM_REG, SYM_RESCAN, SYM_RETURN, 
	SYM_RIGHT, SYM_SEARCH, SYM_SHOW, SYM_SHOWHIDDEN, 
	SYM_SIZE, SYM_SLEEP, 
	SYM_SORTBY, SYM_SPLIT, SYM_SWAP, SYM_TAIL, 
	SYM_TO, SYM_TYPEOF, 
	SYM_UNBIND, SYM_UNLINK, SYM_UNMARK, SYM_UP, SYM_WHILE,
/* THEN PLAIN TOKENS */

	SYM_EOF, SYM_LEFTBRACE, SYM_RIGHTBRACE, SYM_SEMICOLON,
	SYM_KEYSPEC, SYM_REGEXP, SYM_IDENTIFIER, SYM_COMMA,
 	SYM_INTEGER, SYM_EQUALS, SYM_LEFTPARENTHESIS, SYM_RIGHTPARENTHESIS, 
	SYM_STRING, SYM_UNDEF, SYM_ASSIGN, SYM_LEFTBRACKET, SYM_RIGHTBRACKET,
	SYM_PLUS
};

#include "gcops.h"

#define MAXINT 32767

/*
 * ID Types
 */

#ifdef __MSDOS__
#define ETX		26
#else
#define ETX		4
#endif

extern char		symtext[];
extern short		labelcnt;
extern FILE		*keydeffile;
extern int		EM;
extern unsigned		ch;
extern int		symvalue;
extern enum symboltype	symbol;
extern int		newID;

/*
 * Prototypes
 */

#if __STDC__
void config_file(void);
void nextsymbol(void);
void expect(enum symboltype);
short savestring(char *);
short search(char *, short);
void initvars(void);
void insert(char *name, short IDindex, short type);
int gclink(void);
void freeStab(void);

#else

void config_file();
void nextsymbol();
void expect();
short savestring();
short search();
void initvars();
void insert();
int gclink();
void freeStab();

#endif

#endif

