static char *sccsid = "@(#) dfmon.sysv.c 1.1    11/6/91 22:12:37";

/*
 *
 * dfmon for linux
 *
 * reads /etc/mnttab, does a statfs(2) on first field of structure
 * MUCH faster than df(1)
 *
 * Written by Ed Carp  -  07/16/88
 *
 * Ported to linux 08/07/93
 *
 * usage:  dfmon [-t THRESH] [-s secs] [-u users] [-o]
 *
 *
 * set THRESH for notification if % USED is above THRESH
 */
#include <stdio.h>
#include <curses.h>
#include <signal.h>
#include <sys/types.h>
#include <utmp.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <linux/fs.h>
#include <linux/vfs.h>
#include <mntent.h>
#include <unistd.h>
#define UTMP_FILE "/etc/utmp"
#define LMAX sizeof(utmp.ut_line)
struct utmp *utm, *getutent ();
struct statfs buf;
struct mntent mnt;
float atof ();

#define MTAB MOUNTED
extern char *optarg;
extern int optind;

#define LFNMAX 32

main (argc, argv)
int argc;
char **argv;
{
/*
 * MTAB 
 */
  FILE *f;
  int c, delay = 5, uflag = 0, mailflag = 0, i = 0, once = 0, xflag = 0,
      j = 0, skip;

/*
 * line to be read in 
 */
  char line[512], *linep;

/*
 * file system 
 */
  char fs[LFNMAX], *fsp;

/*
 * mounted on 
 */
  char mounted[LFNMAX], scratch[LFNMAX], *mountedp;

/*
 * users to send mail to 
 */
  char *users[64];

/*
 * exclude these filesystems from notification 
 */
  char *exclude[64];
  float usedp, thresh = 90.0;

  users[0] = NULL;
  while ((c = getopt (argc, argv, "os:t:u:x:")) != EOF)
  {
    switch (c)
    {
    case 'o':
      once = 1;
      uflag = 1;
      break;
    case 's':
      delay = atoi (optarg);
      break;
    case 't':
      thresh = atof (optarg);
      break;
    case 'u':
      delay = 60;
      uflag = 1;
      users[i++] = optarg;
      break;
    case 'x':
      xflag = 1;
      exclude[j++] = optarg;
      break;
    }
  }
  users[i] = NULL;
  exclude[j] = NULL;
  if (once == 1)
    printf ("%20s  BLKSIZE 1KBLKS   FREE  AVAIL   USED--PERCENT\n\n",
	    "FILESYSTEM");
  if (uflag == 0)
  {
    initscr ();
    move (0, 0);
    printw ("%20s  BLKSIZE 1KBLKS   FREE  AVAIL   USED--PERCENT",
	    "FILESYSTEM");
  }
  while (1)
  {
    if (uflag == 0)
      move (2, 0);
    if ((f = fopen (MTAB, "r")) == (FILE *) NULL)
    {
      fprintf (stderr, "can't open %s!\n", MTAB);
      if (uflag == 0)
	endwin ();
      exit (1);
    }
    while (fgets (line, 510, f) != (char *) NULL)
    {
      sscanf (line, "%s %s %s %s %s %s", fs, mounted, scratch, scratch, scratch, scratch);
/*
 * fprintf(stderr, "DEBUG: mounted='%s', fs='%s'\n", mounted, fs); 
 */
      if (EOF == statfs (mounted, &buf))
	perror (mounted);
      else
      {
#ifdef DEBUG
	fprintf (stderr, "%s: type=0x%lx, bsize=%ld, blocks=%ld, bfree=%ld, bavail=%ld, files=%ld, ffree=%ld\n",
		 mounted, buf.f_type, buf.f_bsize, buf.f_blocks, buf.f_bfree, buf.f_bavail,
		 buf.f_files, buf.f_ffree);
#endif

	i = buf.f_bsize / 1024L;
	if (buf.f_blocks == 0L)
	  usedp = 0.0;
	else
	  usedp = 100.0 * ((float) buf.f_bavail / (float) buf.f_blocks);
	usedp = 100.0 - usedp;

	if (uflag == 0 || once == 1)
	  printw ("%20s %7d  %6ld %6ld %6ld %6ld %6.2f  ",
		  mounted, buf.f_bsize, i * buf.f_blocks,
		  i * buf.f_bfree, i * buf.f_bavail, i * (buf.f_blocks - buf.f_bfree),
		  usedp);
	if (uflag == 1 && once == 0    /*
				        * && mailflag == 0 
				        */  && usedp > thresh && buf.f_blocks > 0)
	{
#ifdef DEBUG
	  fprintf (stderr, "over thresh, fs=%s\n", mounted);
#endif
	  /*
	   * mailflag = 1; 
	   */
	  skip = 0;
	  i = 0;
	  while (exclude[i] != NULL)
	  {
#ifdef DEBUG
	    fprintf (stderr, "skip check, fs=%s, exclude=%s\n", mounted, exclude[i]);
#endif
	    if (strcmp (exclude[i], mounted) == 0)
	    {
#ifdef DEBUG
	      fprintf (stderr, "skip set, fs=%s\n", mounted);
#endif
	      skip = 1;
	      break;
	    }
	    i++;
	  }
	  i = 0;
	  while (users[i] != NULL && skip == 0)
	  {
	    sprintf (line,
		     "partition %s is %6.2f %% full\7",
		     mounted, usedp);
#ifdef DEBUG
	    fprintf (stderr, "notifying %s\n", users[i]);
#endif
	    writetty (users[i], line);
	    i++;
	  }
	}
      }
      if (usedp > thresh && uflag == 0 && buf.f_blocks > 0)
      {
	standout ();
	printw (" WARNING ");
	standend ();
      }
      else if (uflag == 0)
	printw ("         ");
      if (uflag == 0)
	printw ("\n");
      if (once == 1)
	printf ("\n");
    }
    if (uflag == 0)
    {
      clrtobot ();
      refresh ();
    }
    fclose (f);
    if (once == 1)
      break;
    sleep (delay);
  }
}
int 
writetty (u, s)
char *u, *s;
{
  /*
   * writes message "s" to user "u" 
   */
  FILE *port;
  char dev[128];

  while ((utm = getutent ()) != (struct utmp *) NULL)
  {
    if (strcmp (utm->ut_name, u) == 0)
    {
      strcpy (dev, "/dev/");
      strcat (dev, utm->ut_line);
      if ((port = fopen (dev, "w")) == (FILE *) NULL)
	continue;
      fputs (s, port);
      fputs ("\r\n", port);
      fclose (port);
    }
  }
  endutent ();
}
