/***
 *** configfile.h: funtions to process config file
 *** Written by Koen Gadeyne (kmg@barco.be)
 ***
 ***/

#ifndef _CONFIGFILE_H
#define _CONFIGFILE_H

#include "misc.h"
#include "confdefs.h"

extern char ConfigFile[];

/* bitmasks for label options */
#define LABEL_REQUIRED   1
#define LABEL_FROMSTART  2
#define LABEL_LAST       4

#define LABEL_OPTIONAL  0
#define LABEL_FROMCURRENT  0

/*
 * default sync ranges. Any VGA monitor should AT LEAST support these.
 */         
 
#define DEFLT_HSYNC_MIN  30.0
#define DEFLT_HSYNC_MAX  32.0
#define DEFLT_VSYNC_MIN  45.0
#define DEFLT_VSYNC_MAX  80.0

#define FRMARGIN 0.3           /* allowable error margin for single frequency definition */

#define MAX_RANGE_SPECS  32


void cleanupstring(char *tstring);

char* findlabel(FILE* inputfile, char* reqlabel, int options);

FILE* open_param_file(char* conf_file);

char* showopts(const char* optstrings[], int num_optstrings);

int findoption(char* inputstr, const char* optstrings[], int num_optstrings, char* optiontype);

void check_int_range(int cvalue, int lmin, int lmax, char* descstr);

int getbyte(char* instring, char* descrstring, int lmin, int lmax);

float getfloat(char* instring, char* descrstring, int lmin, int lmax);

int GetPathOption(FILE *param_file, char *optionstring, int label_config, char *path);

void ParseFontXY(char *inputstr, int *x, int*y);

int Run_extern_Prog(char *commandline);

void get_range(FILE *param_file, char* descrline, float range[MAX_RANGE_SPECS][2], char* textdescr, int dfltmin, int dfltmax);

 

#endif

