/* apcd.h - Definitons file for APC SmartUPS daemon
 *
 * Copyright (c) 1995 Pavel Korensky
 * All rights reserved
 *
 * Version:
 * 
 * $Id: apcd.h,v 1.4 1995/05/23 01:08:18 root Exp root $
 *
 *
 * History:
 *
 * $Log: apcd.h,v $
 * Revision 1.4  1995/05/23  01:08:18  root
 * Parameters are on the command line, instead of the config.h file
 *
 * Revision 1.3  1995/05/23  00:26:08  root
 * UPS switch-off was added
 *
 * Revision 1.2  1995/05/21  20:15:56  root
 * First ALPHA version
 *
 * Revision 1.1  1995/05/20  12:22:54  root
 * Initial revision
 *
 *
 */

/* 
 * A few words regarding the APC serial protocol
 *
 * Communication protocol which is used for controlling the APC SmartUPS
 * is very simple ASCII protocol.
 * The serial communication is 2400 Bd, 8N1
 *
 * Basically, your computer send a character to the UPS and UPS answer
 * with the requested information in the form of the ASCII string terminated
 * with CR/LF.
 * In some cases, the UPS answer is the action like battery test etc.
 *
 * There are two exceptions. If the UPS is switching to the battery, the
 * characters "!!" are sent to the computer. If the UPS is switching back
 * on-line, the charater '$' is sent to the computer.
 *
 * The protocol description is not based on informations obtained from APC.
 * I tried to analyse the protocol on RS-232 port, so my description
 * is not complete.
 *
 * Command are:
 *
 *	SEND			ANSWER
 *
 *	f			Battery status in %   100 = fully loaded
 *	N			Line minimum voltage (V)
 *	M			Line maximum voltage (V)
 *	Q			Status byte 8 bits long.
 *	P			UPS load (VA)
 *	F			Line frequency (Hz)
 *	L			Line voltage (V)
 *	O			Output voltage (V)
 *	C			Inside temperature (Celsius degrees)
 *	B			Battery voltage
 *
 *
 * Some signals for UPS control
 *
 *	W			Switch on battery
 *	X			Switch back on-line
 *	A			Lights test
 *	U			Power failure test
 *	c			UPS identification ???
 *
 * One very special signal
 *
 *	Z ~1500ms pause Z	Switch off the UPS
 *
 *
 *
 */
 

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <unistd.h>
#include <utmp.h>
#include <paths.h>
#include <string.h>
#include <dirent.h>
#include <fcntl.h>
#include <ctype.h>
#include <errno.h>
#include <syslog.h>
#include <time.h>
#include <mntent.h>
#include <sys/signal.h>
#include <sys/param.h>
#include <sys/mount.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/termios.h>
#include <sys/resource.h>

/*
 * Various constants
 */

#define	MAXLINE 100	/* Max. length of the UPS anser */
#define PAUSETIME 1	/* how many seconds should apcd sleep each time
			   it checks the UPS status
			 */
#define BATT 1		/* UPS switched on battery during reading info */
#define LINE 0		/* UPS switched back on-line during reading info */

			 
#define DEFAULT_SPEED B2400

#define	BATT_FULL	'f'
#define	UPS_LINE_MIN	'N'
#define UPS_LINE_MAX	'M'
#define	UPS_STATUS	'Q'
#define	UPS_LOAD	'P'
#define	LINE_FREQ	'F'
#define	LINE_VOLTAGE	'L'
#define	OUTPUT_VOLTAGE	'O'
#define	UPS_TEMP	'C'
#define	BATT_VOLTAGE	'B'

#define	GO_ON_BATT	'W'
#define	GO_ON_LINE	'X'
#define	LIGHTS_TEST	'A'
#define	FAILURE_TEST	'U'

#define	UPS_ON_BATT	'!'
#define	UPS_ON_LINE	'$'

#define _PATH_UMOUNT	"/bin/umount"
#define UMOUNT_ARGS	"umount","-a"
#define _PATH_MTAB	"/etc/mtab"

/* Several typedefs */

typedef	unsigned char BYTE;
typedef unsigned short int  WORD;

typedef	struct {
	double	BatLoad;
	double	LineMin;
	double	LineMax;
	double	UPSLoad;
	double	LineFreq;
	double	LineVoltage;
	double	OutputVoltage;
	double	UPSTemp;
	double	BattVoltage;
	int	Status;
} UPSINFO;


/* Macros */



/* Function prototypes */

void start_daemon(void);
void signal_setup(void);
void sig_intr(int);
void sig_term(int);
void sig_hup(int);
void go_on_batt(int);
void go_on_line(int);
void go_down(void);
void send_second_z(int);
void do_shutdown(void);
void write_wtmp(void);
void umount_disks(void);
void umount_disks_ourselves(void);

void setup_tty(void);
int getline(int,char *);
int fillUPS(int,UPSINFO *);
void mesusr(char *,struct utmp *);
void mesall(char *);
