/*
 * This program was written to check the utmp code. It adds an utmp entry
 * of loginname 'postmaster' at ttyqf
 */
 
#include <stdio.h>
#include <unistd.h>
#include <utmp.h>
#include <fcntl.h>
#include <time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

main(int argc, char *argv[]){
	struct utmp p;
	int fd;

	if (argc != 3) {
		printf("Usage: %s <hostname> <IP address>\n", strrchr(argv[0], '/'));
		exit(-1);
	}
	
	p.ut_type = USER_PROCESS;
	p.ut_pid = getpid();
	strcpy(p.ut_line, "/dev/ttyqf");
	strcpy(p.ut_id, "qf");
	p.ut_time = time(NULL);
	strcpy(p.ut_user, "postmaster");
	strcpy(p.ut_host, argv[1]);
	p.ut_addr = inet_addr(argv[2]);

	fd = open("/etc/utmp", O_WRONLY);
	lseek(fd, 0, SEEK_END);
	write(fd, &p, sizeof(struct utmp));
	close(fd);
}
