/*
    yamm, Yet Another Micro Monitor
	lib/init.c
    Copyright (C) 1994, 1995  Riccardo Facchetti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

#include "yamm.h"
#if defined(MODULE)
#include "drv_yamm.h"
#endif /* MODULE */

/*
 * This function is called by main() to initialize some things of yamm.
 */
int init_yamm(void)
{
#if defined(MODULE)
	long v;
#endif /* MODULE */

#if !defined(NO_CURSES)
	wait_second = 4;
#endif
	
/*
 * Allocate memory: one time one chunk.
 */
	myps = (struct pst_status * )malloc(sizeof(struct pst_status));
	pbuf = NULL;

#if defined(MODULE)
/*
 * open /dev/yamm and keep it opened until exit
 */
	yammfd = open ("/dev/yamm", O_RDONLY);
	if (yammfd == -1) {
		printf( "Cannot open /dev/yamm (drv_yamm.o not loaded)\n" );
		return ( 0 );
	}
	
	ioctl(yammfd, YIOCGVER, &v);

	if (v != YAMM_NUM) {
		printf( "drv_yamm and yamm versions are different:\n" );
		printf( "drv_yamm module is V%d.%d.%d%c while yamm is %s\n",
			YAMM_GVER(v),
			YAMM_GMAJ(v),
			YAMM_GMIN(v),
			YAMM_GCHR(v),
			YAMM_VERSION );
		printf( "Please, recompile both yamm and drv_yamm to"
				" have all binaries up to date.\n" );
		return ( 0 );
	}
#endif /* MODULE */
	return ( 1 );
}
