/*
    yamm, Yet Another Micro Monitor
    comp_sc.c
    Copyright (C) 1992  Andrea Marangoni
    Copyright (C) 1994, 1995  Riccardo Facchetti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "yamm.h"

/*
 * HV
 */
int compare_sched_time ( struct pst_status *a, struct pst_status *b )
{
	register double sc_a = a->pst_pctcpu;
	register double sc_b = b->pst_pctcpu;

	if ( invert )
		return ( sc_a < sc_b ? -1 : sc_a == sc_b ? 0 : 1 );
	else
		return ( sc_a < sc_b ? 1 : sc_a == sc_b ? 0 : -1 );
}
