#! /bin/sh
#
# This file was developed by Hans Lerman <lermen@elserv.ffm.fgan.de>
# for dosemu. I have stolen it from dosemu0.53pl40.
# Since this file is a modified version of the original kversion.sh in
# dosemu package, I am the only responsible for bugs and the like.
#
# Riccardo Facchetti
#
# Well, we need this to generate a kernel version number,
# that can be easyly used whith #if.
#
# We do *not* use /proc/version, because we don't rely on the version of the
# loaded kernel, but on the /usr/src/linux/include..., which is used
# for compilation of dosemu. Ok?
#
# Don't laugh on the 3 digits for each version level,
# we'll never know how long Linus is staying on each level.
#

VERSION=""
OS=""

zeropad() {
 if [ $1 -lt 10 ]; then VERSION="${VERSION}00$1"
 else
  if [ $1 -lt 100 ]; then VERSION="${VERSION}0$1"
  else VERSION="${VERSION}$1"; fi
 fi
}

OS=`uname -s`

if [ "$OS" != "Linux" ]; then
 rm -f ../include/kversion.h
 touch ../include/kversion.h
else

 if [ -z "$1" ]; then
  KERNELSRC="/usr/src/linux"
 else
  KERNELSRC=$1
 fi
 
 if [ -z "$2" ]; then
  YAMMSRC="../"
 else
  YAMMSRC=$2
 fi
 
 if [ -f ${KERNELSRC}/include/linux/version.h ]; then
  VERSIONFILE="${KERNELSRC}/include/linux/version.h"
 else
  echo "missing ${KERNELSRC}/include/linux/version.h"
  VERSIONFILE="${KERNELSRC}/tools/version.h"
  echo "searching ${VERSIONFILE}..."
  if [ ! -f ${VERSIONFILE} ]; then
   echo "missing ${VERSIONFILE}"
   echo
   echo "To correct the error you have to configure the Linux kernel sources"
   echo "chdir to $KERNELSRC and do:"
   echo "make config"
   echo "make dep"
   echo "make include/linux/version.h"
   echo
   echo "giving up!"
   exit 1
  fi
 fi
 

 ASCII_VERSION=`grep UTS_RELEASE ${VERSIONFILE} |cut '-d"' -f2`
 VERSION=`echo "${ASCII_VERSION}" |cut '-d.' -f1` 
 zeropad `echo "${ASCII_VERSION}" |cut '-d.' -f2` 
 zeropad `echo "${ASCII_VERSION}" |cut '-d.' -f3` 

 if [ "$VERSION"x != "x" ]
 then
  echo "#ifndef KERNEL_VERSION" > ${YAMMSRC}/include/kversion.h
  echo "#define KERNEL_VERSION ${VERSION}" >> ${YAMMSRC}/include/kversion.h
  echo "#endif " >> ${YAMMSRC}/include/kversion.h
 else
  echo "wrong ${VERSIONFILE}"
  echo
  echo "To correct the error you have to configure the Linux kernel sources"
  echo "chdir to $KERNELSRC and do:"
  echo "make config"
  echo "make dep"
  echo "make include/linux/version.h"
  echo
  echo "giving up!"
  exit 1
 fi
fi
