/*
    yamm, Yet Another Micro Monitor
    extern.h
    Copyright (C) 1992  Andrea Marangoni
    Copyright (C) 1994, 1995  Riccardo Facchetti

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined(_EXTERN_YH)
#define _EXTERN_YH 1

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

extern void PS_dynam ( struct pst_dynamic * );
extern void PS_stat  ( struct pst_static * );
extern void PS_vm    ( struct pst_vminfo * );
extern int  PS_proc  ( struct pst_status *, int, int );

extern int init_yamm ( void );
extern void set_users( void ); 
extern char *get_user_info( int );
extern char *get_group ( int );
extern long get_user_id( char * );
extern void user_info ( void );
extern void get_user_sum( int, long *, long *, long *);
extern int isProc( int );
extern char *get_cmdline( struct pst_status pp );

extern void setup_tty( void );
#if defined(SIGWINCH) && defined(OWN_WINCH)
extern void do_chsize(void);
#endif /* SIGWINCH && OWN_WINCH */
extern char *get_tty( long, long );

extern int compare_start_time(struct pst_status *, struct pst_status *);
extern char *visual_start_time( int );

extern int compare_user_time(struct pst_status *, struct pst_status *);
extern char *visual_user_time( int );

/*
 * HV
 */
extern int compare_sched_time(struct pst_status *, struct pst_status *);

extern int compare_ressize( struct pst_status *, struct pst_status *);
extern int compare_size( struct pst_status *, struct pst_status *);

extern void Print_Conf( int, struct pst_dynamic *);
extern void Print_Who ( int );

extern char *get_dimension( long );

extern void mpreprocess( int, char *[],  char * );
extern void Print_vm( void );
extern void Print_who( int );
extern char *info_cpu( long * );

extern char get_status( int );
extern char get_swstatus( int );
extern char get_nistatus( int );
extern void count_status( int );
extern int status_sleep( void ), status_run( void );
extern int status_stop( void ), status_other( void );
extern int status_zombie( void );
extern void examine_utmp ( void );

extern int reg_match ( char * );
extern void reg_set ( char * );

#ifndef NO_CURSES
extern void quit ( int ), init_curses ( void ), clear_screen ( void );
extern int look_lines ( void ), look_cols ( void );
extern int curses_wait ( int );
extern void update_first_line ( int, struct pst_dynamic * );
extern void ShowLoadGraph( struct pst_dynamic * );
extern void ResetHist(void);
extern void curses_refresh ( void ), curses_error (  char * );
extern long ask_curses ( char * );
extern void curses_in_reverse ( void ), curses_out_reverse ( void );
extern void curses_print_help ( void ), refresh_all ( void );
extern char *curses_get_string ( char * );
extern void curses_help(void);

#if defined(notdef)
/*
 * I can't see the reason for redeclare curses/ncurses functions alredy
 * declared in (n)curses.h
 * - Riccardo -
 */
/*
 * On other files only this routine is needed
 */
#if !defined(linux)
extern int printw( const char *, ...); 
#else
# if !defined(NCURSES)
extern int printw( const char *, ...); 
#else
extern int printw( char *, ...); 
# endif /* !NCURSES */
#endif /* !linux */
#endif /* notdef */

#if !defined(linux)
extern void renice( int, int );
#else
extern void renice( int, int, int );
#if defined(MODULE)
extern void SetUp ( struct pst_status *, int );
#endif /* MODULE */
#endif /* linux */

#if defined(SIGWINCH) && defined(OWN_WINCH)
extern void winch_func ( int );
#endif /* SIGWINCH && OWN_WINCH */

#else /* NO_CURSES */
extern long ask_curses( char * );  /* Empty file if NO_CURSES */
extern int look_lines( void ), look_cols( void );
extern char *curses_get_string ( char * );
#endif /* NO_CURSES */

#if defined(linux)
extern int search_func( unsigned long );
int read_ftab(void);
#endif /* linux */

#if defined(__cplusplus)
}
#endif /* __cplusplus */


/*
 * Global variables
 */

extern struct pst_status *myps;
extern struct pst_status *pbuf;
extern int invert, wait_second, sstring;
extern int system_time_include, user_time_include;
extern int allow_root, long_format, print_configuration;
extern int vm_config, wcpu, who, reverse, reverse_index;
extern long look_process, look_uid;
extern int Num_display_proc, set_euid, look_user;
extern int (*order)(struct pst_status *, struct pst_status *);
extern int displayed, pages, look_utmp, load_graph;
extern struct Signames signames [];
#if defined(SIGWINCH) && defined(OWN_WINCH)
extern char **yammav;
#endif /* SIGWINCH && OWN_WINCH */
#if defined(NCURSES)
extern int fgc, bgc;
#endif /* NCURSES */
#if defined(linux)
extern struct func_tab *ftab;
extern int ftab_size;
# if defined(MODULE)
extern int yammfd;
# endif /* MODULE */
#endif /* linux */

#endif /* !EXTERN_YH */
