/*
 * 	Copyright (C) 1994  Loganville Technical Resources, Incorporated.
 *
 * Xzet is free software; you can redistribute it and/or modify it under the 
 * terms of the GNU General Public License as published by the Free Software 
 * Foundation; either version 2, or (at your option) any later version.  
 *
 * Xzet is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE. 
 *
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with 
 * xzet; see the file  COPYING. If  not, write to the Free Software Foundation, 
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *	  		Xzet Features the unknown Ztach widget.
 */
static char	*about_text[] = { 
	"            Xzet is Zmans version of Xetat and Top",
	"",
	"It is a graphical monitoring utility. It displays global cpu and",
	"memory  utilization, file system  utilization, statistics on all",
	"running  processes, and has a graphical display  showing  memory",
	"and cpu utilization for any user selected  individual processes.",
	"",
	"Xzet is Copyright 1994 by  Loganville  Technical  Resources, Inc",
	"",
	"Xetat is Copyright 1991 by Pierre FICHEUX, Lectra Systemes R & D", 
	"Copyrights & acknowledgements for Top & the proc filesys reader:",
	"Copyright 1992 Branko Lankester       Copyright 1992 Roger Binns",
	"Michael K. Johnson, johnsonm@stolaf.edu",
	"Robert J. Nation (nation@rocket.sanders.lockheed.com)",
	"",
	"Only Zman at LTR was involved in the actual development of Xzet,",
	"so please do not contact the others  regarding bugs in the code.",
	"                        Contact LTR at:",
	"5145 Ozora Church Road, Loganville, Ga 30249 (USA)  404 466-8544"   };
/*
 *  		This is bi-lingual source code.  Deal with it.
 *
 * The following copyright information is from xetat:
 *
 * Copyright 1991 Lectra Systemes
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Lectra Systemes not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Lectra Systemes makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Auteur : Pierre FICHEUX 	Lectra Systemes R & D
 *
 */
static char sccsid[] = "@(#)xzet.c	2.0 2/03/94";

/*
 * Partie principale
 */

#include <stdio.h>
#include <sys/types.h>
#include <linux/kernel.h>
#include <linux/sys.h>
#include <string.h>

/* 
 * Fichiers standards du toolkit Xt
 */
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Shell.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/StripChart.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xmu/Xmu.h>
#include <X11/Xmu/SysUtil.h>
#include "Ztach/Ztach.h"

/*
 * Public include files for widgets used in this file.
 */
#ifdef X11R3
#include <X11/Command.h>
#include <X11/Box.h>
#else /* R4 or later */
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#endif /* X11R3 */

#include "xzetmain.bit"
#include "xzetprocess.bit"
#include "xzetactivity.bit"
#include "xzetplist.bit"

Pixmap pixmap_icone = None, pixmap_xzet, pixmap_processus, 
					pixmap_activite, pixmap_plist;

/*
 * Widgets utilises pour Xzet
 */

Widget topLevel, forme_base, forme_activite, forme_processus;
Widget bouton_activite, bouton_processus, bouton_quit, bouton_quit_processus; 
Widget bouton_quit_activite, bouton_mise_a_jour_liste;
Widget popup_about, bouton_about, about_quit_button, about_list;
Widget shell_processus, shell_activite, liste_processus, viewport_processus;
Widget titre_idle, titre_user, titre_kernel, titre_wait, titre_sxbrk, titre_freemem;
Widget indicateur_idle, indicateur_user, indicateur_kernel, indicateur_wait;
Widget indicateur_sxbrk, indicateur_freemem;
Widget afficheur_idle, afficheur_user, afficheur_kernel, afficheur_wait;
Widget afficheur_sxbrk, afficheur_freemem;

Widget zman_process_info, zman_fs1, zman_fs1_data, zman_fs2, zman_fs2_data;
Widget zman_fs3, zman_fs3_data, zman_main_mem, zman_swap_mem;
Widget zman_free_scale_up, zman_free_scale, zman_free_scale_dn;
Widget zman_short_1, zman_short_2, zman_long;

Widget prototype_bouton_quit, prototype_label_titre, prototype_task_mem; 
Widget prototype_free_mem, prototype_cpu_hog, prototype_mem_hog;

typedef struct {
		char	*mount_point1;
		char	*mount_point2;
		char	*mount_point3;
		} ApplicationData, *ApplicationDataPtr;

static XtResource resources[] = {
	      { "zman_fs1_mount_point", XtCFile, XtRString, sizeof(char *),
		XtOffset(ApplicationDataPtr, mount_point1), XtRString, ""   },
	      {  "zman_fs2_mount_point", XtCFile, XtRString, sizeof(char *),
		XtOffset(ApplicationDataPtr, mount_point2), XtRString, ""   },				
	      { "zman_fs3_mount_point", XtCFile, XtRString, sizeof(char *),
		XtOffset(ApplicationDataPtr, mount_point3), XtRString, ""   },
		};
ApplicationData	z_file_systems;	     		


/* tampon */
static char buf[80];

/* Nom de la machine hote */
char host[20];	

/* Table des noms de processus */
extern String table_processus[];
extern	int	short_list, long_list;

extern void Activite(), Mise_a_jour_idle(), Mise_a_jour_user(), Mise_a_jour_kernel();
extern void Mise_a_jour_wait(), Mise_a_jour_sxbrk(), Mise_a_jour_freemem();
extern void Quit_activite(), Quit_processus(), Processus(), Selection();
extern void Mise_a_jour_liste();
extern void mesure_charge_courante_systeme ();
extern void init_charge();
extern void Zfs_UpDn();
extern void Zcolform();


/***************************************************************************
 *
 * 			About Box callback functions
 *
 ***************************************************************************/
void About(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
       {
    	XtPopup (popup_about, XtGrabNone);
       }

void Quit_About(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
       {
    	XtPopdown (popup_about); 
       }



/***************************************************************************
 *
 * 			quit button callback function
 *
 ***************************************************************************/
/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
    exit(0); 
}



/* 
 * Partie principale        I don't know the purpose of this, since it is  
 *			    never referenced, but it did need a slight change
 */
                                                /* changed by ZMAN */
/* static XtConvertArgRec screenConvertArg[] = { */
/*  {XtBaseOffset, (caddr_t) XtOffset(Widget, core.screen), sizeof(Screen *)} */
  static XtConvertArgRec const screenConvertArg[] = {
    {XtBaseOffset, (caddr_t) XtOffset(Widget, core.screen), sizeof(Screen *)}    
};



/**************************************************************************
 *
 *			MAIN ENTRY POINT OF PROGRAM
 *
 ****************************************************************************/
main(argc, argv)
int argc;
char **argv;
{
    Arg args[20];
    register int n;
    int dummy;
    unsigned int largeur_ecran, hauteur_ecran;
    Dimension check1, check2;
    Window root;
    Position	px, py;

    	Display		*zdisplay;
    	XrmDatabase	zdatabase;
    	char 		*zprogram;
    	char		*zclass;
    	XFontStruct	*about_font;

    /*
     * Initialisation du toplevel                INITIALIZE AP and DataBase
     */
    
    topLevel = XtInitialize(
			    argv[0], 	/* application name */
			    "XZet", 	/* application class name */
			    NULL, 	/* application resources (not used) */
			    0, 		/* application resource count */
			    &argc, 	/* command line argument count */
			    argv);	/* command-line string */

	zdisplay = XtDisplay(topLevel);
	zdatabase = XtDatabase(zdisplay);
	XtGetApplicationNameAndClass(zdisplay, &zprogram, &zclass);
	XtGetApplicationResources(topLevel, &z_file_systems, resources, 
						 XtNumber(resources), NULL, 0);
				
    /* nom du host */
    XmuGetHostname (host, 20);
    strcat (host, ":");

    XGetGeometry (zdisplay, XtScreen(topLevel)->root, &root, &dummy, &dummy, &largeur_ecran, &hauteur_ecran, &dummy, &dummy);

    pixmap_xzet = XCreateBitmapFromData(zdisplay, XtScreen(topLevel)->root, 
    				xzetmain_bits, xzetmain_width, xzetmain_height);
    pixmap_processus = XCreateBitmapFromData(zdisplay, XtScreen(topLevel)->root,
		xzetprocess_bits, xzetprocess_width, xzetprocess_height);
    pixmap_activite = XCreateBitmapFromData(zdisplay, XtScreen(topLevel)->root,
    		 xzetactivity_bits, xzetactivity_width, xzetactivity_height);

	pixmap_plist = XCreateBitmapFromData(zdisplay, XtScreen(topLevel)->root,
    		 	xzetplist_bits, xzetplist_width, xzetplist_height);	

    /*
     * Creation du widget de base (formWidget)          CR/MANAGED MAIN WIDGET
     */
    
    forme_base = XtCreateManagedWidget(
				       "forme_base",	
				       formWidgetClass,	
				       topLevel,	
				       NULL,	
				       0	
				       );
	
	
			/* create about box */
		
    	popup_about = XtCreatePopupShell ("About Xzet",
	                    applicationShellWidgetClass, forme_base, NULL, 0);
	n = 0;
	if ( (about_font = XLoadQueryFont(zdisplay, 
		"-adobe-times-*-r-*-*-20-100-*-*-*-*-iso8859-*")) == NULL)
	    if ((about_font = XLoadQueryFont(zdisplay, "10x20")) == NULL)
	    	if ((about_font = XLoadQueryFont(zdisplay, "9x15")) == NULL)	    
	                      ; /* do nothing */
	if (about_font != NULL)                      
		XtSetArg (args[n], XtNfont, about_font); n++;
    	XtSetArg (args[n], XtNlist, (String *)about_text); n++;
    	XtSetArg (args[n], XtNnumberStrings, 19); n++;
    	XtSetArg (args[n], XtNdefaultColumns, 1); n++;    	    	
    	about_list = XtCreateManagedWidget("about_list", listWidgetClass,
     						  popup_about, args, n);
	XtAddCallback(about_list, XtNcallback, Quit_About, 0);



    /***********************************************************************
     *
     * Creation des boutons 			 CR/MANAGED MAIN BUTTON WIDGETS
     *					         ...ACTIVITY, PROCESS, QUIT
     ***********************************************************************/
    
    /* Bouton activite */
    bouton_activite = XtCreateManagedWidget ("bouton_activite", 
    				commandWidgetClass, forme_base, NULL, 0);
    
    /* Bouton Processus */
    bouton_processus = XtCreateManagedWidget ("bouton_processus", 
    				commandWidgetClass, forme_base, NULL, 0);
    				
    /* Bouton About */
    bouton_about = XtCreateManagedWidget ("bouton_about", 
    				commandWidgetClass, forme_base, NULL, 0);				
    
    /* Bouton Quit */
    bouton_quit = XtCreateManagedWidget ("bouton_quit", commandWidgetClass, 
    							forme_base, NULL, 0);

   
    
    /*************************************************************************
     *
     * Creation des shells				CREATE SHELLS W/ICONS
     *							...PROCESS, ACTVITY
     *************************************************************************/
    
    /* Shell processus */
    n = 0;
    XtSetArg(args[n], XtNiconPixmap, pixmap_plist); n++;
    shell_processus = XtCreatePopupShell (strcat (strcpy (buf, host), "proc"),
    			    applicationShellWidgetClass, forme_base, args, n);
    
    /* Shell activite */
    n = 0;
    XtSetArg(args[n], XtNiconPixmap, pixmap_activite); n++;

    shell_activite = XtCreatePopupShell (strcat (strcpy (buf, host), "act"), 
    			    applicationShellWidgetClass, forme_base, args, n);

    
    
    				/* CR/MANAGED ACTIVITY AND PROCESS WIDGETS */ 
    
    
    /* Forme de base pour l'activite */
    forme_activite = XtCreateManagedWidget ("forme_activite", formWidgetClass,
    						      shell_activite, NULL, 0);

    /* Forme de base pour les processus */
    forme_processus = XtCreateManagedWidget ("forme_processus", formWidgetClass,
    				 		     shell_processus, NULL, 0);


    /* 
     * Creation du Viewport pour la liste   CR/MANAGED PROCESS VIEWPORT WIDGET
     */
    viewport_processus = XtCreateManagedWidget ("viewport_processus", 
    				viewportWidgetClass, forme_processus, NULL, 0);


					/*  CR/MANAGED PROCESS QUIT BUTTON  */
    /* Bouton Quit du shell processus */
    bouton_quit_processus = XtCreateManagedWidget ("bouton_quit_processus", 
    				commandWidgetClass, forme_processus, NULL, 0);

					/*  CR/MANAGED PROCESS UPDATE BUTTON */
    /* Bouton Mise a jour du shell processus */
    bouton_mise_a_jour_liste = XtCreateManagedWidget ("bouton_mise_a_jour_liste", 
    				 commandWidgetClass, forme_processus, NULL, 0);


			/* zmans process widgets */
			
	zman_short_1 = XtCreateManagedWidget ("zman_short_1", 
				commandWidgetClass, forme_processus, NULL, 0);
	zman_short_2 = XtCreateManagedWidget("zman_short_2",
                                commandWidgetClass, forme_processus, NULL, 0);
        zman_long = XtCreateManagedWidget("zman_long",
                                commandWidgetClass, forme_processus, NULL, 0);
	                                                                        

    /* 
     * Liste des processus 			SET UP PROCESS LIST WIDGET
     */
    n = 0;
    XtSetArg (args[n], XtNlist, (String *)table_processus); n++;
    liste_processus = XtCreateManagedWidget("liste_processus", listWidgetClass,
     						  viewport_processus, args, n);


			/* Get and Set List Element Sizes */
	n=0;
        XtSetArg(args[n], XtNlongest, &dummy); n++;
        XtGetValues (liste_processus, args, n);
        short_list = dummy;
        long_list = (int)(dummy * 1.525);
#ifdef DEBUG
        printf("\nProcess List: short = %d, long =  %d", short_list, long_list);
        fflush(stdout);     						 
#endif


    	/*
    	*	Create Managed Global Process info label
    	*/
	zman_process_info = XtCreateManagedWidget("zman_process_info",
				labelWidgetClass, forme_activite, NULL, 0); 
				                 

    /*
     *     Creation des lignes		CR/MANAGED STRIPCHART WIDGETS
     *					...Title Lables, Charts, Value Lables	
     */
      
    /* IDLE */
    titre_idle = XtCreateManagedWidget("titre_idle", labelWidgetClass, 
    						      forme_activite, NULL, 0);
    indicateur_idle = XtCreateManagedWidget ("indicateur_idle", 
    			       stripChartWidgetClass, forme_activite, NULL, 0);
    afficheur_idle = XtCreateManagedWidget ("afficheur_idle", labelWidgetClass, 
    						      forme_activite, NULL, 0);

    
    				/* USER */
    
    titre_user = XtCreateManagedWidget("titre_user", labelWidgetClass, 
    						     forme_activite, NULL, 0);
    indicateur_user = XtCreateManagedWidget ("indicateur_user", 
    			      stripChartWidgetClass, forme_activite, NULL, 0);
    afficheur_user = XtCreateManagedWidget ("afficheur_user", labelWidgetClass, 
    						     forme_activite, NULL, 0);

    
    				/* KERNEL - SYSTEM */
    				   
    titre_kernel = XtCreateManagedWidget("titre_kernel", labelWidgetClass, 
    						      forme_activite, NULL, 0);
    indicateur_kernel = XtCreateManagedWidget ("indicateur_kernel", 
    			       stripChartWidgetClass, forme_activite, NULL, 0);
    afficheur_kernel = XtCreateManagedWidget ("afficheur_kernel", 
    			 	    labelWidgetClass, forme_activite, NULL, 0);

    
    				/* WAIT - NICE */
    				
    titre_wait = XtCreateManagedWidget ("titre_wait", labelWidgetClass, 
    						      forme_activite, NULL, 0);
    indicateur_wait = XtCreateManagedWidget ("indicateur_wait", 
    			       stripChartWidgetClass, forme_activite, NULL, 0);
    afficheur_wait = XtCreateManagedWidget ("afficheur_wait", labelWidgetClass, 
    						      forme_activite, NULL, 0);

    
    				/* SXBRK  - FREE SWAP */
    				
    titre_sxbrk = XtCreateManagedWidget("titre_sxbrk", labelWidgetClass, 
    						      forme_activite, NULL, 0);
    indicateur_sxbrk = XtCreateManagedWidget ("indicateur_sxbrk", 
    			       stripChartWidgetClass, forme_activite, NULL, 0);
    afficheur_sxbrk = XtCreateManagedWidget ("afficheur_sxbrk", labelWidgetClass, 
    						      forme_activite, NULL, 0);


    				/* FREEMEM */
    
    titre_freemem = XtCreateManagedWidget("titre_freemem", labelWidgetClass, 
    						      forme_activite, NULL, 0);
    indicateur_freemem = XtCreateManagedWidget ("indicateur_freemem", 
    			       stripChartWidgetClass, forme_activite, NULL, 0);
    afficheur_freemem = XtCreateManagedWidget ("afficheur_freemem", 
    			            labelWidgetClass, forme_activite, NULL, 0);


			/* Create the new zman fs monitors and bits*/
	
	zman_free_scale = XtCreateManagedWidget("zman_free_scale", 
				  labelWidgetClass, forme_activite, NULL, 0); 
	zman_free_scale_up = XtCreateManagedWidget("zman_free_scale_up", 
				commandWidgetClass, forme_activite, NULL, 0); 
	zman_free_scale_dn = XtCreateManagedWidget("zman_free_scale_dn",
				commandWidgetClass, forme_activite, NULL, 0); 
				
	zman_fs1 = XtCreateManagedWidget("zman_fs1", labelWidgetClass,
				              	      forme_activite, NULL, 0); 
	zman_fs1_data = XtCreateManagedWidget("zman_fs1_data", labelWidgetClass,
				              	      forme_activite, NULL, 0); 
	zman_fs2 = XtCreateManagedWidget("zman_fs2", labelWidgetClass,
				              	      forme_activite, NULL, 0); 
	zman_fs2_data = XtCreateManagedWidget("zman_fs2_data", labelWidgetClass,
				              	      forme_activite, NULL, 0); 
	zman_fs3 = XtCreateManagedWidget("zman_fs3", labelWidgetClass,
				              	      forme_activite, NULL, 0); 
	zman_fs3_data = XtCreateManagedWidget("zman_fs3_data", labelWidgetClass,
				              	      forme_activite, NULL, 0); 
	zman_main_mem = XtCreateManagedWidget("zman_main_mem", labelWidgetClass,
				              	      forme_activite, NULL, 0); 
	zman_swap_mem = XtCreateManagedWidget("zman_swap_mem", labelWidgetClass,
				              	      forme_activite, NULL, 0); 

	
					  /* CR/MANAGED ACTIVITY QUIT BUTTON */    
    /* Bouton Quit du shell activite */
    bouton_quit_activite = XtCreateManagedWidget ("bouton_quit_activite", 
    				commandWidgetClass, forme_activite, NULL, 0);


				   /* CREATE INDIVIDUAL PROCESS QUIT BUTTON */
    /* Prototype des boutons quit des fenetres processus */
    prototype_bouton_quit = XtCreateWidget ("prototype_bouton_quit", 
    				    commandWidgetClass, forme_base, NULL, 0);


				    /* CREATE INDIVIDUAL PROCESS VIEW TITLE */ 
    /* Prototype des boutons des fenetres processus */
    prototype_label_titre = XtCreateWidget ("prototype_label_titre", 
    					labelWidgetClass, forme_base, NULL, 0);


			            /* CREATE INDIVIDUAL PROCESS CPU TACH */
    prototype_cpu_hog = XtCreateWidget ("prototype_cpu_hog", 
    				  ztachWidgetClass, forme_base, NULL, 0);

			            /* CREATE INDIVIDUAL PROCESS MEM TACH */
    prototype_mem_hog = XtCreateWidget ("prototype_mem_hog", 
    				  ztachWidgetClass, forme_base, NULL, 0);
					

			            /* CREATE INDIVIDUAL PROCESS TASK SIZE */
    prototype_task_mem = XtCreateWidget ("prototype_task_mem", 
    				  labelWidgetClass, forme_base, NULL, 0);

			            /* CREATE INDIVIDUAL PROCESS FREE SIZE */
    prototype_free_mem = XtCreateWidget ("prototype_free_mem", 
    				  labelWidgetClass, forme_base, NULL, 0);
	


				    /* SETUP CALLBACKS */
	XtAddCallback(zman_free_scale_up, XtNcallback, Zfs_UpDn, 0);
	XtAddCallback(zman_free_scale_dn, XtNcallback, Zfs_UpDn, 0); 
	XtAddCallback(zman_short_1, XtNcallback, Zcolform, 0); 
	XtAddCallback(zman_short_2, XtNcallback, Zcolform, 0); 		
	XtAddCallback(zman_long, XtNcallback, Zcolform, 0);
	XtAddCallback(bouton_about, XtNcallback, About, 0);
    XtAddCallback(bouton_quit, XtNcallback, Quit, 0);
    XtAddCallback(bouton_quit_processus, XtNcallback, Quit_processus, 0);
    XtAddCallback(bouton_mise_a_jour_liste, XtNcallback, Mise_a_jour_liste, 0);
    XtAddCallback(bouton_quit_activite, XtNcallback, Quit_activite, 0);
    XtAddCallback(bouton_processus, XtNcallback, Processus, 0);
    XtAddCallback(bouton_activite, XtNcallback, Activite, 0);
    XtAddCallback(liste_processus, XtNcallback, Selection, 0);

    /* callbacks des widget stripChart */
    XtAddCallback(indicateur_idle, XtNgetValue, Mise_a_jour_idle, NULL);
    XtAddCallback(indicateur_user, XtNgetValue, Mise_a_jour_user, NULL);
    XtAddCallback(indicateur_kernel, XtNgetValue, Mise_a_jour_kernel, NULL);
    XtAddCallback(indicateur_wait, XtNgetValue, Mise_a_jour_wait, NULL);
    XtAddCallback(indicateur_sxbrk, XtNgetValue, Mise_a_jour_sxbrk, NULL);
    XtAddCallback(indicateur_freemem, XtNgetValue, Mise_a_jour_freemem, NULL);


    /* Affichage */		/* CREATE THE MAIN WINDOW */
    XtRealizeWidget(topLevel);


				/* SETUP ICON */
    n = 0;
    XtSetArg (args[n], XtNiconPixmap, &pixmap_icone); n++;
    XtGetValues(topLevel, args, n);

    /*
     * Contruction de l'icone
     */
    n = 0;
    XtSetArg (args[n], XtNiconPixmap, &pixmap_icone); n++;
    XtGetValues(topLevel, args, n);

    if (pixmap_icone == None) {
	n = 0;
	XtSetArg(args[n], XtNiconPixmap, pixmap_xzet); n++;
	XtSetValues (topLevel, args, n);
    }


		/* SHOW ABOUT , BOOGIE ON.........*/ 
				
	About();	

    	/* Lecture de l'etat initial */
    	init_charge();

    	/* En route... */
    	XtMainLoop();
}
