/*
 * Copyright 1994 Loganville Technical Resources, Incorporated
 *
 *  standard GNU copyleft legalese mumbo-jumbo applies. (Really. I just don't
 *  want to copy all that stuff here, besides Johns got his below )
 *
 * 			Zmans Tachometer Widget 
 *
 * This is John Cwikla's hdial widget, (based on Youngs dial)slightly modified:
 *
 *              see the main source code for modification enumeration
 *
 *
 * Copyright 1992 John L. Cwikla
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of John L. Cwikla or
 * University of Illinois not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  John L. Cwikla and University of Illinois make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * John L. Cwikla and University of Illinois disclaim all warranties with
 * regard to this software, including all implied warranties of
 * merchantability and fitness, in no event shall John L. Cwikla or
 * University of Illinois be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of
 * use, data or profits, whether in an action of contract, negligence or
 * other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * Author:
 * 	John L. Cwikla
 * 	Materials Research Laboratory Center for Computation
 * 	University Of Illinois at Urbana-Champaign
 *	104 S. Goodwin
 * 	Urbana, IL 61801
 * 
 * 	cwikla@uimrl7.mrl.uiuc.edu
 */

/* Dial widget, based roughly on the dial widget by Douglas A. Young */

/* Default Translations:
 * <key>+: Increment(1)
 * Shift<key>+: Increment(100)
 * <key>-: Decrement(1)
 * Shift<key>-: Decrement(100)
 * <Btn1Down>: set()
 * <Btn1Motion>: set() drag()
*/

/* Resources:               	Type:                Defaults:
 * XtNforeground          	: pixel    	: XtNDefaultForeground
 * XtNlabelForeground          	: pixel    	: XtNDefaultForeground
 * XtNminimum             	: int      	: 0
 * XtNmaximum             	: int      	: 1000
 * XtNvalue               	: int      	: 0
 * XtNfont                	: XFontStruct   : XtNDefaultFont
 * XtNmargin              	: int      	: 5
 * XtNimcrementCallback   	: callback 	: NULL
 * XtNdecrementCallbacki  	: callback 	: NULL
 * XtNvalueChangeCallback 	: callback 	: NULL
 * XtNulabelForeground		: pixel		:XtNDefaultForeground
 * XtNufont			: XFontStruct	:XtNDefaultFont	
 * XtNulabel			: String	:NULL
 * XtNdrawTachArm		: Boolean       :TRUE
 * XtNrotateCW			: Boolean       :TRUE
 * XtNthickBits			: Boolean       :TRUE
 * XtNdrawArc			: Boolean  	:TRUE
 * XtNdrawMarkers		: Boolean  	:TRUE 
 * XtNdrawAhead			: Boolean  	:TRUE 
 * XtNdrawHole			: Boolean  	:TRUE 
 * XtNdrawNumstring		: Boolean  	:TRUE 
*/


#ifndef ZTACHP__H
#define ZTACHP__H

#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>
#include "Ztach.h"

typedef struct _ZtachPart
{
  Pixel foreground;
  Pixel labelForeground;
  XFontStruct *font;
  char label[11];	/* Label for number */
  int minimum; 		/* value */
  int maximum;		/* value */
  int value;
  int margin;
  XPoint center;
  XPoint top; 
  XPoint labelPos;
  XPoint UlabelPos;		/* User label Position   */
  char 	*Ulabel;		/* User label String     */
  Pixel UlabelForeground;       /* User label foreground color*/
  XFontStruct *ufont;		/* User label font */
  Dimension	UlabelHeight;	/* User label font height & width */
  Dimension	UlabelWidth;	
  GC		UlabelGC;	/* User label graphics context */
  Boolean	drawTachArm;    /* Draw the standard arm */
  Boolean	rotateCW;       /* rotate arm clockwise  */
  Boolean	thickBits;      /* Draw main arc and arrow thicker */
  Boolean       drawArc;	/* Draw main arc		*/
  Boolean       drawMarkers;	/* Draw scale tick  marks	*/  
  Boolean       drawAhead;	/* Draw Arrow Head (if !drawTachArm)	*/  
  Boolean       drawHole;	/* Draw center hole		*/  
  Boolean       drawNumstring;	/* Draw number string 		*/  
  Dimension labelHeight;
  Dimension labelWidth;
  Dimension lineWidth;
  double length;
  GC labelGC;
  GC gc;
  GC eraseGC;
  XtCallbackList incrementCallback;
  XtCallbackList decrementCallback;
  XtCallbackList valueChangeCallback;
} ZtachPart, *ZtachPartPtr;

typedef struct _ZtachRec
{
  CorePart core;
  ZtachPart ztach;
} ZtachRec, *ZtachPtr;

typedef struct _ZtachClassPart
{
  int empty;
} ZtachClassPart;

typedef struct _ZtachClassRec
{
  CoreClassPart core_class;	
  ZtachClassPart ztach_class;
} ZtachClassRec, *ZtachClassPtr;

extern ZtachClassRec ztachClassRec;

#endif /* ZTACHP__H */
