/*
 * Copyright 1994 Loganville Technical Resources, Incorporated
 *
 *  standard GNU copyleft legalese mumbo-jumbo applies. (Really. I just don't
 *  want to copy all that stuff here, besides Johns got his below )
 *
 * 			Zmans Tachometer Widget 
 *
 * This is John Cwikla's hdial widget, (based on Youngs dial)slightly modified:
 *
 *              see the main source code for modification enumeration
 *
 *
 * Copyright 1992 John L. Cwikla
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of John L. Cwikla or
 * University of Illinois not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.  John L. Cwikla and University of Illinois make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * John L. Cwikla and University of Illinois disclaim all warranties with
 * regard to this software, including all implied warranties of
 * merchantability and fitness, in no event shall John L. Cwikla or
 * University of Illinois be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of
 * use, data or profits, whether in an action of contract, negligence or
 * other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * Author:
 * 	John L. Cwikla
 * 	Materials Research Laboratory Center for Computation
 * 	University Of Illinois at Urbana-Champaign
 *	104 S. Goodwin
 * 	Urbana, IL 61801
 * 
 * 	cwikla@uimrl7.mrl.uiuc.edu
 */

/* Basically a simple widget roughly based on the one by Doug Young,
 * except that the dial is a semi-circle, and the indicator has an
 * arrow. 
*/

/* Default Translations:
 * <key>+: Increment(1)
 * Shift<key>+: Increment(100) 
 * <key>-: Decrement(1)
 * Shift<key>-: Decrement(100)
 * <Btn1Down>: set()
 * <Btn1Motion>: set() drag()
*/

/* Resources:               Type:                Defaults:
 * XtNforeground          	: pixel    	: XtNDefaultForeground
 * XtNlabelForeground          	: pixel    	: XtNDefaultForeground
 * XtNminimum             	: int      	: 0
 * XtNmaximum             	: int      	: 1000
 * XtNvalue               	: int      	: 0
 * XtNfont                	: XFontStruct   : XtNDefaultFont 
 * XtNmargin              	: int      	: 5 
 * XtNimcrementCallback   	: callback 	: NULL
 * XtNdecrementCallbacki  	: callback 	: NULL
 * XtNvalueChangeCallback 	: callback 	: NULL
 * XtNulabelForeground          : pixel         :XtNDefaultForeground
 * XtNufont                     : XFontStruct   :XtNDefaultFont
 * XtNulabel			: String	:NULL   
 * XtNdrawTachArm               : Boolean       :TRUE
 * XtNrotateCW                  : Boolean       :TRUE
 * XtNthickBits                 : Boolean       :TRUE  
 * XtNdrawArc                   : Boolean       :TRUE
 * XtNdrawMarkers               : Boolean       :TRUE 
 * XtNdrawAhead                 : Boolean       :TRUE 
 * XtNdrawHole                  : Boolean       :TRUE 
 * XtNdrawNumstring             : Boolean       :TRUE       
*/

#ifndef ZTACH__H
#define ZTACH__H

/*
** Ztach Widget
*/

extern WidgetClass ztachWidgetClass;
typedef struct _ZtachClassRec *ZtachWidgetClass;
typedef struct _ZtachRec *ZtachWidget;

#ifndef XtIsZtach
#define XtIsZtach(w) XtIsSubclass((w), ztachWidgetClass)
#endif

#define XtNlabelForeground "labelForeground"
#define XtNminimum "minimum"
#define XtNmaximum "maximum"
#define XtNincrementCallback "incrementCallback"
#define XtNdecrementCallback "decrementCallback"
#define XtNvalueChangeCallback "valueChangeCallback"
#define XtNmargin "margin"
#define XtNulabelForeground "UlabelForeground"
#define XtNulabel "Ulabel"
#define XtNufont "ufont"
#define XtNdrawTachArm "drawTachArm"
#define XtNrotateCW "rotateCW"
#define XtNthickBits "thickBits"  
#define XtNdrawArc "drawArc"
#define XtNdrawMarkers "drawMarkers"
#define XtNdrawAhead "drawAhead"
#define XtNdrawHole "drawHole"
#define XtNdrawNumstring "drawNumstring"

#define XtCLabelForeground "LabelForeground"
#define XtCULabelForeground "ULabelForeground"
#define XtCULabel "ULabel"
#define XtCUFont "UFont"
#define XtCMinimum "Minimum"
#define XtCMaximum "Maximum"
#ifndef XtCMargin
#define XtCMargin "Margin"
#endif

/* Reasons */
#define ZTACH_INCREMENT 1
#define ZTACH_DECREMENT 2
#define ZTACH_SET 3

typedef struct _ZtachCallbackStruct
{
  int reason;
  XEvent *event;
  int value;
} ZtachCallbackStruct, *ZtachCallbackPtr;

#endif /* ZTACH__H */
