/*
 *
 * 	Copyright (C) 1994  Loganville Technical Resources, Incorporated.
 *
 * Xzet is free software; you can redistribute it and/or modify it under the 
 * terms of the GNU General Public License as published by the Free Software 
 * Foundation; either version 2, or (at your option) any later version.  
 *
 * Xzet is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE. 
 *
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with 
 * xzet; see the file  COPYING. If  not, write to the Free Software Foundation, 
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 * 		
 *
*/
/* This struct maintains pointers for each processes popup widgets. */

struct process_widgets {
    	char flag_shell_actif;		/* TRUE si un popup shell existe */
    	Widget popup_shell;		/* widget popup shell 	*/
    	Widget forme;			/* widget form contenant les infos */
    	Widget label_titre;		/* widget titre 	*/
    	Widget label_car;		/* widget informations 	*/
    	Widget cpu_hog;			/* % cpu tachometer 	*/
    	Widget mem_hog;			/* % mem tachometer 	*/
	Widget task_mem;		/* Task Size		*/
	Widget free_mem;		/* Free Memory Size	*/
    	Widget quit;			/* widget de sortie 	*/
};


/* This struct maintains each processes cpu and memory utilization statistics
   as well as holding the pointer to the above struct. Do_stats fills it in. */  

struct save_hist {
  int ticks;
  int pid;
  int pcpu;
  int utime;
  int stime;
  struct process_widgets *widgets_ptr;          /* added element */
};


/* This struct holds global system information about processes, cpu & memory */ 

struct z_system_info {
			unsigned int	processes;
			unsigned int	sleeping;
			unsigned int	running;
			unsigned int	zombie;
			unsigned int	stopped;
			unsigned int	user_time;
			unsigned int	nice_time;
			unsigned int	system_time;
			unsigned int    idle_time;
			unsigned int    main_mem; 
			unsigned int	used_mem; 
			unsigned int	free_mem; 
			unsigned int	shared_mem; 
			unsigned int	buf_mem;
			unsigned int 	swap_mem; 
			unsigned int    used_swap; 
			unsigned int    free_swap;
		};	


/* This struct holds the names of the file systems to be monitored */

typedef struct {
		char	*mount_point1;
		char	*mount_point2;
		char	*mount_point3;
		} ApplicationData, *ApplicationDataPtr;
