/*
 * ps.h
 *
 * Copyright (c) 1992 Branko Lankester
 *
 */

#include <linux/tty.h>
#include <linux/sched.h>

#include <linux/mm.h>
#include <asm/page.h>
#include <asm/pgtable.h>

#define PAGE_ACCESSED	_PAGE_ACCESSED
#define PAGE_DIRTY	_PAGE_DIRTY
#define PAGE_PRESENT	_PAGE_PRESENT
#define PAGE_RW		_PAGE_RW

extern unsigned long nr_pages;

extern int show_env;	/* -e flag */
extern int kern_comm;	/* -c flag */
extern int maxcmd;

extern char *swappath[];
extern char *kmem_path;

#define	MAXCMD	512	/* max # bytes to copy from args/env */

#define	PZERO	15	/* priority of init (in sched.h) */


extern caddr_t kbase;

#define	KWORD(a)	(*((unsigned long *)(kbase + (a))))
#define	KPTR(p)		((void *) ((unsigned long) (p) + kbase))


#define	KSTK_EIP(stack)	((stack)[1019])
#define	KSTK_ESP(stack)	((stack)[1022])

#define	_SSIZE(stack)	(TASK_SIZE - KSTK_ESP(stack))
#define	SSIZE(stack)	(KSTK_ESP(stack) ? _SSIZE(stack) : 0)

#define	VSIZE(task,stack) ((task)->pid == 0 ? 0 : \
			  (((task)->mm->brk + 1023 + SSIZE(stack)) / 1024))
#define	SIZE(task,stack)  ((task)->pid == 0 ? 0 : \
			  (((task)->mm->brk - (task)->mm->end_code + 1023 + \
			  SSIZE(stack)) / 1024))

#define TASK_TTY(task)		((task)->tty ? (task)->tty->device : -1)
#define TASK_TTY_PGRP(task)	((task)->tty ? (task)->tty->pgrp : -1)

typedef unsigned reg_t;

struct mem_info {
    int size;
    int rss;	/* should be the same as task->rss */
    int trs;	/* text resident set size */
    int drs;	/* dirty pages */
    int swap;	/* pages swapped out */
    int share;
    int lrs;	/* shared library rss */
    int dt;	/* dirty library pages */
    int acc;
    int dirt;
    int wp;
    int pmem;
};

struct mem_info *get_mem_info(struct task_struct *task);
char *find_func(unsigned long eip);
char *find_tty(dev_t rdev);
unsigned long k_addr(char *sym);
unsigned long get_kword(unsigned long addr);
char *cmd_args(struct task_struct *task);
char *wchan(reg_t ebp, reg_t *stack, int numeric);
char *status(struct task_struct *task);
void *xmalloc(int size);
void read_globals(void);
int tty_to_dev(char *tty);
char *dev_to_tty(int dev);
int tty_pgrp(int tty);
char *user_from_uid(int uid);
int kmemread(void *buf, unsigned long addr, int size);
int mmap_init(void);
int mmap_page(unsigned long addr);
void get_memmap(void);
char *attime(time_t *time);
void strmode(mode_t mode, char *p);
