// Copyright Richard Laxton (u2105546@cumulus.csd.unsw.oz.au),
// Distributed under GPL.

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include "cpumeter.h"
#include "port.h"

main()
{
  unsigned char lights;
  int load;
  CPUMeter cpumeter;

  // Open the I/O port for the first parallel port
  if(ioperm(0x378,1,1)) {
    fprintf(stderr,"ioperm error.\n");
    exit(1);
  }

  // Main loop to get cpu load and output to lights
  while (1) {
    lights = 0;
    load = cpumeter.checkevent( 8 );
    for ( ; load > 0; load--)
      lights |= 1 << (load-1);
    port_out(0x378, lights);
    usleep(50000);
  } 
}
