/* getinput.c
   get inputs from user:
     read a line from the screen, save this line into history table
	(hisrec) and tokenize the line into argvect.
  functions:	getline(), SkipBlank();
		TohisTbl();
		gettoken().
*/
 
#include "smash.h"
 
extern int special_sym;	

int getline(char *line)
{
  register int c,i=0;
 
  SkipBlank();
  while( i<LLEN && (c=getchar())!=EOF && c!=C_EOL )
  {
    line[i++] = c;
    if( c==C_SPC || c==C_TAB )
      SkipBlank();
  }
  if( c==EOF )
      exit(0);          /* EOF == ^D */
  if( i == LLEN )
  {
      printf("line too long\n");
      return( -1 );
  }
  line[i] = EOS;
  return( i+1 );
}

void SkipBlank()
{
  register int c;
  while( (c=getchar())==C_SPC || c==C_TAB )
        ;
  (void)ungetc(c,stdin);
}


/*----------------------------------------------------------*/
/* This function accesses hisrec.
*/
void ToHisTbl(char *line, HISRECORD *phisrec)
{
  phisrec->hisring[phisrec->rear].order = ++(phisrec->count);
  (void)strcpy( phisrec->hisring[phisrec->rear].cmdln, line );
  phisrec->rear = Succ(phisrec->rear);
}
 
/*----------------------------------------------------------*/
int gettoken(char *line, char ***pargv)
{
  register int idxl=0, idxarg=0;
  register int c,d;
  static char *argv[MAXTOKEN];
 
  argv[idxarg++] = line;
  while( (c=line[idxl++]) != EOS ) 
	{
    if( c==C_QUOT || c==C_QQUOT ) 
		{
        d = c;
        while( (c=line[idxl++]) != d )
                ;
    }
    if( c==C_SPC || c==C_TAB ) 
		{
        line[idxl-1] = EOS;
        argv[idxarg++] = &(line[idxl]);
    }
  } 
  if( argv[idxarg-1][0] == C_BKGRD ) 
	{
/*	printf("\n found a & \n"); */
		special_sym=BKGRD;
		idxarg--;
   }
	else if( argv[1][0] == C_REDIR1 ) 
	{
		printf("\nfound a > \n"); 
		special_sym=REDIRECT1;
 		/* idxarg--;  */
	}

  argv[idxarg] = EOS;
  *pargv = argv;
  return( idxarg );
}

