/*
Copyright (C) 1995  Brian Cully

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 675 Mass
Ave, Cambridge, MA 02139, USA.

please send patches or advice to: `shmit@meathook.intac.com'
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <string.h>

#include "misc.h"
#include "screen.h"

/* Print an error message (str) on stderr and exit */
static void error(char *str) {
   fprintf(stderr, "%s", str);
   exit(1);
}

/* Finds the named menu
*/

static int find_menu(struct menu **menu, char *name) {
   struct menu *q=*menu;

   while (q->prev)
      q = q->prev;

   while (q && (strcmp(q->name, name))) {
      q = q->next;
   }
   
   if (q) {
      *menu = q;
      return 0;
   } else
      return -1;
}

/* Interface to screen module
   Execute menu item
   item == item to execute
   *menu == menu list ptr, for use with MENU_SUBs */
void exec_item(struct menu_items item, struct menu **menu) {
   pid_t pid_child;
   int child_stat;

   switch (item.type) {
   case MENU_SUB:
      if (!find_menu(menu, item.args)) {
	 display_list(*menu);
      }
      else
         fprintf(stderr, "No menu named %s\n", item.name);
      break;

   case MENU_EXEC:
      clear_scr();
      close_scr();
      
      if ((pid_child = fork()) == -1)
	 error("No more pids\n");
      else if (pid_child > 0) {
	 waitpid(pid_child, &child_stat, 0);
      } else {
	 system(item.args);
	 exit(0);
      }

      printf("[----Hit <CR> when ready----]\n");
      getchar();
      init_scr();
      clear_scr();
      break;
   }
}
