/* $Header: /home/klaus/mgetty/voice/RCS/voclib.h,v 1.51 1994/10/28 21:02:04 klaus Exp $ */

#include "vmodem.h"

/***** voice options *****/

/* VOICE_DIR is defined in the Makefile, default /usr/spool/voice.
 * All paths below are relative to VOICE_DIR unless they start with
 * a slash. */

/* maximum recording length in seconds, hang up if somebody talks
 * longer than this. */
#define VOICE_MAX_LEN 300

/* silence length in 1/10 seconds, default 7 seconds. */
#define VOICE_SILENCE_LEN 70

/* silence threshold, 0.0 to 1.0, increase this if you have a noisy
 * phone line and the silence detection doesn't work reliably. */
#define VOICE_SILENCE_THRESHOLD 0.6

/* minimum length of detected DTMF tones, in milliseconds.
 * This is currently used only for the ZyXEL, ROM >= 6.12 */
#define VOICE_DTMF_LEN 36

/* DTMF tone detection threshold, 0.0 to 1.0.
 * increase this if the modem erroneously detects DTMF tones,
 * decrease it if it fails to detect real ones.
 * Currently only used for the ZyXEL, ROM >= 6.12 */
#define VOICE_DTMF_THRESHOLD 0.4

/* compression mode for incoming messages
 * ZyXEL: 1=CELP,  2=ADPCM-2,  3=ADPCM-3,  4=ADPCM-4
 * Rockwell: 2, 3, or 4 (bits/sample) */
#define VOICE_REC_COMPRESSION 4

/* Volume of the internal speaker when answering the phone.
 * 0.0 is off, 1.0 is maximum. */
#define SPEAKER_ANSWER_VOLUME 0.6

/* Volume of the internal speaker when it is used to play a message. */
#define SPEAKER_PLAY_VOLUME 1.0

/* bps rate for zplay, must be high enough for the compression
 * mode used. Note that this is an integer, not one of the
 * Bxxxx defines.
 * This *MUST* be set to 38400 for Rockell modems. */
#define VOICE_SEND_BAUD 38400

/* The R_FFT_PROGRAM is responsible for distinguishing voice and
 * data calls if the line is not silent. It checks the power spectrum
 * of the sound data and, if it only contains few frequencies, sends
 * a SIGUSR2 to vgetty to make it stop recording. This is also quite
 * effective against dial tones. (Code by ulrich@Gaston.westfalen.de)
 *
 * It needs to convert the voice data, i.e. it currently
 * works only for ZyXEL adpcm-2 and adpcm-3. It is automatically
 * disabled if it can't deal with the voice data.
 *
 * There are a few configurable parameters, check the top of
 * pvffft.c for details. The defaults seem to work quite well.
 *
 * Undefine R_FFT_PROGRAM if you don't want this, i.e. if you
 * have a slow machine that can't handle the additional CPU load. */
#define R_FFT_PROGRAM		"vg_fft" /* */

/* If vgetty knows that there are new messages (the flag file
 * exists), it will turn on the AA lamp and enable the toll saver - it
 * will answer the phone TOLL_SAVER_RINGS earlier than the default. */
#define TOLL_SAVER_RINGS 2

/* If REMOVE_SILENCE is enabled, the trailing silence will be deleted
 * if the modem detected quiet. This might cause you to miss parts of
 * a message if the silence threshold is high and the caller is
 * talking very quietly. To be on the safe side, don't define this. */
#define VOICE_REMOVE_SILENCE /* */

/* Should message files be kept even if DTMF codes were detected?
 * Set this to TRUE to keep them, to FALSE if not. */
#define VOICE_ALWAYS_KEEP_MESSAGE TRUE

/* Support for distinctive RINGs, if you don't want this just undefine
 * DIST_RING below. This is only tested for ZyXELs, let me know if
 * you make it work on other modems.
 *
 * A simple "RING" or RING_VOICE below cause vgetty to behave as usual,
 * i.e. answer initially in voice mode and switch if appropiate.
 * RING_DATA or RING_FAX cause it to answer in fax/data mode immediately.
 * If the ring isn't one of the types above, the call is ignored and
 * vgetty won't pick up the phone. */
#define DIST_RING /* */

#define DIST_RING_INIT	"ATS40.3=1 S40.4=1 S40.5=1 S40.6=1"
#define DIST_RING_VOICE	A_RING1
#define DIST_RING_DATA	A_RING2
#define DIST_RING_FAX	A_RING3


/***** the defines below only need to be changed if you want
 ***** to change the way vgetty works */


/***** files and directories *****/

/* If you change the defines below, you will have to edit the shell
 * scripts for the external programs or supply your own.
 * Some of the file names below are hardcoded in the scripts. */

/* location of the flag for new incoming messages */
#define R_MESSAGE_FLAG_FILE	"incoming/.flag"

/* Log file for the `zplay' utility */
#define R_VOICE_LOG		"Voicelog"

/* Location of the optional answer mode file, %s is replaced with the
 * device name. If the file doesn't exist, use 'voice/fax/data' as
 * default setting. */
#define R_VOICE_ANSWER_FILE	"/etc/answer.%s"

/* where to put the incoming voice messages */
#define R_VOICE_RECEIVE_DIR	"incoming"

/* directory containing the greeting messages */
#define R_VOICE_MESSAGE_DIR	"messages"

/* file containing message file names, one per line, no white space,
 * path relative to VOICE_MESSAGE_DIR */
#define R_VOICE_MESSAGE_LIST	"messages/Index"

/* filename of a backup greeting message in VOICE_MESSAGE_DIR (used if
 * the random selection fails to find a message) */
#define R_VOICE_BACKUP_MESSAGE	"messages/standard"

/***** external programs *****/

/* The programs defined below get called by vgetty. The modem will
 * still be in voice mode and is connected to STDIN. vgetty will
 * set the argument(s) ($1 for shell scripts, argv[1] for C programs)
 * as described.
 * (Undefine the macro if you don't want the program to be called)
 */

/* Program called when a voice message has been received.
 * Argument: filename of the recorded message */
#define R_MESSAGE_PROGRAM		"vg_message"

/* There are two separate uses for the DATA/VOICE button:
 * - if a RING was detected recently, answer the phone in fax/data mode
 * - otherwise, call an external program to play back messages
 *
 * If you don't define R_BUTTON_PROGRAM, vgetty will always pick up
 * the phone if DATA/VOICE is pressed.
 *
 * Argument: "button" (a constant string) */
#define R_BUTTON_PROGRAM	"vg_button"

/* Program called when a DTMF command ( '*DIGITS#' )
 * is received.
 * Argument: the DIGITS received (without '*' and '#') */
#define R_DTMF_PROGRAM		"vg_dtmf"

/* Program called when the phone is answered, this is *INSTEAD*
 * of the normal behaviour. Don't define this unless you want
 * to i.e. set up a voice mailbox where the normal answering
 * machine behaviour would be inappropiate. The C code is probably
 * more stable and uses less resources. */
/* #define R_CALL_PROGRAM	"vg_call" */

/* command sequence used to answer the phone. */
#define VOICE_ATA "ATA"


/***** End of configuration options *****/


/* nothing configurable below this line */

typedef char *path_t;

extern path_t voice_log, voice_receive_dir, voice_message_dir,
              voice_message_list, voice_backup_message, message_flag_file,
	      message_program, button_program, dtmf_program,
              voice_fft_program, call_program, voice_answer_file;

extern boolean verbose;
extern char *voice_rel;
extern int voice_modem;

extern void voice_path_init _PROTO((void));
extern int voice_command _PROTO(( char * send, char * expect, int fd ));
extern int voice_open_device _PROTO((char * voice_tty));
extern int voice_open _PROTO((char * voice_ttys));
extern void voice_close _PROTO((int fd));
extern boolean voice_format_supported _PROTO((int compr));
extern int voice_data_rate _PROTO((int compr));
extern int voice_beep _PROTO((int fd, int voc_io, char *beep));
extern int voice_send_file _PROTO((char * voc_file, int fd,
				   int voc_io, int silence));
extern int voice_record_file _PROTO(( char *voc_file, int fd, int voc_io,
			     int compr, int silence, double threshold,
			     int timeout, boolean do_fft));
extern int voice_send_init _PROTO((int fd, int vocfd, int voc_io));
extern int voice_record_init _PROTO((int fd, int compr, int voc_io,
				     int silence, double threshold,
				     char *header));
extern void voice_mode_off _PROTO((int fd));
extern void voice_message_light _PROTO((void));
extern void voice_rings _PROTO((int *rings_wanted));
extern void voice_button _PROTO((int rings));
extern void voice_answer _PROTO((int rings, int rings_wanted,
				 action_t what_action));
extern void voice_activate_digits _PROTO((void));
extern char* voice_get_digits _PROTO((void));
extern char* voice_flush _PROTO((int fd));
extern void voice_set_ignore _PROTO((char *ignore));
extern void enter_data_mode _PROTO((int answer_mode));

#define ETX	003
#define DLE	020
#define DC2	022
#define XON	021
#define XOFF	023

#define	ERROR	-1
#define NOERROR	0

#define ANSWER_DATA  0x01
#define ANSWER_FAX   0x02
#define ANSWER_VOICE 0x04
