/* $Header: /home/klaus/mgetty/voice/RCS/vanswer.c,v 1.42 1994/10/20 00:28:15 klaus Exp $ */

/* handle a voice call: play answering message, beep, record
   and switch back to data mode if appropiate. */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/times.h>

#include "policy.h"
#include "mgetty.h"
#include "fax_lib.h"
#include "voclib.h"

#ifdef NO_STRSTR
char *
strstr _P2((haystack, needle), const char* haystack, const char* needle)
{
    /* This isn't terribly efficient, but it'll do for now. */
    int l, n, i;
    l=strlen(haystack);
    n=strlen(needle);

    for (i = 0; i <= l-n; i++) {
        if (strncmp(&haystack[i], needle, n) == 0) return haystack + i;
    }
    return 0;
}
#endif

void
voice_rings _P1((rings_wanted), int *rings_wanted)
{
    extern char *DevID;
    FILE *fin, *flag;
    int i,l;
    char buf[MAXLINE];

    sprintf(buf, voice_answer_file, DevID);
    fin=fopen(buf, "r");
    if (fin) {
	while (fgets(buf, MAXLINE, fin)) {
	    l=strlen(buf);
	    for(i=0; i<l; i++) buf[i]=tolower(buf[i]);

	    if (strstr(buf, "rings")) {
		sscanf(buf, "rings %d", rings_wanted);
		lprintf(L_NOISE, "rings_wanted = %d", *rings_wanted);
		if (*rings_wanted <=0) *rings_wanted=1;
	    }
	}
	fclose(fin);
    }

#ifdef R_MESSAGE_FLAG_FILE
    /* Are there messages waiting ? */
    flag=fopen(message_flag_file, "r");

    if (flag) {
	*rings_wanted -= TOLL_SAVER_RINGS;
	if (*rings_wanted < 1) *rings_wanted=1;
	fclose(flag);
    }
#endif
}

void
voice_message_light _P0(void)
{
    /* With external modems, the auto-answer LED can be used
       to show a status flag. vgetty uses this to indicate
       that new messages have arrived.
       
       Since vgetty doesn't remember what happened during previous
       calls, a flag file is used to mark the status. */

#ifdef R_MESSAGE_FLAG_FILE
    /* Are there messages waiting ? */
    FILE *flag=fopen(message_flag_file, "r");

    if (flag) {
	/* turn on the AA lamp */
	voice_command("ATS0=255", "OK", STDIN);
	fclose(flag);
    } else {
	/* turn it off */
	voice_command("ATS0=0", "OK", STDIN);
    }
#endif
}

static int /* answer_mode */
get_answer_mode _P0(void)
{
    /* check for a "answer mode" file (/etc/answer.<DevID>) */

    extern char *DevID;
    FILE *fin;
    int i,l;
    char buf[MAXLINE];
    int answer_mode = 0;

    sprintf(buf, voice_answer_file, DevID);
    fin=fopen(buf, "r");
    if (!fin) return answer_mode = ANSWER_FAX | ANSWER_VOICE | ANSWER_DATA;

    while (fgets(buf, MAXLINE, fin)) {
	l=strlen(buf);
	for(i=0; i<l; i++) buf[i]=tolower(buf[i]);

	if (strstr(buf, "voice")) answer_mode |= ANSWER_VOICE;
	if (strstr(buf, "fax" )) answer_mode |= ANSWER_FAX;
	if (strstr(buf, "data")) answer_mode |= ANSWER_DATA;
    }
    fclose(fin);
    lprintf(L_NOISE, "answer_mode is %d", answer_mode);
    if (answer_mode==0) {
	lprintf(L_MESG, "don't accept any kind of call!");
	clean_line(STDIN, 80);	/* wait for ringing to stop */
	exit(1);
    }
    return answer_mode;
}

static char *
greeting_message_file _P0(void)
{
    static char path[MAXPATH];
    
    FILE *list;
    char msg[MAXPATH];
    
    list=fopen(voice_message_list, "r");
    if (!list) {
	strcpy(msg, voice_backup_message);
    } else {
	int i, m, n=0;
	/* count the messages */
	while (fgets(msg, MAXPATH, list)) {
	    if (strlen(msg)>1) n++;
	}
	lprintf(L_MESG, "found %d messages", n);
	/* pick a random one (could use rand() here) */
	m=getpid() % n;
	rewind(list);
	for(i=0; i<=m; i++) fgets(msg, MAXPATH, list);
	i=strlen(msg);
	if (i && msg[i-1]=='\n') msg[i-1]=0;
	fclose(list);
    }
    
    /* make the filename */
    if (msg[0]!='/') {
	sprintf(path, "%s/%s", voice_message_dir, msg);
    } else {
	strcpy(path, msg);
    }
    
    lprintf(L_NOISE, "picked file %s", path);
    return path;
}

static void
remove_message _P1((message), char *message)
{
    /* throw away the recording */
    lprintf(L_MESG, "removing recording.");
    unlink(message);
}

static void
button_program_and_exit _P0(void)
{
    /* exec button program */
    lprintf(L_NOISE, "button pressed");
#ifdef R_BUTTON_PROGRAM
    lprintf(L_NOISE, "executing %s", button_program);
    (void) execl(button_program, button_program,
		 "button", (char *) NULL);
    (void) execl("/bin/sh", "sh", button_program,
		 "button", (char *) NULL);
    lprintf(L_ERROR, "cannot execute %s", button_program);
#endif
    exit(1);
}

static void
fork_message_program _P1((message), char *message)
{
    /* don't exit afterward, hence the fork. */
#ifdef R_MESSAGE_PROGRAM
    int status, pid;
    extern char *CallerId;
    
    switch(pid=fork()) {
      case -1:
	lprintf(L_WARN, "can't fork message program");
	break;
      case 0:
	/* child */
	lprintf(L_NOISE, "executing %s %s %s",
		message_program, message, CallerId);
	(void) execl(message_program, message_program,
		     message, CallerId, (char *) NULL);
	(void) execl("/bin/sh", "sh", 
		     message_program, message, CallerId, (char *) NULL);
	lprintf(L_ERROR, "cannot execute %s", message_program);
	exit(1);
    }
    /* parent */
    lprintf(L_NOISE, "waiting for message program to exit...");
    while (wait(&status) != pid)
	;
    lprintf(L_NOISE, "... done");
#endif
}

static void
keep_message_and_exit _P1((message), char *message)
{
    lprintf(L_MESG, "Voice message received, stored in %s.",
	    message);

    /* beep */
    voice_beep(STDIN, VIO_TELCO, "[933,0,12]");
    fork_message_program(message);
    exit(0);
}

#ifdef R_CALL_PROGRAM
static int
fork_call_program _P1((DevID), char *DevID)
{
    /* hand over control to a shell script - note that this
     * isn't as well tested and stable as the C code. You also
     * won't get proper logging or random greeting message selection.
     * Don't enable this unless you know what you are doing.
     */
    int status, pid;
    
    switch(pid=fork()) {
      case -1:
	lprintf(L_WARN, "can't call message program");
	return ERROR;
	break;
      case 0:
	/* child */
	lprintf(L_NOISE, "executing %s", call_program);
	(void) execl(call_program, call_program, DevID, (char *) NULL);
	(void) execl("/bin/sh", "sh", call_program, DevID, (char *) NULL);
	lprintf(L_ERROR, "cannot execute %s %s", call_program, DevID);
	exit(1);
    }
    /* parent */
    lprintf(L_NOISE, "waiting for call script to exit...");
    while (wait(&status) != pid)
	;
    lprintf(L_NOISE, "...done, call script status is %d", status);
    return status;
}
#endif

static void
dtmf_program_and_exit _P2((dtmf, message),
			  char *dtmf, char *message)
{
    if (message) {
	/* Remove the recording? */
	if (VOICE_ALWAYS_KEEP_MESSAGE) {
	    /* keep it */
	    fork_message_program(message);
	} else {
	    remove_message(message);
	}
    }
    
    lprintf(L_MESG, "got DTMF command.");

    /* call the external program to handle the DTMF command. */
#ifdef R_DTMF_PROGRAM
    lprintf(L_NOISE, "executing %s <digits>", dtmf_program);
    (void) execl(dtmf_program, dtmf_program, dtmf, (char *) NULL);
    (void) execl("/bin/sh", "sh", dtmf_program, dtmf, (char *) NULL);
    lprintf(L_ERROR, "cannot execute %s", dtmf_program);
#endif
    exit(1);
}

void
voice_button _P1((rings), int rings)
{
#ifdef R_BUTTON_PROGRAM
    if (rings==0) {
	/* The data/voice button was pushed, but the phone didn't ring. */
	/* Call the external program. */
	button_program_and_exit();
    }
#endif
    
    /* answer in fax/data mode */
    enter_data_mode(ANSWER_FAX | ANSWER_DATA);
    return;
}

static void
log_call_length _P1((logmsg), char *logmsg) {
    /* add the call length data to the log message */   
    time_t call_end;
    extern time_t call_start;
    
    time(&call_end);
    call_end -= call_start;
    
    sprintf(logmsg+strlen(logmsg), ", time=%02d:%02d:%02d",
	    (int)(call_end / 3600), (int)((call_end / 60) % 60),
	    (int)(call_end % 60));
}

void
voice_answer _P3((rings, rings_wanted, ring_action), 
		 int rings, int rings_wanted,
		 action_t ring_action)
{
    static char *voice_answer_chat_seq[] = { "", VOICE_ATA, "VCON",
						 NULL };
    extern char *DevID;
    int answer_mode;
    char *path;
    int ret;
    char message[MAXPATH];
    char logmsg[1024];

    /* check for a "answer mode" file (/etc/answer.<DevID>) */
    answer_mode = get_answer_mode();
    
    if (ring_action >= A_RING1 && ring_action <= A_RING5) {
	if (ring_action != DIST_RING_FAX &&
	    ring_action != DIST_RING_DATA &&
	    ring_action != DIST_RING_VOICE)
	{
	    lprintf(L_MESG, "ignoring distinctive RING %d",
		    ring_action - A_RING1 + 1);
	    clean_line(STDIN, 80);
	    lprintf(L_AUDIT, "call ignored");
	    exit(1);
	}
    }
    
    if (ring_action == DIST_RING_FAX) {
	/* caller is known to be a fax */
	enter_data_mode(answer_mode & ANSWER_FAX);
	return;
    }

    if (rings < rings_wanted || !(answer_mode & ANSWER_VOICE)) {
	/* enter fax/data mode */
	enter_data_mode(answer_mode);
	return;
    }
    
    /*** answer the phone normally ***/
    
    /* answer the phone in voice mode */
    if (do_chat(STDIN, voice_answer_chat_seq, NULL,
		 NULL, 10, TRUE) == FAIL) {
	lprintf(L_FATAL, "can't answer the phone in voice mode");
	exit(1);
    }
    
#ifdef R_CALL_PROGRAM
    /* let the shell script handle the call */
    ret = fork_call_program(DevID);
    if (ret == 0) {
	exit(0); /* everything taken care of */
    } else if (ret != ERROR) {
	enter_data_mode(answer_mode);
	return;
    }
    /* something went wrong, try again using the C code */
#endif
    
    sprintf(logmsg, "dev=%s, pid=%d, caller=%s, name='%s'",
	    DevID, getpid(), CallerId, CallName);

    /*** play a greeting message ***/
    
    path=greeting_message_file();
    ret=voice_send_file(path, STDIN, VIO_TELCO, 0) ;
    lprintf(L_NOISE, "voice_send_file returned '%c'", ret);
    
    if (ret=='E') {
	lprintf(L_AUDIT, "error during playback, %s", logmsg);
	exit(1);
    } else if (ret=='#' || ret=='V') {
	lprintf(L_AUDIT, "hangup request, %s", logmsg);
	exit(1);
    } else if (ret=='d' || ret=='b') {
	lprintf(L_AUDIT, "nobody there, %s", logmsg);
	exit(1);
    } else if (ret=='c') {
	enter_data_mode(answer_mode & ANSWER_FAX); /* it's a fax */
	return;
    } else if (ret=='e') {
	enter_data_mode(answer_mode & ANSWER_DATA); /* it's data */
	return;
    } else if (ret>='0' && ret<='9') {
	char dtmf[2];
	lprintf(L_AUDIT, "voice dtmf <digit>, %s\n", logmsg);
	dtmf[0]=ret;
	dtmf[1]=0;
	dtmf_program_and_exit(dtmf, 0);
    }

    /*** beep ***/

    voice_beep(STDIN, VIO_TELCO, "[933,0,12]");
	    
    /*** record a message and/or DTMF tones ***/

    message[0] = '\0';
    
    sprintf(message, "%s/voc-XXXXXX", voice_receive_dir);
    mktemp(message);

    voice_activate_digits();

    ret=voice_record_file(message, STDIN, VIO_TELCO, VOICE_REC_COMPRESSION,
			  VOICE_SILENCE_LEN, VOICE_SILENCE_THRESHOLD,
			  VOICE_MAX_LEN, TRUE);
    lprintf(L_NOISE, "voice_record_file returned '%c'", ret);

    if (ret == 's') {
	/* assume it's a fax/data call */
	remove_message(message);
	enter_data_mode(answer_mode);
	return;
    } else if (ret == 'c') {
	/* it's a fax */
	remove_message(message);
	enter_data_mode(answer_mode & ANSWER_FAX);
	return;
    } else if (ret == 'e') {
	/* it's data */
	remove_message(message);
	enter_data_mode(answer_mode & ANSWER_DATA);
	return;
    }
    
    log_call_length(logmsg);

    if (ret=='#') {
	char *dtmf;
	dtmf=voice_get_digits();
	if (dtmf && dtmf[0]) {
	    /* Caller typed a DTMF command */
	    lprintf(L_AUDIT, "voice dtmf <digits>, %s\n", logmsg);
	    dtmf_program_and_exit(dtmf, message);
	}
    }
    
    /* seems to have been a normal voice message. */
    /* res should be one of [qbd#ET] */
    lprintf(L_AUDIT, "voice keep %s\n", logmsg);
    keep_message_and_exit(message);

    /* call finished, exit */
    exit(0); 
}
