/***************************************************************************
**			State University of Groningen
**				    ICCE
**
**			       Frank B. Brokken
**
**	Copyright (c) State University of Groningen, ICCE, the Netherlands.
** 
**			This file is part of callback.
**
**
****************************************************************************


Callback was originally developed by Karel Kubat (karel@icce.rug.nl)

Callback version 2.00 was developed by Frank B. Brokken (frank@icce.rug.nl)
who is, as of February 1995, the maintainer of the callback software.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
ICCE OR THE STATE UNIVERSITY OF GRONINGEN BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.

Except as contained in this notice, the name of the ICCE shall not be used in
advertising or otherwise to promote the sale, use or other dealings in this
Software without prior written authorization from the ICCE.

*/
#include "cblogin.h"

int main(int argc, char **argv)
{
    int					
	state,
	uid;
    char
	*tty_name;

					    /* set the version */
    progversion(argv[0], CBLOGIN_VERSION);
    banner();				/* print banner of this program */

    atexit(reinit);			/* reload init at exit */

					/* find the tty_name */
    if (!(tty_line = ttyname(fileno(stdin))))
	error("Can't find the tty-name");

					/* use the name without /dev/ */
    tty_name = strrchr(tty_line, '/') + 1;

    parse_setupfile();			/* parse the setupfile */

    tty_names(tty_name);		/* overrule any defaultline */

    if (!getstate(&state, &uid))	/* if statefile indicates */
	first_login(argv[1]);		/* state 0: first login */
    else				/* else: this is a callback. */
	exec_login(uid);		/* run original login */

    return (0);				/* return success */
}
