%include <filters.h>
#
# Magic filter setup file for the HP LaserJet with
# less than 1.5 Mb of RAM (150 DPI for most things)
# THIS FILE IS UNTESTED!
#
# This file has been automatically adapted to your system.
%ifndef HAVE_GHOSTSCRIPT
# However, since you didn't have GhostScript installed, most entries
# are going to be rejects.
%endif
#

# PostScript files: use GhostScript to convert to printer format
%ifdef HAVE_GHOSTSCRIPT
0	%!		filter	PATH_GHOSTSCRIPT -q -dSAFER -dNOPAUSE \
	-r150 -sDEVICE=laserjet -sOutputFile=- -
%define PS_OK 1
%else
# 0	%!		filter	/usr/local/bin/gs -q -dSAFER -dNOPAUSE \
#	-r150 -sDEVICE=laserjet -sOutputFile=- -
0	%!		reject	Cannot print PostScript on this printer
%endif

# DVI files: convert to PostScript using dvips
%if defined(HAVE_DVIPS) && defined(PS_OK)
0	\367\002	fpipe	PATH_DVIPS -D 150 -R -q -f
%define DVI_OK 1
%else
# 0	\367\002	fpipe	/usr/local/bin/dvips -D 150 -R -q -f
0	\367\002	reject	Cannot print DVI files on this printer.
%endif

# compress'd data
%ifdef ZCAT
0	\037\235	pipe	ZCAT
%else
0	\037\235	reject	Cannot print compressed files on this printer.
%endif

# compressed files (packed, gzip, freeze, and SCO LZH respectively)
%ifdef GZCAT
0	\037\036	pipe	GZCAT
0	\037\213	pipe	GZCAT
0	\037\236	pipe	GZCAT
0	\037\240	pipe	GZCAT
%else
0	\037\036	reject	Cannot print packed files on this printer.
0	\037\213	reject	Cannot print gzipped files on this printer.
0	\037\236	reject	Cannot print frozen files on this printer.
0	\037\240	reject	Cannot print SCO LZH files on this printer.
%endif

# troff documents
0	.so\040		reject	Attempted to print a ".so" troff file.
%if defined(HAVE_GROG) && defined(PS_OK)
%define HANDLE_TROFF	fpipe	`PATH_GROG -Tps $FILE`
%elif defined(HAVE_GROFF) && defined(PS_OK)
# We don't have "grog", so use options appropriate for man pages
%define HANDLE_TROFF	pipe	PATH_GROFF -Tps -t -mandoc
%elif defined(HAVE_DITROFF) && defined(DITROFF_WORKS) && defined(PS_OK)
# We have "ditroff", so we should be able to do this; if you have "ditroff"
# and know how to use it, please send email to <Peter.Anvin@linux.org>
%endif
%ifdef HANDLE_TROFF
0	.\?\?\040	HANDLE_TROFF
0	.\\\"		HANDLE_TROFF
0	'\\\"		HANDLE_TROFF
0	'.\\\"		HANDLE_TROFF
0	\\\"		HANDLE_TROFF
%else
0	.\?\?\040	reject	Cannot print troff files on this printer.
0	.\\\"		reject	Cannot print troff files on this printer.
0	'\\\"		reject	Cannot print troff files on this printer.
0	'.\\\"		reject	Cannot print troff files on this printer.
0	\\\"		reject	Cannot print troff files on this printer.
%endif

# ditroff
%if defined(HAVE_GROPS) && defined(PS_OK)
0	"x T ps"	pipe	PATH_GROPS
%else
0	"x T ps"	reject	Cannot print PostScript ditroff files.
%endif
%if defined(HAVE_GRODVI) && defined(DVI_OK)
0	"x T dvi"	pipe	PATH_GRODVI
%else
0	"x T dvi"	reject	Cannot print DVI ditroff files.
%endif
%ifdef HAVE_GROTTY
0	"x T ascii"	pipe	PATH_GROTTY
0	"x T latin1"	pipe	PATH_GROTTY
%else
0	"x T ascii"	reject	Cannot print ASCII ditroff files.
0	"x T latin1"	reject	Cannot print Latin-1 ditroff files.
%endif
0	"x T lj4"	reject	Cannot print LJ4 ditroff files.

# Portable bit-, grey- and pixmaps: convert to PostScript
%if defined(HAVE_PNMTOPS) && defined(PS_OK)
0	P1\n		pipe	PATH_PNMTOPS \
	-scale 1000 -dpi 150 2>/dev/null
0	P2\n		pipe	PATH_PNMTOPS \
	-scale 1000 -dpi 150 2>/dev/null
0	P3\n		pipe	PATH_PNMTOPS \
	-scale 1000 -dpi 150 2>/dev/null
0	P4\n		pipe	PATH_PNMTOPS \
	-scale 1000 -dpi 150 2>/dev/null
0	P5\n		pipe	PATH_PNMTOPS \
	-scale 1000 -dpi 150 2>/dev/null
0	P6\n		pipe	PATH_PNMTOPS \
	-scale 1000 -dpi 150 2>/dev/null
%define PNM_OK 1
%else
0	P1\n		reject	Cannot print PBM files on this printer.
0	P2\n		reject	Cannot print PGM files on this printer.
0	P3\n		reject	Cannot print PPM files on this printer.
0	P4\n		reject	Cannot print PBM files on this printer.
0	P5\n		reject	Cannot print PGM files on this printer.
0	P6\n		reject	Cannot print PPM files on this printer.
%endif

# PCL control codes almost always start with a "reset" and are
# usually followed by at least one additional PCL control code.
0	\033E\033	cat

# PJL: Sorry, this printer doesn't do PJL
0	\033%-12345X	reject	Cannot print PJL files on this printer.
0	"@PJL "		reject	Cannot print PJL files on this printer.
0	@PJL\t		reject	Cannot print PJL files on this printer.
0	@PJL\r		reject	Cannot print PJL files on this printer.
0	@PJL\n		reject	Cannot print PJL files on this printer.

# GIF files: convert to PPM
%if defined(HAVE_GIFTOPPM) && defined(PNM_OK)
0	GIF87a		pipe	PATH_GIFTOPPM 2>/dev/null
0	GIF89a		pipe	PATH_GIFTOPPM 2>/dev/null
%else
0	GIF87a		reject	Cannot print GIF images on this printer.
0	GIF89a		reject	Cannot print GIF images on this printer.
%endif

# JFIF (JPEG) files: convert to PPM/PGM
%if defined(HAVE_DJPEG) && defined(PNM_OK)
0	\377\330\377\340\?\?JFIF\0	pipe	PATH_DJPEG -pnm
%else
0	\377\330\377\340\?\?JFIF\0	reject	Cannot print JPEG/JFIF \
	images on this printer.
%endif

# TIFF files (lousy magic!!)
%if defined(HAVE_TIFFTOPNM) && defined(PNM_OK)
0	MM		pipe	PATH_TIFFTOPNM 2>/dev/null
0	II		pipe	PATH_TIFFTOPNM 2>/dev/null
%else
0	MM		reject	Cannot print TIFF images on this printer.
0	II		reject	Cannot print TIFF images on this printer.
%endif

# BMP files (even lousier magic -- I guess that's what you can expect
# for something out of Microsoft)
%if defined(HAVE_BMPTOPPM) && defined(PNM_OK)
0	BM\?\?\?\?\?\?\?\?\?\?\?\?\x0c	pipe	\
	PATH_BMPTOPPM 2>/dev/null
0	BM\?\?\?\?\?\?\?\?\?\?\?\?\x40	pipe	\
	PATH_BMPTOPPM 2>/dev/null
0	BM\?\?\?\?\?\?\?\?\?\?\?\?\x28	pipe	\
	PATH_BMPTOPPM 2>/dev/null
%else
0	BM\?\?\?\?\?\?\?\?\?\?\?\?\x0c	reject	Cannot print OS/2 1.x \
	bitmaps on this printer.
0	BM\?\?\?\?\?\?\?\?\?\?\?\?\x40	reject	Cannot print OS/2 2.x \
	bitmaps on this printer.
0	BM\?\?\?\?\?\?\?\?\?\?\?\?\x28	reject	Cannot print Windows 3.x \
	bitmaps on this printer.
%endif

# Sun rasterfiles
%if defined(HAVE_RASTTOPNM) && defined(PNM_OK)
0	\x59\xa6\x6a\x95 pipe	PATH_RASTTOPNM 2>/dev/null
%else
0	\x59\xa6\x6a\x95 reject	Cannot print Sun rasterfiles on this printer.
%endif

# SGI Imagelib (RGB) files
%if defined(HAVE_SGITOPNM) && defined(PNM_OK)
0	\x1\xda		pipe	PATH_SGITOPNM 2>/dev/null
0	\xda\x1		pipe	PATH_SGITOPNM 2>/dev/null
%elif defined(HAVE_TOPS) && defined(sgi) && defined(PS_OK)
0	\x1\xda		fpipe	PATH_TOPS $FILE
0	\xda\x1		fpipe	PATH_TOPS $FILE
%elif defined(HAVE_SGITOPS) && defined(PS_OK)
0	\x1\xda		fpipe	PATH_SGITOPS $FILE
0	\xda\x1		fpipe	PATH_SGITOPS $FILE
%else
0	\x1\xda		reject	Cannot print SGI RGB files on this printer.
0	\xda\x1		reject	Cannot print SGI RGB files on this printer.
%endif

%include <stdrejects.mh>

# wild guesses
# PCL control codes start with <ESC>
0	\033		cat
%ifdef HANDLE_TROFF
# optimistic troff magic
0	.		HANDLE_TROFF
# wacko troff magic
0	'''		HANDLE_TROFF
%endif

# Default entry -- for normal (text) files.  MUST BE LAST.
default			cat	\eE\e&k2G\e(0N	\eE


