/******************************************************
 * CNPRINT.C For CNPRINT Version 2.30 (VMS and UNIX) *
 ******************************************************
  Copyright YIDAO CAI (~{2LR@5@~}), 1992, 1993  
  All Rights Reserved.
  Free for non-commercial and personal use only.  

Disclaimer: Posting CNPRINT on any FTP site does not imply the author's
	endorsement of the beliefs of the organization who owns the FTP site.

CNPRINT, a utility to print Chinese text (or convert to PostScript) under 
	DOS, VMS and UNIX systems. It works just as a print command on your 
	system.  Currently GB, Hz and BIG-5 formats are supported. 

*** PLEASE read CNPRINT.HELP first EVEN if you have used CNPRINT before ***

YIDAO CAI  cai@neurophys.wisc.edu
October 24, 1993
*****************************************************/

#include <stdio.h>
#include <time.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#define CNLIB  "j24" /* if HBFPATH is not defined, change "j24" to HBF file 
    name with full path.  e.g.
	VMS: "mvsd:[cai.font]cnj24.hbf"  ! you can not simply copy this, 
	UNIX: "~/font/cnj24.hbf"	 ! change the path to fit your needs */
#define TIME 1
#define GB "_gb"
#define PS "_ps"
#define HZ "_hz"
#define tempfile "CNPRINT.TMP"
#define Version "CNPRINT V2.30 (VMS & UNIX) OCT-24-1993"
#define EOL '\n'
#define IN 1
#define OUT 0
#define R 1
#define L 2
#define NT 0
#define BUFSIZE 7168
#define isvgb(c) (c==0x21 || c==0x2c || c==0x3A || c==0x3B || c==0x3F)
#define bell fprintf(stderr, "%c", (8-1))
#define Outofmemory fprintf(stderr, "Not enough memory\n");

 /* margins, line space (CLP) and char spaces */
int 	LM, RM, TM, BM, CSP, CLP, maxCLP, H, V;
float	XX, YY;			/* paper size */
int	Xw, Yh, Xa, Ya;
float	pts;   			/* 1 pts = 10 div = 1/72 inch */
static float Cw=7.;		/* char width/line space */
float	Ci, Ca;			/* space between lines, characters */
float	Casc=0.5;		/* ASC width / CH width */
int	nCN=2048, copies=1;	/* # of entries in CNdict */
char	prntcmd[50];

char	PSfile[100], INfile[100];
int 	pts0, ptspc;		/* pts0=INT(pts+0.5), ptspc is from PC */
int	defFont=1;
int	mx, my, Nx, CHsize;	/* bitmap size mx by my, string length CHsize */
int 	inCH=100, newpos=1;         
int	filecount=1, fprntfile=1, pgcount=1, fputnpage=1; 
int	pgpd=0;			/* physical pages actually printed */
int	bp=0, ep=0;		/* page numbers to begin/end printing */
int	Prntpage, odd=0;  /* page-print flag; 0/1/2, print all/odd/even pages */
int	frl=NT;			/* right-left */
int     fnewline=1;
int     cnsp=0;			/* special CH char */
int	*fstring, *fdict, nchar, cspace;
unsigned char	**ptstring, *array;
float 	gray=.0;	/* 0 black, .9 white */
float	Cx=1., Cy=1.;
int	fshade=0;
int 	Hzfile=0, hztogb=0;
int 	pause=0;	/* pause at every (pause) pages */
int	RMirror=0;	/* rotated mirror bitmap */
int	landscape=0, EPS=0;
int	vertical=0, Rotate=0, vgb=0;
int	suppress=0, mute=0, keepPS=0;
int	adjust=1;	/* adjust spaces between punctuation marks */
int	alnumadjust=0;	/* adjust alnum from CH to English */
int	timestat=0;	/* suppress time / statistics about document */
int	AdjAtEndDoc=1;	/* BM adjust at end of document if multicolumn */
int	big5=0;
int	cmdlinehbf=0;	/* hbf filename supplied in command-line */
int	cgap=0;		/* gap between columns in pts, use default if zero */
int 	nEF=2, nEFs[40];	/* ASC font */
float	Wasc[95];	/* width of ASC char re Courier */
static char *EFname[]={"AvantGarde-Book", "", "Courier", "Helvetica", "", "", 
"Palatino-Roman", "Times-Roman", "ZapfChancery-MediumItalic", "ZapfDingbats",
"AvantGarde-BookOblique", "", "Courier-Oblique", "Helvetica-Oblique", 
"", "", "Palatino-Italic", "Times-Italic", "", "", 
"AvantGarde-Demi", "", "Courier-Bold", "Helvetica-Bold", "", "", 
"Palatino-Bold", "Times-Bold", "", "",
"AvantGarde-DemiOblique", "", "Courier-BoldOblique", "Helvetica-BoldOblique", 
"", "", "Palatino-BoldItalic", "Times-BoldItalic", "", "Symbol"};
		/*  for search  */
int 	PCN=0, SCN=0;
int 	scnsp=0;
int	sfrl=NT;	/* right-left for search */ 
int	cTM, cBM, cLM, cRM, Hs, clptmp, Ha=0;
int	sinCH=100;
int	pline=0, pcolumn=1;
int 	sline=0, column=1;
int	lineclp[300], linedif[300], fsnewl=0; 
/* for HBF */
char	root[100], HBFname[100], defHBFname[100]; 
struct Bytes {int l; int h;} *byte2;
struct HBFrange {int l; int h; int offset; 
		char bmfname[50]; FILE *fp;} *seg;
int	nbyte2, nseg; 

/* functions */
void newline(), snewline(), endAC(), charsize(), usage(), opnfile();
void HBFclose();
int columnWidth();

FILE	*in, *out, *HBF;

int HBFopen() 
{       /* open HBF file, set segment and byte-2-ranges, open bitmap files */
	int j, k, m;
	char cst[120];

	if ((HBF=fopen(HBFname, "r"))==NULL) {
		fprintf(stderr, 
"Can't open HBF file -> %s\n\
Please check if the file exists and if the path/directory is correct\n\
and/or read CNPRINT.HELP for information about fonts/HBF files\n", HBFname); 
		bell; 
		if (*defHBFname==0) exit(-1);
		else return 0; 
	}

	while (fgets(cst, 119, HBF)!=NULL)
 		if (strncmp(cst, "HBF_BITMAP_BOUNDING_BOX", 23)==0) break;
	sscanf(cst, "%*s%d%d", &mx, &my);
	CHsize=my*((mx+7)/8);
	if (array!=NULL) free(array);
	array = (unsigned char *) calloc(CHsize+1, sizeof(unsigned char));
	if (array==NULL) { Outofmemory; exit(2); }

	while (fgets(cst, 119, HBF)!=NULL)
 		if (strncmp(cst, "HBF_START_BYTE_2_RANGES", 23)==0) break;
	sscanf(cst, "%*s%d", &nbyte2);
	byte2 = (struct Bytes *) calloc(nbyte2, sizeof(struct Bytes));
	if (byte2==NULL) { Outofmemory; exit(2); }
	for (j=0; j<nbyte2; j++) {
		while (fgets(cst, 119, HBF)!=NULL)
 			if (strncmp(cst, "HBF_BYTE_2_RANGE", 16)==0) break;
		sscanf(cst, "%*s%i-%i", &(byte2[j].l), &(byte2[j].h));
	}

	while (fgets(cst, 119, HBF)!=NULL)
 		if (strncmp(cst, "HBF_START_CODE_RANGES", 21)==0) break;
	sscanf(cst, "%*s%d", &nseg);
	seg = (struct HBFrange *) calloc(nseg, sizeof(struct HBFrange));
	if (seg==NULL) { Outofmemory; exit(2); }
	for (j=0; j<nseg; j++) {
		while (fgets(cst, 119, HBF)!=NULL)
 			if (strncmp(cst, "HBF_CODE_RANGE", 14)==0) break;
		sscanf(cst, "%*s%i-%i%s%d", &(seg[j].l), &(seg[j].h), 
			seg[j].bmfname, &(seg[j].offset));
		if (j>0) {
		    for (m=0; m<j; m++) 
			if (strcmp(seg[m].bmfname, seg[j].bmfname)==0) 
				seg[j].fp=seg[m].fp; 
		}
		if (seg[j].fp==NULL) {
		    strcpy(cst, root); strcat(cst, seg[j].bmfname);
		    if ((seg[j].fp = fopen(cst, "rb"))==NULL) {
			fprintf(stderr, 
"Can't open bitmap font file -> %s\n\
Please make sure this file exists\n\
and the HBF file is properly written\n", cst); bell; 
			if (*defHBFname==0) exit(-2);
			else return 0; 
		    }
		}
	}
	return 1; 
}

void HBFclose() 
{       /* Reset segment and byte-2-ranges, close bitmap files and HBF file */
	int j;
	for (j=0; j<nseg; j++) fclose(seg[j].fp);
	free(seg); free(byte2);
	fclose(HBF);
}
 
int HBFgetBitmap(ch)
int ch; 
{	/* according to segment and byte-2-ranges, get bitmap string, 
	   or return 0 for out-of-range char */
	int i, j, k, sq16=256;
	long addr; 
	for (i=0; i<nseg; i++) 
	    if (ch >= seg[i].l && ch <= seg[i].h) { 
		ch -= seg[i].l; k = seg[i].l%sq16; j=ch%sq16;
		if (big5) addr = ch/sq16*157 
			+ ((j >= 0xA1-k) ? (j-(0x40-k)-34) : j-(0x40-k));
		else addr = ch/sq16*94 + j - (0xA1-k);
		addr = addr*CHsize + seg[i].offset;
		fseek(seg[i].fp, addr, 0);
		k = (int) fread(array, CHsize, 1, seg[i].fp);
		if (RMirror) RotateMirrorBitmap(array);
		return k;
	    }
	fprintf(stderr, "Out of Range Char: %04X\n", ch);
	for (j=0; j<CHsize; j++) array[j]=0; 
	return 0;
}

int RotateMirrorBitmap(a)
unsigned char *a;
{	/* rotate a mirror bitmap: matrix transpose, Bij = Aji */
	unsigned char B[256], ON[8];
	int j, k, n;
	ON[0]=128;
	for (j=1; j<8; j++) ON[j]=ON[j-1]/2; 
	for (j=0; j<CHsize; j++) {
  	    B[j]=0;
	    for (k=0; k<8; k++) {
		n = k*mx +j*mx*8; n = n/(mx*mx) + n%(mx*mx);
		B[j] += ( (( a[n/8] & ON[n%8] )? 1 : 0)* ON[k]);
	    }
	}
	for (j=0; j<CHsize; j++) a[j]=B[j];
	return 1;
}


int num(v, n)
char *v[];
int n;
{
	int m=0;
	if (isdigit(*++v[0])) {
		m = *v[0]-'0';
		if (n==1) return m;
		if (isdigit(*++v[0])) m = m*10 + (*v[0]-'0');
		else v[0]--;
	}
	else v[0]--;
	return m;
}

void init(argc, v)
int argc;
char *v[];
{
	char 	c, d, cst[100];
	int 	m, n, j=0, HBFopen();
	int 	bpYes=0, ASCfile=0;

	if (argc==999) goto B5INIT;
	prntcmd[0]='\0';
	*HBFname=0; *defHBFname=0; *INfile=0; *PSfile=0;
	while (--argc>0) if (*(++v)[0] == '-') {
	    while (c = *++v[0]) {
		if (bpYes) bpYes--;
		switch (c) {
		    case '5': big5++; break;
		    case 'a': 
			if (!ASCfile) alnumadjust++; 
			if (alnumadjust==2) {ASCfile=1; alnumadjust=0;}
			break;
		    case 'b': bp=num(v, 2); bpYes=2; break;
		    case 'c': 
			if ((m=num(v, 1)) <= 1) break;
			else column=m;
			if ((m=num(v, 2)) >= 10) cgap=m;
			else if (m && m<10) v[0]--;
			break;
		    case 'd': adjust=0; Casc=0.5; break;
		    case 'e': 
			m=num(v,2);
			if (bpYes) ep=m;
			else if (m) {
				Casc = m/10.; if (m>=10) Casc /= 10.;
			}
 			else {
				EPS=1; fputnpage=0; keepPS=1;
			}
			break;
		    case 'f': strcpy(HBFname, *(++v)); 
			argc--; v[0] += (strlen(HBFname)-1); 
			cmdlinehbf=1;
			break;
		    case 'j': AdjAtEndDoc=0; break;
		    case 'l': d = *++v[0]; landscape=1; column=2;
			if (d<='0' || d>='5') v[0]--;
			else landscape += (d-'0');
			break;
		    case 'm': m=num(v,1);
			if (!m) mute=1;
			else if (m>=1 && m<=9) copies=m;
			break;
		    case 'n': 
			sscanf(*(++v), "%d", &m);
			if (m>=0 && m<=4000) nCN=m;
			argc--; v[0] += (strlen(*v)-1);
			break;
		    case 'o': odd++; break;
		    case 'p': pause=4;
			if (m=num(v,1)) pause=m;
			break;
		    case 'q':
			if (*++v[0] == '=') {
				++v[0]; sscanf(*v, "%s", prntcmd);
				v[0] += (strlen(prntcmd)-1);
			}
			else v[0]--;
			break;
		    case 'r': RMirror=1; break;
		    case 's': suppress = (num(v, 1) > 1)? 2:1; break;
		    case 't': timestat++; break;
		    case 'u': keepPS=1; break;
		    case 'v': vertical++; Rotate=1; adjust=0; break;
		    case 'w': fprntfile=0; break;
		    case 'x': case 'y':
			if (m=num(v, 1)) {
				if (c=='x') Cx += (m/10.);
				else Cy += (m/10.); 
			}
			break;
		    case 'z': hztogb++; break;
		    case 'h':
			if (*++v[0] == 'z') {Hzfile++; break;}
		    default:  usage(); exit(0);
		}
	    }
	}
	else if (*INfile==0) strcpy(INfile, *v);
	else if (*PSfile==0) {
		strcpy(PSfile, *v); keepPS++;
	}
	else {
		usage(); exit (1);
	}
/* end while-if */

	if (*INfile==0) {
		usage(); exit (1);
	}
	opnfile(IN); opnfile(OUT);
	if (vertical>1 && !big5) vgb=1;
	if (hztogb && hztogb<3) return;
	getroot();
B5INIT:	if (argc==999) {
		if (!cmdlinehbf) *HBFname=0;
		else fprintf(stderr, 
"HBF font file supplied at command line is used\n\
*** Abort if incorrect ***\n");
	}
	if (big5 && *HBFname==0) getdata(2);
	if (*HBFname==0) {
	    if (big5) {
		fprintf(stderr, 
"No HBF file specified for Big-5 in either cnprint.cmd or command line\
Please read Part IV of CNPRINT.HELP\
on how to specify HBF file for BIG-5 document.\n");
		exit(7);
	    }
	    else strcpy(HBFname, CNLIB);
	}
	m=0;
	strcpy(cst, HBFname);
	for (j=strlen(HBFname) - 3; j>=0 ; j--)
  		if (isdigit(cst[j+1]) && isdigit(cst[j+2])) m=j;
	if (m==0) sprintf(HBFname, "%scn%s.hbf", root, cst);
	if (HBFopen()==1)
		if (argc!=999) fprintf(stderr, "%s\n\n", Version);
	Nx=mx;		/* Nx: CH font size */
	strcpy(defHBFname, HBFname);

	nchar= big5 ? 13973 : 8178; /* 8178=94*87, 13973=(63+94)*89 */
	cspace= big5 ? 0xA140 : 0xA1A1;
	fstring = (int *) calloc(nchar+1, sizeof(int));
	ptstring= (unsigned char **) calloc(nchar+1, sizeof(unsigned char *));
	if (fstring==NULL || ptstring==NULL) { Outofmemory; exit(2); }
	if (big5) adjust=0;
	if (argc==999) return;

	if (!getdata(0)) {	/* cnprint.cmd not found */ 
		XX=8.5; YY=11;
		pts = ((landscape)? 12.5 : 14.5)/(Cx+Cy-1);
		Ca=1.; Ci=Cy+(Cx-1.)/2.;
		LM=261; RM=219; TM=252; BM=275; /* mm*10 */
		if (landscape) {
			LM=153; RM=152; TM=200; BM=220;
		}
	}
	if (prntcmd[0]=='\0') fprntfile=0;
	if (landscape>1) {
		LM=153; RM=152; TM=200; BM=220;
		switch (landscape) {
		    case 2: Cy=1.2; Ci=1.1; pts=12.5; break;
		    case 3: pts=12.5; break;
		    case 4: Cy=1.2; Ci=1.1; pts=12.2; break;
		    case 5: pts=12.2; break;
		    default: break;
		}
	}
	if (ASCfile) {
		Ci=0.5; Casc=0.6;
		TM=180; BM=180; /* mm*10 */
	}
}

int getdata(n)
int n; 
{
	char t[100], *s;
	int j, k, m[10]; 
	float x1, x2, x3, x4;
	FILE *cmd;
	strcpy(t, root); 
	strcat(t, "cnprint.cmd"); 
	if ((cmd=fopen(t, "r"))==NULL) {
		if (n>0) fprintf(stderr, 
"Can't open file %s\n\
Please check if the file exists or if the path is correct\n\
and/or read CNPRINT.HELP for information on cnprint.cmd\n", t);
		return 0;
	}
/* get metric data for ASCII fonts */
	if (n==1) {
	    if (strlen(EFname[nEF])<=1) return 0;
    	    while (fgets(t, 98, cmd)!=NULL) 
		if (strncmp(EFname[nEF], t, strlen(EFname[nEF]))==0) break; 
	    k=0;
	    while (fgets(t, 98, cmd)!=NULL) {
		if (!strncmp(t, "DATA:", 5)) {
			sscanf(t, "%*s%d%d%d%d%d%d%d%d%d%d", &m[0], &m[1], 
			&m[2], &m[3], &m[4], &m[5], &m[6], &m[7], &m[8], &m[9]);
			j=0; 
			while(k<95) {
				Wasc[k++]=m[j++]/10000.; 
				if (k==17) while (k<=25) Wasc[k++]=Wasc[16];
				if (j==10) break;
			}
		}
		if (k>=95) break;
	    }
	    if (k<95) {
		fclose(cmd); return 0;
	    }
	}
/* Default BIG-5 font */
	else if (n==2) {
	    while(fgets(t, 98, cmd)!=NULL) {
		if (strncmp(t, "DEFAULT_BIG5FONT", 16)) continue;
		sscanf(t, "%*s%s", HBFname);
		break;
	    }
	}
/* PS print command, paper size, margins, etc */
	else if (n==0) {
	    x1=x2=0;
	    while(fgets(t, 98, cmd)!=NULL) {
		if (strncmp(t, "DEFAULT_PAPERSIZE", 17)) continue;
		sscanf(t, "%*s%f%f", &x1, &x2);
		break;
	    }
	    if (x1<1. || x2<1.) {XX=8.5; YY=11;}
	    else {XX=x1; YY=x2;}
	    fseek(cmd, 0, 0);
	    if (fprntfile) while(fgets(t, 98, cmd)!=NULL) {
		if (strncmp(t, "PS_PRINT_COMMAND", 16)) continue; 
		s = &t[j=17]; 
		while(s[0]==' ') s = &t[++j];
		j=0;
		while(s[j]) if (s[j++]==EOL) s[j-1] = '\0';
		if (!strlen(prntcmd)) strcpy(prntcmd, s);
		break;
	    }
	    fseek(cmd, 0, 0);
	    x1=x2=x3=x4=0;
	    while(fgets(t, 98, cmd)!=NULL) {
		if (strncmp(t, "PAPER_MARGINS", 13)) continue;
			/* margin: R L T B */
		if (!landscape) sscanf(t, "%*s%f%f%f%f", &x1, &x2, &x3, &x4);
		else sscanf(t, "%*s%*f%*f%*f%*f%f%f%f%f", &x1, &x2, &x3, &x4);
		break;
	    }
	    if (x1<2.9 || x2<2.9 || x3<2.9 || x4<2.9) {
		LM=261; RM=219; TM=252; BM=275; /* mm*10 */
		if (landscape) {
			LM=153; RM=152; TM=200; BM=220;
		}
	    }
	    else { LM = x1*10; RM = x2*10; TM = x3*10; BM = x4*10;} 
	    fseek(cmd, 0, 0);
	    x1=x2=x3=x4=0;
	    while(fgets(t, 98, cmd)!=NULL) {
		if (strncmp(t, "SIZE_SPACE", 10)) continue;
			/* Ppts, Lpts, char & line space */
		sscanf(t, "%*s%f%f%f%f", &x1, &x2, &x3, &x4);
		break;
	    }
	    if (x1<2. || x2<2. || x3<.09 || x4<.09) {
		pts = ((landscape)? 12.3 : 14.5)/(Cx+Cy-1);
		Ca=1.; Ci=Cy+(Cx-1.)/2.;
	    }
	    else {
		pts = (landscape)? x2 : x1; Ca=x3;
		Ci = (x4>.99 && x4<1.01)? (Cy+(Cx-1.)/2.) : x4;
	    }
	}
	fclose(cmd);
	return 1;
}

void opnfile(n)
int n;
{
	if (n==IN) {
		if ((in=fopen(INfile, "r"))==NULL) {
      		    fprintf(stderr, "Can't open input file -> %s\n", INfile);
      		    bell; exit (-3);
    		}
	}
	else if ((out=fopen(tempfile, "w"))==NULL) {
		fprintf(stderr, "Can't open output file\n");
		bell; exit (-4);
	}
}

void style()
{
int n, a, b, j;
float lm, rm, tm, bm, x, pr, pb, os=0;
float Ck=0.03527778;	/* ~~~ mm/div ~~~ */
float getnew();
char s[100], cst[100]; 
void cleanup();

    Xw=XX*720; Yh=YY*720; pr=Xw*Ck; pb=Yh*Ck;
    if (landscape) {
	x=pr; pr=pb; pb=x;
    }
    charsize(pts);
    lm = LM/10.; rm = RM/10.; 
    tm = TM/10.; bm = BM/10.;

    if (!mute) do {
	if (fputnpage) fprintf(stderr,
"\tN: Page Numbering.  Current:   Yes.  Start at page %d\n", pgcount);
	else fprintf(stderr,
"\tN: Page Numbering.  Current:   No.\n");
	fprintf(stderr, 
"\tP: Print PS file?   Current:   %s.\n", fprntfile? "Yes" : "No");
	fprintf(stderr,
"\tS: Character Size.  Current: %7.2f mm (%4.1f pts)\n\
\tA: Character Space. Current: %6.1f (1=standard)\n\
\tI: Line Space.      Current: %6.1f (1=standard)\n\
\tL: Left Margin.     Current: %6.1f mm\n\
\tR: Right Margin.    Current: %6.1f mm\n\
\tT: Top Margin.      Current: %6.1f mm\n\
\tB: Bottom Margin.   Current: %6.1f mm\n\
\tH: English Font.    Current:   %s\n\
\tQ: Quit.\n\n", CSP*Ck, pts, Ca, Ci, lm, rm, tm, bm, EFname[nEF]);
	a = 10.*(pb-bm-tm + .3*Ck*CLP)/(CLP*Ck);
	b = 10.*(pr-rm-lm)/(CSP*Ck); 
	fprintf(stderr,
" There are about %d.%d lines in a page and %d.%d words in a line\n\n\
 To change, type one of the following:\n\n\tN, P, S, A, I, L, R, T, B, H, Q\n\n\
 or press RETURN key to continue\n", a/10, a%10, b/10, b%10); 
	gets(cst);
        if (cst[0] != '\0') switch (toupper(cst[0])) {
		case 'N':
			if (fputnpage) fprintf(stderr,
"\tN: Page Numbering.  Current:   Yes.  Start at page %d\n", pgcount);
			else fprintf(stderr,
"\tN: Page Numbering.  Current:   No.\n");
			fprintf(stderr, "(Y/N ?) If NO, type < N >;\n\
 If YES, enter your number to change OR press RETURN to continue;\n");
                        gets(s);  
                        if (toupper(s[0]) == 'N') fputnpage=0;
	                else {
				if (toupper(s[0])!='Y') sscanf(s,"%d", &a);
				if (bp && a>bp) {
				    fprintf(stderr, 
"Input greater than %d, the page to begin printing, OK?!\n", bp);
				    bell; gets(s);
				}
				else {pgcount=a; fputnpage=1;}
			}
			break;
		case 'P':
			fprintf(stderr,  
"\tPrint PS file ? Current:  %s?\n\n", fprntfile? "Yes.  [Yes]" : "No.  [No]");
			fprntfile=yes(fprntfile);
			if (fprntfile && strlen(prntcmd)<=2) {
				fprintf(stderr, 
"Print command invalid/not found, please enter new one:\n"); 
				bell; gets(s);
				sscanf(s, "%s", prntcmd);
				if (strlen(prntcmd)<=2) fprntfile=0;
			}
			break;
		case 'S':
   			fprintf(stderr,
"\tCharacter Size. Current: %7.2f mm (%4.1f pts)\n\
\t\t****** 1 pts = 3.556 mm ******\n", CSP*Ck, pts);
                        pts=getnew(pts,0);
			charsize(pts);
			break;
		case 'A':
			fprintf(stderr,
"Standard is 8%% of the size of a Chinese character\n\
\tA: Character Space. Current: %6.1f (1=standard)\n", Ca);
	Ca=getnew(Ca,2); charsize(pts); break;
		case 'I':
			fprintf(stderr,
"Standard is 50%% of the size of a Chinese character\n\
\tI: Line Space.      Current: %6.1f (1=standard)\n", Ci);
	Ci=getnew(Ci,2); charsize(pts); break;
		case 'L':
	fprintf(stderr, "\tLeft Margin.    Current: %6.1f mm\n\n", lm);
	lm=getnew(lm,1); break;
		case 'R':
	fprintf(stderr, "\tRight Margin.   Current: %6.1f mm\n\n", rm);
	rm=getnew (rm,1); break;
		case 'T':
	fprintf(stderr, "\tTop Margin.     Current: %6.1f mm\n\n", tm);
	tm=getnew (tm,1); break;
		case 'B':
	fprintf(stderr, "\tBottom Margin.  Current: %6.1f mm\n\n", bm);
	bm=getnew (bm,1); break;
		case 'H':
	fprintf(stderr, "\tH: English Font.    Current: %s\n\n", EFname[nEF]);
	for (j=0; j<10; j++) if (strlen(EFname[j]) > 1) 
		fprintf(stderr, "%4d:  %s\n", j, EFname[j]);
	fprintf(stderr, 
"0-9: Normal  10-19: Oblique/Italic  20-29: Bold  30-39: Bold & Oblique\n");
	if ((nEF=getnew(nEF+0.1, 3))%10 != 2)
	    if (!getdata(1)) {
		fprintf(stderr, 
"No data available for selected font, Courier used, OK?!\n");
		bell; gets(s); nEF=2; 
	    }                                      
		break; 
		case 'Q':
	cleanup(); fclose(out); remove(tempfile); exit(0); 
		default: break;
       }
    } while (cst[0] != '\0');

    charsize(pts);
    pts0 = ptspc = (pts+0.5);
    maxCLP = clptmp = CLP;
    LM = lm/Ck;           	      
    RM = (pr - rm)/Ck;
    TM = (tm +(os + CSP*Ck))/Ck; 
    BM = (pb - bm + (os + CLP*Ck))/Ck;
    RM = ((RM-LM)%CSP < CSP/2)? (RM-LM)/CSP*CSP+LM : (RM-LM)/CSP*CSP+CSP+LM;	
    BM = ((BM-TM)%CLP < CLP/2)? (BM-TM)/CLP*CLP+TM : (BM-TM)/CLP*CLP+CLP+TM;
    if (!mute) fprintf(stderr, 
" There are %d lines in a page and %d words in a line\n\n", 
	(BM - TM)/CLP, (RM - LM)/CSP); 
    RM -= LM; BM -= TM; Xa = LM; Ya = TM; LM=TM=0;
    cRM = RM; cBM = BM; cTM=cLM=0;
    if (column>1) {
	cRM = cLM + columnWidth();
	PCN=SCN=1;
    }
    if (nEF%10 ==2) for (j=0; j<95; j++) Wasc[j]=1;
    nEFs[nEF]++;
    if (!bp) bp=pgcount;
    if (ep && ep<bp) {
	ep=0; bell;
	fprintf(stderr, 
"Invalid page number to end printing, print to file end\n");
    }
    Prntpage = (bp==pgcount &&
	(!odd || (odd==1 && pgcount%2) || (odd>=2 && !(pgcount%2))))? 1:0;
}                       
   
columnWidth()
{
	int n;
	float x;
	x = (cgap)? (10.*cgap) : (2.*Cw*pts);
	n = (RM-LM-x*(column-1))/column;
	return (n/CSP)*CSP;
}

void charsize(x)
float x;
{
	CLP = x*(Cw*Cy - 1./25. + (1.0 - Cw/10. + 1./25.)*Ci*10.);
	CSP = x*(Cw*Cx - .4 + Ca*10./25);
}

float getnew(y, n) 
float y; int n;
{
	float x = -1.;
	char s[80];
	fprintf(stderr,
" Please enter your desired value, or press RETURN to continue\n");
	if (n==0)
fprintf(stderr, " ~~~~~~ ONLY VALUE IN --pts-- IS ACCEPTABLE ~~~~~~\n"); 
	else if (n==1)
fprintf(stderr, " ~~~~~~  inch OR mm  ~~~~~~\n");
	gets(s);  
	if (s[0]=='\0') return y;
	sscanf(s,"%f",&x);
	if (x<=5. && n==1) x *= 25.4;
		/* 5mm < Margin <= 127 mm (5 in) */
	if (n==0 && x<100. && x>=1.) return x;
	else if (n==1 && x<=130. && x>=5.) return x;
	else if (n==2 && x<=20. && x>=0.1) return x;
	else if (n==3 && x<40. && x>= -0.1) return x+0.1;
	else {
		fprintf(stderr,
"WARNING: input value out of range, ignored !\n\n");
		bell; return y;
	} 
}

void cleanup()
{
  	fclose(in);
	HBFclose(); 
}

void newline()
{
	void shade(), endpage();
	int x;
	if (fshade) shade();
	else endAC();
	if (column==1) {
		V += CLP; H=LM;
		if (V>= BM) {
			endpage(0); V=TM; 
		}
		maxCLP = clptmp = CLP;
	}
	else {
		V += lineclp[++pline]; H = cLM;
		if (V >= cBM) {
		    x = columnWidth();
		    if (++pcolumn <= column) {	
			V = cTM; 
			H=cLM=LM+(x+(RM-LM-x*column)/(column-1))*(pcolumn-1);
		    }
		    else if (V >= BM) {
			endpage(0);
			V=cTM=TM; H=Hs=cLM=LM; 
			PCN=SCN=1;		/* see isfs, PCN=2 */
			pline=1; sline=0;	/* force to search */
			pcolumn=1;
		    }
		    cRM = cLM + x;
		}
	}
	fnewline=1; Ha=0;
	if (fshade) ;
}                 

void endpage(endDoc)
int endDoc;
{
	char s[100], fn[100];
        void putnpagetime(), header(), trailer(), pagesetup(), FName();
	int pp;
	if (Prntpage) {
		if (!pgpd++) bell;
		fprintf(stderr, "*** Page %d has been done ***\n", pgcount); 
        	putnpagetime();
		fprintf(out, "EP\n");
	}
 	pgcount++;
	pp = (pause)? pause:1;
	Prntpage = (pgcount>=bp && (!ep || pgcount<=ep) &&
	    (!odd || (odd==1 && pgcount%2) || (odd>=2 && !(pgcount%2))))? 1:0;
	if (endDoc || (pause && !(pgpd%pp)) ) {
		trailer();
		if (ferror(out)) {
			fprintf(stderr, 
"WARNING: PS file %s write error, possibly out of memory.\n\
	 PS file might NOT be complete.\n\
Suggestion: delete PS file and run CNPRINT again, use the -p[number] option\n\
	 or select smaller number\n", tempfile);
			bell; exit(-5);
		}
		fclose(out);
		if (fprntfile) {
			sprintf(s, "%s %s", prntcmd, tempfile);
			system(s);
			fprintf(stderr,
"Job has been sent to printer\n\
Please press RETURN after print job is finished");
			bell; gets(s); 
			if (!keepPS) remove(tempfile);
 		}
		if (keepPS || !fprntfile) {
 			strcpy(fn, PSfile); 
			if (pause) {
				sprintf(s, "%d", filecount); FName(fn, s);
			}
			RE_name(tempfile, fn);
			fprintf(stderr, "PS File: %s\n", fn);
		}
		if (pause && !fprntfile) {
			fprintf(stderr,"Please press RETURN to continue"); 
			bell; gets(s);
		} 
		filecount++;
		if (!endDoc) {
			opnfile(OUT); header(); pgpd=0;
		}
	}
	else if (Prntpage) pagesetup();
}

void trailer()
{
	int j=0;
	fprintf(out, 
"%%%%Trailer\n%%%%Pages: %d\n", pgpd);
	while (j<40) if (nEFs[j++]>0) {
		fprintf(out,   
"%%%%DocumentNeededResources: font %s\n", EFname[j-1]); 
		break;
	    }
	while (j<40) if (nEFs[j++]>0) 
		fprintf(out, "%%%%+: font %s\n", EFname[j-1]); 
	fprintf(out, 
"%%%%DocumentSuppliedResources: procset CNset\n");
	if (nCN>0) for (j=1; j<=(1+(nCN-1)/256); j++)
		fprintf(out, "%%%%+: font CN%d%d\n", Nx, j); 
	fprintf(out, "%%%%EOF\n");
	if (EPS && pgpd>1) {
		bell;
		fprintf(stderr, 
"WARNING: PS file does NOT comform to EPSF format -> more than 1 page\n");
	}
}

void pagesetup()
{ 
	void PSctrl();
	fprintf(out,
"%%%%Page: %d %d\n%%%%BeginPageSetup\n/pagelevel save def\nBP\n",
		pgcount, pgpd+1);
	PSctrl();
	fprintf(out, "%%%%EndPageSetup\n");
}

void putnpagetime() 
{
	struct tm *time_str;
	int i=0; 
	long time_val;
	char s[80]; 
	endAC();
        if (!fputnpage) return;
	if (vertical) fprintf(out, "fa %d %d q gctr (%6d.) S grestore\n",
		Yh-(BM-3*CLP), RM+CLP, pgcount); 
	else fprintf(out, "fa %d %d Q (%6d.) S\n", 
		Yh-(BM+CLP), RM-300-3*CSP, pgcount); 
        if (!TIME || timestat==1) return;
	time(&time_val);
	time_str = localtime(&time_val);
	strftime(s, 48, "CNPRINT %a %d-%b-%y %H:%M:%S %Z", time_str);
	while ( (s[i]=toupper(s[i])) != '\0') ++i;
	if (vertical) fprintf(out, 
"/Courier 60 SF %d %d q gctr (%s) S grestore\n", Yh-(TM+1200), RM+CLP, s);
	else fprintf(out, 
"/Courier 60 SF %d %d Q (%s) S\n", Yh-(BM+CLP), LM, s);
}

void header()
{
	int j, n;
	float x;
	long time_val;
	void CNdict(), pagesetup();
	time(&time_val);
	fprintf(out, 
"%%!PS-Adobe-3.0 %s\n\
%%%%Title: GB %s PS %s\n\
%%%%Creator: %s CYD UW-Madison WI USA\n",
(EPS)? "EPSF-3.0": "", INfile, PSfile, Version);
	fprintf(out, "%%%%CreationDate: %s", ctime(&time_val));
	j=(Yh-(Ya+BM+2*CLP))/10; if (j<=0) j=0;
	fprintf(out, 
"%%%%BoundingBox: %d %d %d %d\n\
%%%%Pages: (atend)\n\
%%%%DocumentNeededResources: (atend)\n\
%%%%DocumentSuppliedResources: (atend)\n\
%%%%Orientation: %s\n\
%%%%EndComments\n", (Xa-CSP)/10, j, (Xa+RM+3*CSP/2)/10, (Yh-Ya+3*CLP/2)/10,
(landscape)? "Landscape":"Portrait");  
	fprintf(out, 
"%%%%BeginProlog\n\
%%%%BeginResource: procset CNset 1500 1200\n");
	fprintf(out, 
"/B {bind def} bind def\n\
/*SF { exch findfont exch dup type /arraytype eq {makefont} {scalefont}\n\
ifelse setfont} B	%% selectfont emulation\n\
/languagelevel where {pop languagelevel} {1} ifelse 2 lt {/SF /*SF load def}\n\
{/SF /selectfont load def} ifelse\n\
/EP {pagelevel restore showpage} B\n");	
	if (landscape) fprintf(out, 
"/BP {.1 .1 scale 90 rotate %d -%d translate} B\n", Xa, Ya+Yh); 
	else fprintf(out,
"/BP {.1 .1 scale %d -%d translate} B\n", Xa, Ya);
	fprintf(out, 
"/S /show load def\n\
/Q {exch moveto} B\n\
/q {p add Q} B\n\
/gct {gsave currentpoint translate} B\n\
/gctr {gct 90 rotate} B\n");
	fprintf(out,
"/T {gct LL} B\n\
/t {gctr LL} B\n\
/W {show p 0 rmoveto} B\n\
/w {gctr show grestore p 0 rmoveto} B\n\
/M {imagemask grestore p 0 rmoveto} B\n\
/m /imagemask load def\n\
/l {scale true} B\n");
	x = mx*25./24.;
	fprintf(out, 
"/a {%d %d true [1 0 0 -1 0 %d]} B\n\
/FMatrix [%7.5f 0 0 %7.5f 0 0] def\n\
/FBBox [0 0 %6.3f %6.3f] def\n", mx, my, mx, 1./x, 1./x, x, x); 
	fprintf(out,
"/Shade {gsave moveto lineto lineto lineto closepath setgray fill grestore\n\
setgray} B\n");
	if (nCN>0) {
		fprintf(out, "/code 256 array def  code 0 [");
		for (j=0; j<256; j++) 
			fprintf(out, (j%20==0)? "\n/%02x " : "/%02x ", j);
		fprintf(out, "] putinterval\n");
	}
	fprintf(out, "%%%%EndResource\n%%%%EndProlog\n%%%%BeginSetup\n");
	if (copies>1 && !EPS) fprintf(out, "/#copies %d def\n", copies);
	n=0;
	while (nCN > 256*n) CNdict(++n); 
	if (nCN>0 && !pause) free(fdict);
	fprintf(out, "%%%%EndSetup\n");
	if (Prntpage) pagesetup();
}

void CNdict(n)  /* Fonts for frequently used characters with nCN entries */
int n;
{
    int i, j, k, m, sq16=256;
    int ch;
    int HBFgetBitmap();
    void putBitmap();
        k = (nCN>=n*256)? 256:(nCN%256);
	j = (mx*my/24./24.)*(385.*k/256.); k = j*(375./385.);
	fprintf(out, 
"%%%%BeginResource: font /CN%d%d %d00 %d00\n\
8 dict begin\n\
/FontType 3 def\n\
/FontMatrix FMatrix def\n\
/FontBBox FBBox def\n", mx, n, j+1, k+1); 
	fprintf(out, 
"/BuildGlyph {0 0 0 0 %d %d setcachedevice	%% 0 x/y displacement\n\
exch /CharProcs%d get exch 2 copy known not {pop /.notdef} if get exec} B\n\
/BuildChar {1 index /Encoding get exch get 1 index /BuildGlyph get exec} B\n\
%% level 1 compatibility\n", mx, my, n); 
	fprintf(out, 
"/Encoding 256 array def\n\
Encoding 0 code putinterval\n");
	if (nCN < n*256) fprintf(out,
"%d 1 255 {Encoding exch /.notdef put} for\n", nCN%256);
	fprintf(out, 
"/CharProcs%d %d dict def\n\
CharProcs%d begin\n/.notdef {} def\n", n, (nCN>=n*256)? 257:(nCN%256+1), n);

	k = (nCN < n*256)? nCN : n*256;
	for (i=(n-1)*256; i<k; i++) {
	    m=fdict[i];
	    if (big5) {
		ch=m%157;  ch += ((ch<63)? 0x40:(0xA1-63));
		ch += (m/157+0xA1)*sq16;
	    }
	    else ch = (m/94 + 0xA1)*sq16 + m%94 + 0xA1;
	    HBFgetBitmap(ch);   
	    fprintf(out, "/%02x {a{<", i%256);
	    putBitmap(array);
	    fprintf(out, ">}m}B\n");
	    ptstring[m] = array;
        }
	fprintf(out, "end currentdict end\n/CN%d%d exch definefont pop\n\
%%%%EndResource\n", mx, n);
}

void putBitmap(a)
unsigned char *a;
{
	int j;
	for (j=0; j<CHsize; ++j) 
		fprintf(out, (!((j+4)%40))? "\n%02x" : "%02x", a[j]);
}

void PSctrl()
{
	float z, ns;
	int  j, nsx, nsy, nx, ny, nty;
	char FontStl;

	for (j=strlen(HBFname) - 3; j>=0 ; j--)
  	    if (isdigit(HBFname[j+1]) && isdigit(HBFname[j+2]))
		FontStl=HBFname[j];
	if (ptspc <= 0 || ptspc >= 100) ptspc=pts0;
	z = (ptspc==pts0)? pts : ptspc;
	charsize(z);
	ns = z*Cw*10*24./25./10.;  
	nsy = ns*Cy; nsx = (FontStl=='f')? ns*.95*Cx : ns*Cx;
	nx = (0.8338*CSP)*2.*Casc*10.;
	ny = z*0.75*10.*Cy; nty = ny/9.;

	endAC(); inCH=100;
	if (!Prntpage) return;
	fprintf(out, "/p %d def\n\
/LL {%d %d %d %d l [%d 0 0 -%d 0 %d]} B\n", CSP, mx, my, nsx, nsy, mx, my, mx);
	if (nCN>0) 
	    for (j=1; j<=(nCN+255)/256; j++) {
		if (nsx!=nsy) fprintf(out, 
"/z%d {/CN%d%d [%d 0 0 %d 0 0] SF} B\n", j, mx, j, nsx, nsy);
		else fprintf(out, 
"/z%d {/CN%d%d %d SF} B\n", j, mx, j, nsx);
	    }
	fprintf(out, 
"/fa {/%s [%d.%d 0 0 %d 0 %d] SF} B\n", EFname[nEF], nx/10, nx%10, ny, nty);
	if (gray>0.01) fprintf(out, "%3.1f setgray\n", gray);
}

int isrlasc(c)
int c;
{              /* L=left; R=right; NT=none */
	if (!adjust) return NT;
	switch (c) {
		case 40 : case 60 : case 91 : case 123 :
			return L;
		case 33 : case 41 : case 44 : case 46 : case 58 : 
		case 59 : case 62 : case 63 : case 93 : case 125 :
			return R;
		default: return NT;
	}
}

int isrlch(c1, c2)
unsigned char c1, c2;
{		/* L=left; R=right; NT=none */ 
	if (big5) return NT;
	switch (c1) {
	    case 0xA1:
		if (c2>=0xAE && c2<=0xBF) c2%=2;
		switch (c2) {
			case 0: return L; 
			case 1: case 0xA2 : case 0xA3 : case 0xC3 : 
			case 0xE3 : case 0xE4 : case 0xE5 : 
				return R; 
	      		default: return NT; 
		}
	    case 0xA3:
		switch (c2) {
			case 0xA8 : case 0xDB : case 0xFB : case 0xE0 :
				return L; 
			case 0xA1 : case 0xA7 : case 0xA9 : case 0xAC : 
			case 0xAE : case 0xBA : case 0xBB : case 0xBF : 
			case 0xDD : case 0xDF : case 0xFD : 
				return R; 
	      		default: return NT; 
		}
      	    default: return NT; 
	}
}

unsigned char tovhb5(c)
unsigned char c;
{ /* convert vertical big5 punctuations to horizontal ones or vice versa */
	int j;
	if (c<0x5D || c>0x7D) return c;
	j = (c-0x5D)%4;
	if (j<2 && vertical) return (c+2);
	if (j>=2 && !vertical) return (c-2);
        return c;
}

int vchange(c1, c2)
unsigned char *c1, *c2;
{
	if (big5 && *c1==0xA1) 
	    switch (*c2) {	/* default c1=0xA1 */
		case 0x43: *c1 = 0xA2; *c2 = 0x58; break;
		case 0x4D: *c2 = 0xA6; break;
		case 0x4E: *c2 = 0xAB; break;
		case 0xA7: *c2 = 0x79; break;
		case 0xA5: *c2 = 0x75; break;
		case 0xA6: *c2 = 0x76; break;
		case 0xA8: *c2 = 0x7A; break;
		default: break;
	    }
	else if (*c1==0xA1 || *c1==0xA3) 
	    switch (*c2) {	/* GB: default c1=0xA1 */
		case 0xA2: *c2 = 0xE4; break;
		case 0xA3: *c2 = 0xE3; break;
      		case 0xAE: *c2 = 0xB8; break;
		case 0xAF: *c2 = 0xB9; break;
		case 0xB0: *c2 = 0xBA; break;
      		case 0xB1: *c2 = 0xBB; break;
		case 0xAC: *c1 = 0xA1; *c2 = 0xAF; break;  /* A3AC */
      		default: break;
	    }
	return 1;
}

int rtch(c1, c2)
unsigned char c1, c2;
{		/* R=rotate */ 
	if (big5) return R;
	switch (c1) {
	    case 0xA1:
		switch (c2) {
 			case 0xA2 : case 0xA3 : case 0xA9 : return R; 
   	      		default: return NT; 
   		}
	    case 0xA3:
		switch (c2) {
			case 0xA1 : case 0xBA : return R; 
   	      		default: return NT; 
   		}
	    case 0xA6: case 0xA7: case 0xA9: return NT;
	    case 0xA8: if (c2==0xE7) return NT;
			else return (c2 <= 0xC4)? NT : R;
      	    default: return R; 
	}
}

int putASC(c)
int c;
{
	int k, ASP, newl=0;
	float x;
	int isrlasc(), rl;

	if (c==13 || c==26) return 0; 
	cnsp=0; frl=NT;
	if (c==EOL) {
		newline(); return 0;
	}
	if (c=='\t') {
		endAC(); 
		x = (H-cLM)*2.0/CSP; 
		k = x + 8.5;  k = (k/8)*8;
		H += ((k-x)*CSP/2.0);  
		return 0;
	}
	k = (c>=' ' && c<=126 )? (c-' ') : 0;
	ASP = CSP*Casc*Wasc[k]*10.;
	Ha += (ASP%10); ASP /= 10;
	if (c!=' ') {
		if ((rl=isrlasc(c))==L) if (H > cRM-ASP*3/2) newl=1;
		if (newl || (H > cRM-ASP/2 && rl != R) ) {
			newline(); return 1;
		}
		if (inCH) {
			if (Prntpage) fprintf(out,"%d %d Q fa (", Yh-V, H);
			inCH=OUT;
		}
		if (Prntpage) fprintf(out, (isprint(c)) ? 
		    ( (c=='(' || c==')' || c==92)? "\\%c":"%c") : "\\%03o", c);
	}
	else {
		if (Prntpage) if (!inCH) fprintf(out, " "); 
		else newpos = 1;
	}
	H += ASP;
	if (Ha>=10) { H++; Ha -= 10; }
	return 0; 
}

int Addr(c1, c2)
int c1, c2;
{
	int a;
	a = (!big5)? ((c1-0xA1)*94+c2-0xA1) :
		( (c1-0xA1)*157 + ( (c2>=0xA1)? (63+c2-0xA1):(c2-0x40) ) );
	return (a>nchar)? nchar : a;
}

int putCH(c1, c2)
unsigned char c1, c2;
{
	int j, addr, newl=0;
	int ch;
	void putBitmap();
	int isrlch(), rtch(), vchange(), rl, rt, HBFgetBitmap(), Addr();
	unsigned char tovhb5();

	rl=NT;
	if (big5>1) if (c1==0xA1) c2=tovhb5(c2);
	if (vertical) vchange(&c1, &c2);
	if (c1>=0xA4) cnsp=0;
	else if (adjust) { 
	    cnsp++;     
	    if ( (rl=isrlch(c1, c2))==NT ) cnsp=0;
	    else if (rl==L) {
		if (H > cRM-2*CSP) {
			cnsp=1; newpos=1; 
			if (H < cRM-CSP*5/4) {
				H -= ((frl==R)? CSP: CSP/2); 
				if (frl==R) frl=NT; 
				if (H < cRM-2*CSP) H=cRM-2*CSP;
			}
			else if (H < cRM-CSP*3/4 && frl==R) {
				H -= CSP; 
				if (H < cRM-2*CSP) H=cRM-2*CSP;
			}
			else newl=1;
		}
	    }
	    else if (rl==R && frl==L) cnsp=1;
	}  
	if (vertical) {
		rt = (c1<0xB0)? rtch(c1, c2) : R;
		if (rt==R) Rotate=1;
	}
	else rt=NT;
	ch=c1*256+c2;
	if (ch != cspace) { 
	    if (adjust) {
		if (frl==R && H > cRM-CSP && H <=cRM-CSP/4 && !cnsp) {
			newpos=1;
			H = (H > cRM-CSP/2)? (H-CSP/2):(cRM-CSP);
		}
		else if (newl || (H > cRM-CSP*2/3 && rl!=R) ) {
			newline(); return 2;
		}
		if (cnsp >= 2) {      /* take care of 'half' CN */
			if (linedif[pline] > CSP/2) 
				linedif[pline] -= (CSP/2); 
			else if (linedif[pline] > 0) {
				H -= (CSP/2-linedif[pline]);
				linedif[pline]=0; newpos=1;
			}
			else {
				H -= (CSP/2); newpos=1;
			}
		}
	    }
	    else if (H > cRM - CSP*2/3) {
		newline(); return 2;
	    }
	    addr=Addr(c1, c2);
	    if (Prntpage) {
		if ((defFont && ptstring[addr]==NULL) || !defFont) {
		    HBFgetBitmap(ch);   
		    if (defFont) {
		         /* allocate memory for bitmap array */
ptstring[addr] = (unsigned char *) calloc(CHsize+1, sizeof(unsigned char));
		    	if (ptstring[addr]!=NULL) for (j=0; j<CHsize; ++j)  
				ptstring[addr][j]=array[j];
			else ptstring[addr=0] = array;
		    }
		    else ptstring[addr=0] = array;
		}
		if (!inCH) endAC(); 
		if (newpos || (rt==NT && Rotate) ) {
		    if (newpos==1 || rt==R || (rt==NT && Rotate) ) 
			fprintf(out, (vertical && rt==R)? 
				"%d %d q\n":"%d %d Q\n", Yh-V, H);   
		    newpos=0; 
		    if (vertical && rt==NT) {Rotate=0; newpos=2;}
		}
		if (defFont && fstring[addr]<0) {
		    j = fstring[addr] + 5000;
		    if (inCH != j/256 +1) 
			fprintf(out, "z%d ", (inCH = j/256 +1));
		    j%=256;
		    fprintf(out, (j>'~' || j<' ' || j=='(' || j==')' || j==92)? 
			"<%02x>%s\n" : "(%c)%s\n", j, ((rt==NT)? "W":"w"));
		}
		else {
		    fprintf(out, (rt==NT)? "T {<" : "t {<");
		    putBitmap(ptstring[addr]);
		    fprintf(out, ">}M\n");
		}
	    }
	    if (fstring[addr]>0) if (--fstring[addr]==100) {
		if (ptstring[addr]!=NULL) free(ptstring[addr]);
		ptstring[addr]=NULL;
	    }
	}
	else if (!inCH && adjust) {
		putASC(' '); return 0;
	} 
	else newpos=1;
	H+=CSP;
	frl=rl;
	return 0;
}

void usage()
{
	bell; 
	fprintf(stderr, "%s\n\n", Version);
	fprintf(stderr, 
"USAGE: cnprint [-h] [-wvlc2x3...f font] filename [PS/GB name]\n\n\
	-h:	This message. See CNPRINT.HELP for more.\n\
	-5(-55): Input is a BIG-5 file.\n\
	-v(-vv): Vertical printing mode.\n\
	-c3:	Divide one page into 3 Columns.\n\
	-w:	Convert to PS Without printing.\n\
	-l:	Paper orientation Landscape.\n\
	-f (j16, f24, k24, or full HBF name): Select font.\n");
	fprintf(stderr, 
"	-x2:	Character width/height 1.2 (-y3: h/w 1.3).\n\
	-e56:	ASCII width = 0.56 CH width (-e: EPS output).\n\
	-p4:	Print/convert 4 pages at a time.\n\
	-z:	Hz->GB conversion only (-zz: GB->Hz).\n\
	-m:	Do NOT display menu (-m5, print 5 copies).\n\
	-t:	Do NOT print time and CNPRINT logo.\n\
	-d:	NO special treatment of punctuation marks.\n\
	-b2e14:	Print pages 2-14 (-o or -oo: odd or even-numbered pages).\n\
	-q=laserps : System PS print command = 'laserps'.\n");
}

int isfs(s, pr)
unsigned char *s;
int pr;
{
	int j, k, HBFopen(), issfs();
	unsigned char c1, c2;
	void shade(), PSctrl();
	
	c1=s[1]; c2=s[2];
        if (s[3]!=']') {
		if (c1!='M' || c2!='V' || s[9]!=']') return 0;
		if(suppress) return (suppress>=2)? 0 : 10; 
		for (j=3; j<=8; j++) if (!isdigit(s[j])) return 0;
		j = 100*(s[3]-'0') + 10*(s[4]-'0') + (s[5]-'0');
		k = 100*(s[6]-'0') + 10*(s[7]-'0') + (s[8]-'0');
		if (pr) { 
			endAC(); 
			if (j!=1) H = j*10; if (k!=1) V = k*10;
		}
		else if (j!=1) Hs = j*10;
		return 10;
	}
	if(suppress) return (suppress>=2)? 0 : 4; 
    	switch(c1) {
/* C: column number */
	    case 'C':      
		if (!pr) return issfs(c1, c2);
		if (!isdigit(c2)) return 0;
		k = (c2=='0')? 1 : (c2-'0');
		PCN++; 
		if (PCN==1) {
			if (column==1 && k==1) PCN=SCN=0;
			return 4;
		}
		else {
		    column = k;      /* set search mode for next one */ 
		    fnewline = 1;
		    sline = 0;  pline = 1;
		    V = cBM; cBM = BM; 
		    Hs = cLM = H = LM;
		    if (column > 1) {
			SCN = 1; PCN = 1; cTM = V;   
			cRM = LM + columnWidth();
		    }
		    else { 
			SCN = 0; PCN = 0; 
			cRM = RM; cTM = TM;
		    }
		}
		return 4;
/* ASC font */
	    case 'h': case 'H': case 'q': case 'Q':
		if (!isdigit(c2)) return 0;
		k=nEF;
		nEF=c2-'0';
		if (isupper(c1)) nEF += 20;
		if (c1=='q') nEF += 10;
		if (strlen(EFname[nEF]) > 1 && (nEF%10)!=2) 
		    if (!getdata(1)) {
			fprintf(stderr, 
"No data available for selected font, Courier used\n");
			bell; nEF=2;
 		    }
		nEFs[nEF]++;
		if ((nEF%10)==2) for (j=0; j<95; j++) Wasc[j]=1;
		if (pr && nEF!=k) PSctrl();
		return 4;
/* CH font */
	    case 'f': case 'F': case 'v': case 'V':     
                if (!isalpha(c2)) return 0;
		if (!pr) return 4;
		k = (isupper(c1))? 1:0; 
		k += (isupper(c2))? 1:0;
		switch(k) {
			case 0: j = (toupper(c1)=='F')? 16:40; break; 
			case 1: j = (toupper(c1)=='F')? 24:56; break; 
			case 2: j = (toupper(c1)=='F')? 48:64; break; 
			default: break; 
		}
		HBFclose();
		sprintf(HBFname, "%scn%c%d.hbf", root, tolower(c2), j); 
		if (!HBFopen()) {
			strcpy(HBFname, defHBFname); 
			fprintf(stderr, "Default font used\n\n");
			HBFopen();
		}
		defFont= strcmp(defHBFname, HBFname)? 0:1;
		PSctrl();
		return 4;
/* shading */
	    case 'S':
		if (!isdigit(c2)) return 0;
		if (!pr) return 4;
		if (fshade) shade();
		fshade=(c2=='0')? 0:1;
		return 4;
/* gray */
	    case 'G':
		if (!isdigit(c2)) return 0;
		if (!pr) return 4;
		endAC();
		if (Prntpage) 
			fprintf(out, "%3.1f setgray\n", gray=(c2-'0')/10.);
		return 4;
/* X, Y expansion */
	    case 'X': case 'Y':
		if (!isdigit(c2)) return 0;
		if (c1=='X') { Cx=1.+(c2-'0')/10.; Cy=1;}
		else { Cy=1.+(c2-'0')/10.; Cx=1;}
		if (Cy+(Cx-1.)/2. > Ci) Ci = Cy+(Cx-1.)/2.;
		if (!pr) return issfs('0'+ptspc/10, '0'+ptspc%10);
		PSctrl();
		return 4;
/* ASC width, line and char space */
    	    case 'E': 
		if (!isdigit(c2)) return 0;
		Casc = (c2=='0')? Casc : (c2-'0')/10.;
		if (!pr) return issfs('0'+ptspc/10, '0'+ptspc%10);
		PSctrl();
		return 4;		
	    case 'I': case 'A': 
		if (!isxdigit(c2)) return 0;
		if (c1=='I') Ci= (c2=='0')? 
			Ci : (isdigit(c2)? (c2-'0')/10. : (c2-'a'+1) );
		else Ca= (c2=='0')? Ca : (isdigit(c2)? (c2-'0') : c2-'a'+10);
		if (!pr) return issfs('0'+ptspc/10, '0'+ptspc%10);
		PSctrl();
		return 4;		
    	    case 'P': 
		if (!isdigit(c2)) return 0;
		if (!pr) return 4;
		j = c2-'0';
		if (!j || (BM-V)/CLP<=j) {
			V=BM; newline();
		}
		return 4;
    	    default: 
		if (!isdigit(c1) || !isdigit(c2)) return 0;
/* char size */
		if (!pr) return issfs(c1, c2);
		ptspc = (c1-'0')*10 + (c2-'0');
	        PSctrl();
		return 4;
	}
}

int issfs(c1, c2)
unsigned char c1, c2;
{
	int k, span();
	float y;
	switch(c1) {
/* C: column number */
	    case 'C':      
		if (!isdigit(c2)) return 0;
		k = (c2=='0')? 1:(c2-'0');
		SCN++;
		if (SCN==1) {
			column = k;
			if (column==1) PCN=SCN = 0; 
			cTM = V; 
			cRM = LM + columnWidth();
		}
		else {
			cBM=span(1);
			cLM = H = LM;
			pcolumn = 1;
		}
		return 4;
	    default: 
		if (!isdigit(c1) || !isdigit(c2)) return 0;
/* char size */
		k = (c1-'0')*10 + (c2-'0');
		if (k >= 100 || k <=0) { y=pts; ptspc=pts0;}
		else y=ptspc=k;   /* ptspc for print has been saved */
		charsize(y); 
		  /* size ctrl at the beginning of a line, take it */
		if (column==1) {
			if (Hs==LM || CLP > 1.2*clptmp) {
				V += (CLP - maxCLP);
				maxCLP = CLP;
			}
		}
		else if (Hs==LM || CLP > 1.2*clptmp) {
			if (sline==0) V += (CLP-lineclp[sline+1]);
			lineclp[sline+1] = CLP;
		}
		return 4;
	}
}
  
void shade()
{
	endAC(); ;
}

void endAC()
{
	if (!inCH) {if (Prntpage) fprintf(out,") S\n"); inCH=100;}
	newpos=1; 
}	

int scanASC(c)
int c;
{
	int  k, ASP, newl=0, isrlasc(), rl;
	float x;

	if (c==13 || c==26) return 0; 
	scnsp=0; sfrl=NT;
	if (c==EOL) {
		snewline(1); return 0;
	}
	if (c=='\t') {
		x = (Hs-LM)*2.0/CSP; 
		k = x + 8.5;  k = (k/8)*8;
		Hs += ((k-x)*CSP/2.0);  
		return 0;
	} 
	k = (c>=' ' && c<=126 )? (c-' ') : 0;
	ASP = CSP*Casc*Wasc[k]*10.;
	Ha += (ASP%10); ASP /= 10;
	if (c!=' ') {
		if ((rl=isrlasc(c))==L) if (Hs > cRM - ASP*3/2) newl=1;
		if (newl || (Hs > cRM-ASP/2 && rl != R) ) {
			snewline(0);  return 1;
		}
		sinCH=OUT;
	}	
	Hs += ASP;
	if (Ha>=10) { Hs++; Ha -= 10; }
	return 0;  
}

int scanCH(c1, c2)
unsigned char c1, c2;
{
	int  newl=0, isrlch(), vchange(), rl=NT;
	unsigned char tovhb5();

	if (big5>1) if (c1==0xA1) c2=tovhb5(c2);
	if (vertical) vchange(&c1, &c2);
	if (c1>=0xA4) scnsp=0;
	else if (adjust) { 
	    scnsp++;     
	    if ( (rl=isrlch(c1, c2))==NT) scnsp=0;
	    else if (rl==L) {
		if (Hs > cRM-2*CSP) {
			scnsp=1;
			if (Hs < cRM-CSP*5/4) {
				Hs -= ((sfrl==R)? CSP: CSP/2); 
				if (sfrl==R) sfrl=NT;
				if (Hs < cRM-2*CSP) Hs=cRM-2*CSP;
			}
			else if (Hs < cRM-CSP*3/4 && sfrl==R) {
				Hs -= CSP;
				if (Hs < cRM-2*CSP) Hs=cRM-2*CSP;
			}
			else newl=1;
		}
	    }
	    else if (rl==R && sfrl==L) scnsp=1;
	}  
	if (c1!=0xA1 || c2!=cspace%256) { 
	    if (adjust) {
		if (sfrl==R && Hs > cRM-CSP && Hs <=cRM-CSP/4 && !scnsp)
			Hs = (Hs > cRM-CSP/2)? (Hs-CSP/2):(cRM-CSP);
		else if (newl || (Hs > cRM-CSP*2/3 && rl != R) ) {
			snewline(0);  return 2;
		}
		if (scnsp >= 2) Hs -= (CSP/2);
	    }
	    else if (Hs > cRM - CSP*2/3) {
		snewline(0);  return 2;
	    }
	    sinCH=100;
	}
	else if (adjust && !sinCH) {
		scanASC(' '); return 0;
	}
	Hs+=CSP;
	sfrl=rl;
	return 0;
}

void snewline(ret)
int ret;
{
	fsnewl=1; Ha=0; sinCH=100; 
	lineclp[1+(++sline)]=clptmp=CLP;
	linedif[sline]=(Hs<cRM && !ret)? (cRM-Hs):0;
	Hs=LM; 
}

void HZGBconv(z)
int z;
{
	void hz2gb(), gb2hz(), FName();
	if (z && hztogb<=2) fprintf(stderr, "%s\n\n", Version);
	if (hztogb==1) hz2gb();
	else if (hztogb==2) gb2hz();
	fclose(in);
	if (ferror(out)) {
		fprintf(stderr, "%s version write error: %s\n", 
			(hztogb==1)? GB : ((hztogb==2)? HZ:"NEW"), tempfile);
		bell; exit(-5);
	}
	fclose(out);   
	if (z) {
	    if (*PSfile==0) {
		strcpy(PSfile, INfile);
		FName(PSfile, (hztogb==1)? GB : ((hztogb==2)? HZ:"NEW"));
	    }
	    RE_name(tempfile, PSfile);
	    fprintf(stderr, "Output File: %s\n", PSfile);
	}
}

void hz2gb() 
{
	int state, c1, c2;
	state = OUT;
	fprintf(stderr, "Hz --> GB ...\n");
	while ( (c1=fgetc(in)) != EOF) {
		if (c1=='~') {
      			if ( (c2=fgetc(in)) == '{') state = IN;
			else if (c2 == '}') state = OUT;
			else if (c2 == '~') fprintf(out, "~");
			else if (c2 != EOL) fprintf (out, "%c%c", 
				c1+(state==IN?128:0), c2+(state==IN?128:0));
		}
		else {
		    if (state == IN) {
			c2 = fgetc(in);
			fprintf (out,"%c%c", c1+128, c2+128);
		    } 
		    else fprintf (out, "%c", c1);
		}
	}
}

void gb2hz() 
{
	int state, c1, c2, k=0, nGB=0;
	state = OUT;
	fprintf(stderr, "GB --> Hz ...\n");
	while ((c1=fgetc(in))!=EOF) {
/* GB1 */   if (c1>=0xA1) {
		if ((c2=fgetc(in))==EOF) break; 
/* GB2 */	else if (c2>=0xA1) {
		    nGB++;
		    if (state==OUT) {
			if (k>=72) { fprintf(out, "~\n"); k=0; }
			fprintf(out, "~{"); state=IN; k+=2;
		    }
		    else if (k>=74) { fprintf(out, "~}~\n~{"); k=2; }
		    fprintf(out, "%c%c", c1-128, c2-128);
		    k+=2;
		}
		else {
/* keep bad code as it is */ 
		    fprintf(stderr, "Probably bad code: %02X%02X\n", c1, c2);
		    if (state==IN) {
			fprintf(out, "~}"); state=OUT; k+=2;
		    }
		    if (k>=76 && c1!=EOL && c2!=EOL) 
			{ fprintf(out, "~\n"); k=0; }
		    fprintf(out, "%c%c", c1, c2);
		    if (c1==EOL) k=1;
		    else if (c2==EOL) k=0;
		    else k+=2;
		}
	    }
	    else {
/* ASCII */	if (c1>=0x80) fprintf(stderr, "Probably bad code: %02X\n",c1);
		if (state==IN) {
			fprintf(out, "~}"); state=OUT; k+=2;
		}
		if (k>=77 && c1!=EOL) { fprintf(out, "~\n"); k=0; }
		fprintf(out, "%c", c1);
		if (c1==EOL) k=0;
		else k++;
	    }
	}
	if (state==IN) fprintf(out, "~}");
	if (!nGB) fprintf(stderr, "Input may not be a GB file\n");
}

int ishz(c)
int c;
{
	return (c=='{' || c=='}')? 1:0;
}

int span(m)
int m;
{
	int x, y, n, j, k=1;
	if (m==0) {
		x = BM-V+lineclp[0]; y=0;
		for (j=1; j<=sline; j++) {
			y += lineclp[j];
			if (y >= x) {
				y=0; j--; k++;
			}
		}
		return (k>column)? 1:0;
	}    /* end of document */
	else if (m==10 && AdjAtEndDoc) return BM;
	else {
		n=1; x=lineclp[0];
 		do {
			x += lineclp[n++];
			y=0; k=1;
			for (j=1; j<=sline; j++) {
				y += lineclp[j];
				if (y >= x) {
					y=0; j--; k++;
				}
			}
			if (k<=column && y<x) return 
				((x-lineclp[0]+cTM)>BM)? BM :(x-lineclp[0]+cTM);
		} while (k>column);
	}
}

void prescan()
{
    int	i, k, m, n, N, c1, c2, Hz=0, b5=0, ishz(), Addr();
    void HZGBconv(), FName();

    for (i=0; i<nchar; i++) fstring[i]=0;
    fprintf(stderr, "Scanning document ...\n");
    while ((c1=fgetc(in))!=EOF) {
	if (c1>=0xA1) {
		if ((c2=fgetc(in))==EOF) break; 
		else if (c1==0xa3 && !big5 && alnumadjust && isalnum(c2-128)) 
			continue;
		else if (c2>=cspace%256) fstring[Addr(c1, c2)]++;
		else if (c2=='~') if ((c1=fgetc(in))!=EOF) Hz += ishz(c1);
		if (c2<=0x7E) b5=1;
	}
	else if (c1=='~') {
		if ((c2=fgetc(in))!=EOF) Hz += ishz(c2);
	}
	else if (vgb) if (isvgb(c1)) fstring[2*94+c1-32]++;
    }
    fclose(in); opnfile(IN); 
    if (!big5 && b5) {
	fprintf(stderr, 
"Input file is in Big-5 format, is that right (Y/N)?\n");
	big5 = yes(2)? 100 : 0;
	if (big5) {HBFclose(); return;}
    }
    if (*PSfile==0) {
	strcpy(PSfile, INfile);
	FName(PSfile, PS);
    }
    if (Hz && !hztogb && !big5) {
	if (!Hzfile) fprintf(stderr, 
"Input file is in Hz format, is that right (Y/N)?\n");
	hztogb=(Hzfile)? 1 : ((yes(2))? 1 : 0);
	if (hztogb) {
		HZGBconv(0);
		FName(INfile, GB);
		RE_name(tempfile, INfile);
		opnfile(IN); opnfile(OUT);
		return; 
	}
	else Hz=0;
    }
    if (!Hz || hztogb || big5) {
	fstring[0]=0; N=m=n=0;
	for (i=0; i<nchar; i++) if (fstring[i]) {
		m += fstring[i]; N++;
		if (fstring[i]==1) n++;
	    }
	fprintf(stderr, 
"There are %d different words and total %d words in this document\n", N, m);
	if (nCN>N-n) nCN=N-n;
	m=N; n=0;
	if (N>0) {
	    fdict = (int *) calloc(N, sizeof(int));
	    if (fdict==NULL) { Outofmemory; exit(2); }
	    while (++n) {
		if (m<=0) break;
		for (i=1; i<nchar; i++) if (fstring[i]>0 && fstring[i]<=n) {
			fdict[--m]=i; fstring[i] -= 10000;  
			if (m==0) break;
		}
	    }
	    if (nCN>0) for (m=0; m<nCN; m++) fstring[fdict[m]] = m-5000;
	    if (nCN<N) for (m=nCN; m<N; m++) fstring[fdict[m]] += 10100;
	}
    }
}

int yes(n)
int n;
{
	char s[50];
	do {
		if (n>1) bell; gets(s);
		if ((toupper(s[0]))=='Y') return 1;
		else if ((toupper(s[0]))=='N') return 0;
		else if (n<=1) return n;
		else s[0]='\0';
		fprintf(stderr, "(Y/N) ?\n");
	} while (s[0]=='\0');
}


main (argc, argv)
int	argc;
char	*argv[];
{
    int	k, j, jmax, c, endfile=0;
    void init(), style(), HZGBconv(), prescan();
    void header(), endpage(), cleanup();
    unsigned char buf[BUFSIZE], *s, *p, *doAC();
    float Cis, Cas, Cascs, Cxs, Cys, ps;
    int nEFs, CSPs, CLPs;

    init(argc, argv);
    if (hztogb==3) { 
	mute++;
	fprintf(stderr, "Filter Out Functional Sequences ...\n");
    }	
    else if (hztogb) { HZGBconv(1); exit(0); }
    style(); 
    if (!hztogb) {
    	prescan();
	    if (hztogb==1) prescan();
	    if (big5==100) { 
		big5=1; adjust=0; init(999, argv); prescan();
	    }
	fprintf(stderr, "%s --> PS ...\n", (big5)? "BIG-5" : "GB");
	header();
    }
    V=TM; H=LM;

    buf[0]=getc(in); buf[1]='\0'; p = &buf[0];
    while (p[0]!='\0') {	
		/* reorganize buf */
	if (!endfile && strlen(p) < BUFSIZE-2048) {
	    j=0;
	    if (p != &buf[0]) while (buf[j++] = *p++) ;
	    jmax=strlen(buf); j=BUFSIZE-jmax-2;
	    while (--j>0 && (c=getc(in))!=EOF) if (c!='\0') buf[jmax++]=c;
	    buf[jmax]='\0'; 
	    if (c==EOF) { 
		endfile=1; 
		if (hztogb==1) remove(INfile);
	    }
	    p = &buf[0];
	}
	s=p; Hs = LM;
/* save status variables that will be used and changed by search */
	Cis=Ci; Cas=Ca; Cascs=Casc; Cxs=Cx; Cys=Cy; ps=ptspc; nEFs=nEF;
	CSPs = CSP; CLPs = CLP; 
	sline=fsnewl=0;
	lineclp[0]=lineclp[1]=clptmp=CLP;
/* SEARCH */
	for (;;) {
	    while (!fsnewl && *s!='\0' && (s[1]!='\0' || endfile) )
		s=doAC(s, 0);
	    if (column==1 || SCN==2) break; 
	    else if ( span(0) || (endfile && s[0]=='\0') ) { 
		if (endfile && s[0]=='\0') {  /* see issfs  SCN=2 */
			if (s[-1]!=EOL) snewline(1);
			cBM=span(10); 
		}
		else cBM = BM;
		cLM = H = LM;
		pcolumn = 1;
		break;
	    }
	    fsnewl = 0; 
	}
	if (hztogb==3) { p=s; continue;}
/* recover status variables */
	Ci=Cis; Ca=Cas; Casc=Cascs; Cx=Cxs; Cy=Cys; ptspc=ps; 
	CSP = CSPs; CLP = CLPs; 
	if (nEF != nEFs) {
		nEF=nEFs;
		if (!getdata(1)) for (j=0; j<95; j++) Wasc[j]=1;
	}
/* PRINT */
	pline=1; 
	do {
	    fnewline=0;
	    while (!fnewline && *p!='\0' && (p[1]!='\0' || endfile) )
		p=doAC(p, 1);
	    if (column==1) break;
	} while (pline<=sline && *p!='\0');
    }
    if (hztogb!=3) endpage(1);
    else HZGBconv(1);
    cleanup();
}

unsigned char *doAC(q, pr)
unsigned char *q;
int pr;
{
	int k, j=1;
	int putCH(), putASC(), scanCH(), scanASC(), isfs();
	unsigned char c1, c2;
	c2=0;
	if ( (c1 = *q++) >= 0xa1) {  
	    if (q[0]=='\0') ; 
	    else {
		c2= *q++;
		if (!big5 && c2 >= 0xa1) {  
		    if (c1==0xa3 && alnumadjust && isalnum(c2-128)) c1=c2-128;
        	    else j = 2;
		}
		else if (big5 && c2 >= 0x40) j = 2;
		else {q--; c2=0;}
	    }
	} 
	else if (c1=='@' && q[0]=='[') {
		if (k=isfs(q, pr)) {
			q += k; j=0;
		}
	} 
 	if (j==2) k = (pr)? putCH(c1, c2) : scanCH(c1, c2);  
	else if (j==1) {
	    if (c1==EOL && *q=='\0' && pr) k=0; /* Do not print the last EOL */
	    else if (!vgb || !isvgb(c1)) k = (pr)? putASC(c1) : scanASC(c1);
	    else k = ((pr)? putCH(0xa3, c1+128) : scanCH(0xa3, c1+128))/2;
	}
	else k=0;
	if (k==1 && c2!=0) k++;
	if (hztogb==3 && !k) {        /* filter */
		if (j==1) fprintf(out, "%c", c1);
		else if (j==2) fprintf(out, "%c%c", c1, c2); 
	}
	return (q-k);
}

getroot()
{
	char *s;
	int c = ':';
	strcpy(root, CNLIB);	/* built-in path has priority */
	if (strlen(root) > 4) {
		root[strlen(root)-9]='\0'; return 1;
	}
	if ((s=getenv("HBFPATH"))==NULL) root[0]='\0';
	else strcpy(root, s);
	if (!strlen(root)) return 1;
#if VMS
	c = ',';
#endif
	if ((s=strchr(root, c))!=NULL) root[s-&root[0]]='\0';
#if unix
	if (root[strlen(root)-1] != '/') strcat(root, "/");
#endif
	return 1;
}

void FName(s, t)
char *s, *t;
{
	int j;
#if VMS
	j=strlen(s);
	while (s[j]!=';' && j) j--;
	if (j>1) s[j]='\0'; 
#endif
	strcat(s, t);
}

RE_name(s, t)
char *s, *t;
{
#if unix
	char p[100];
	sprintf(p, "mv %s %s", s, t);
	system(p);
#else
	rename(s, t);
#endif
	return 0;
}
