/*
 * NAME
 *   VarBuf.h
 * COPYRIGHT
 *   VarBuf - Variable size buffer ADT.
 *   Copyright (C) 1995  Rene W.J. Pijlman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * VERSION
 *   /home/rene/sys/CVS_MasterSourceRepository/skim/VarBuf.h,v 1.5 1995/08/05 22:28:10 rpijlman Exp
 *   Distributed with Skim version 0.6.
 */

#ifndef _VARBUF_H_
#define _VARBUF_H_

#include <stdlib.h>
#include <stdio.h>

#include "Types.h"

typedef struct _VarBuf
* VarBuf;

/* Create and destroy. */
VarBuf VBCreate( void );
void VBDestroy( VarBuf );

/* Adding stuff. */
void VBAppendString( VarBuf, const char * );
void VBAppendCharacter( VarBuf, const char );
void VBPrintf( VarBuf, const char *, ...);
void VBAppendVB( VarBuf, VarBuf );

/* I/O. */
#define WITH_NEWLINE True
#define WITHOUT_NEWLINE False
Boolean VBReadLine( VarBuf, FILE *, Boolean );

/* Queries. */
void * VBAddress( VarBuf );
char * VBAsString( VarBuf );
size_t VBSize( VarBuf );

/* VB manipulation. */
void VBReset( VarBuf );
void VBShiftLeft( VarBuf, size_t );
void VBTruncate( VarBuf, size_t );

#endif
