/*
 * NAME
 *   Skim.h
 * COPYRIGHT
 *   Skim - Off-line news reading package optimized for slow lines.
 *   Copyright (C) 1995  Rene W.J. Pijlman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * VERSION
 *   Skim version 0.6.
 *   /home/rene/sys/CVS_MasterSourceRepository/skim/Skim.h,v 1.16 1995/08/14 21:56:10 rpijlman Exp
 */

#ifndef _SKIM_H_
#define _SKIM_H_

#include <stdio.h>
#include <stdlib.h>

#include "Types.h"
#include "VarBuf.h"

/* To be able to compile with gcc on SunOS 4.1.3. */
#ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#endif
#ifndef EXIT_FAILURE
#    define EXIT_FAILURE 1
#endif

#define NotASocket (-1)

FILE * NNTPStreamOpen( void );
void NNTPStreamClose( FILE * );

void TextResponseToFile( FILE * , FILE * );
void CheckStatusResponse( FILE *, const char *, const char * );

void AddArticleToIndex(
    VarBuf ArticleFileName,
    VarBuf ArticleNumber,
    FILE * ArticleIndex );

VarBuf GetHeaderLineFromArticle(
    VarBuf ArticleFileName,
    const char * Header );

Boolean LineIsBlank( const char * Line );

char * SkimDir( void );

/*
 * We want to place the $Header string of the source control system (CVS)
 * in the object files. The more obvious ``static char FileId[] = "$Header";''
 * raises the gcc warning: `FileId' defined but not used. To fool gcc we
 * use a structure with a self-reference.
 */
#define FILE_ID(a) \
static struct _FileId { \
    char * FileId; \
    struct _FileId * SelfReference; \
} FileId = { a , &FileId }

#endif   /* _SKIM_H_ */

