/*
 * NAME
 *   ArticleIndex.c
 * DESCRIPTION
 *   Functions for access to the article index files.
 * COPYRIGHT
 *   Skim - Off-line news reading package optimized for slow lines.
 *   Copyright (C) 1995  Rene W.J. Pijlman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * VERSION
 *   Skim version 0.6.
 */

#include <unistd.h>
#include <string.h>

#include "VarBuf.h"
#include "Skim.h"

FILE_ID("/home/rene/sys/CVS_MasterSourceRepository/skim/ArticleIndex.c,v 1.1 1995/08/14 21:56:08 rpijlman Exp" );


void AddArticleToIndex(
    VarBuf ArticleFileName,
    VarBuf ArticleNumber,
    FILE * Index )
{
    VarBuf HeaderContent;

    HeaderContent = GetHeaderLineFromArticle( ArticleFileName, "Subject" );
    if ( HeaderContent == NULL )
    {
        fprintf( stderr, "Article %s has no Subject header line\n",
                 VBAsString(ArticleFileName) );
        exit( EXIT_FAILURE );
    }

    if ( fprintf( Index, "%s %s\n", VBAsString(ArticleNumber), 
                  VBAsString(HeaderContent) ) == EOF )
    {
        fprintf( stderr, 
                 "Error writing to index file (current article is %s)\n",
                 VBAsString( ArticleFileName ) );
        exit( EXIT_FAILURE );
    }

    VBDestroy( HeaderContent );
}
