/*
 * NAME
 *   Article.c
 * DESCRIPTION
 *   Functions to access an article file.
 * COPYRIGHT
 *   Skim - Off-line news reading package optimized for slow lines.
 *   Copyright (C) 1995  Rene W.J. Pijlman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * VERSION
 *   Skim version 0.6.
 */

#include <unistd.h>
#include <string.h>
#include <ctype.h>

#include "VarBuf.h"
#include "Skim.h"

FILE_ID("/home/rene/sys/CVS_MasterSourceRepository/skim/Article.c,v 1.3 1995/08/15 19:33:32 rpijlman Exp" );

Boolean LineIsBlank( const char * Line )
{
    Boolean IsBlank = True;
    const char * p;

    for ( p = Line; *p != '\0'; p++ )
    {
        if ( !isspace( *p ) )
        {
            IsBlank = False;
        }
    }

    return IsBlank;
}


/*
 * Return the content of the header line from an article. Return NULL when the
 * requested header line is not present.
 *
 * For example, when the headerline is "Subject: help with LILO" and the 
 * "Subject" header line is requested, this function returns a VarBuf with 
 * "help with LILO".
 *
 * The caller is responsible for destroying the VarBuf.
 */
VarBuf GetHeaderLineFromArticle(
    VarBuf ArticleFileName,
    const char * Header )
{
    FILE * Article;
    VarBuf Line = VBCreate();
    VarBuf HeaderContent = NULL;
    Boolean InHeader = True;

    Article = fopen( VBAsString(ArticleFileName), "r" );
    if ( Article == NULL )
    {
        fprintf( stderr, "Cannot open article file %s\n",
                 VBAsString(ArticleFileName) );
        exit( EXIT_FAILURE );
    }

    while ( HeaderContent == NULL && InHeader && 
            VBReadLine( Line, Article, WITHOUT_NEWLINE ) )
    {
        if ( LineIsBlank( VBAsString(Line) ) )
        {
            InHeader = False;
        }
        else if ( !strncasecmp( VBAsString(Line), Header, strlen(Header) ) )
        {
            char * p;

            HeaderContent = VBCreate();

            for ( p = VBAsString(Line) + strlen(Header);
                  *p == ':' || isblank(*p);
                  p++ );
	    VBAppendString( HeaderContent, p );
        }

        VBReset( Line );
    }

    VBDestroy( Line );

    return HeaderContent;
}
