/* This file is part of the Project Athena Zephyr Notification System.
 * It contains headers for the windowgram COMPILER.
 *
 *	Created by:	Mark W Eichin
 *
 *	$Source: /mit/zephyr/src/zwgc/RCS/support.h,v $
 *	$Author: eichin $
 *
 *	Copyright (c) 1987 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h".
 *	$Header: support.h,v 2.2 88/07/10 22:12:36 eichin Exp $
 */

#include <zephyr/mit-copyright.h>
/*
 * variables and raw_table are malloc'd at init time and doubled in
 * size as needed. Even so, this will probably never really happen.
 */
#define MAXTAB 128
#define MAXRAWTAB 1024
extern char **variables;
extern char **raw_table;
extern int max_vars, max_raws;

rope tokenize_variable();
rope tokenize_command();
rope tokenize_show();
rope tokenize_raw();
rope tokenize_separator();
int token_casefind();
int token_find();
int token_add();
void token_init();

char *malloc(), *strncpy(), *realloc();

#define strndup(x,n) strncpy(malloc(n+1),x,n)
