/*
 * Startppp
 *
 * Copyright (C) 1995  Matthias Ott 
 *  (msott@cip.informatik.uni-erlangen.de)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <string.h>
#include "tk.h"
#include <time.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include <fcntl.h>
#include <termios.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>

#include "Time.h"

/*
   **	Function name : gettime
   **
   **	Description : returns time (raw)
   **	Input : -
   **	Output :
*/
int GetTime(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
  if (argc != 1) {
    interp->result = "wrong # args";
    return TCL_ERROR;
  }
  sprintf(interp->result,"%d",(int)time(NULL));
  return TCL_OK;
}

/*
   **	Function name : getshowtime
   **
   **	Description : returns time (hh:mm:ss)
   **	Input : -
   **	Output :
*/
int GetShowTime(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
  time_t mytime;
  struct tm *myfield;
  if (argc != 1) {
    interp->result = "wrong # args";
    return TCL_ERROR;
  }
  mytime=time(NULL);
  myfield=localtime(&mytime);
  sprintf(interp->result,"%2.2d:%2.2d:%2.2d",myfield->tm_hour,myfield->tm_min,myfield->tm_sec);
  return TCL_OK;
}

/*
   **	Function name : OnlineTime
   **
   **	Description : returns difftime
   **	Input : <show $time> = formated, <raw $time> = raw
   **	Output :
*/
int OnlineShowTime(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
  time_t mytime1, mytime2;
  struct tm *myfield;
  if (argc != 3) {
    interp->result = "wrong # args";
    return TCL_ERROR;
  }
  mytime1=time(NULL);
  mytime2=difftime(mytime1,atof(argv[2]));
  myfield=gmtime(&mytime2);
  if ((strcmp(argv[1],"showsec")==0)) {
    sprintf(interp->result,"%2.2d:%2.2d:%2.2d",myfield->tm_hour,myfield->tm_min,myfield->tm_sec);
  } else if ((strcmp(argv[1],"raw")==0)) {
    sprintf(interp->result,"%d",(int)mytime2);
  } else if ((strcmp(argv[1],"showmin")==0)) {
    sprintf(interp->result,"%2.2d:%2.2d",myfield->tm_hour,myfield->tm_min);
  }
  return TCL_OK;
}

/*
   **	Function name : Showdifftime
   **
   **	Description : converts rawtime to showtime
   **	Input : <show $time> = formated
   **	Output :
*/
int ShowDiffTime(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
  time_t mytime1, mytime2;
  struct tm *myfield;
  if (argc != 3) {
    interp->result = "wrong # args";
    return TCL_ERROR;
  }
  mytime1=0;
  mytime2=difftime(mytime1,atof(argv[2]));
  myfield=gmtime(&mytime2);
  if ((strcmp(argv[1],"showsec")==0)) {
    sprintf(interp->result,"%2.2d:%2.2d:%2.2d",myfield->tm_hour,myfield->tm_min,myfield->tm_sec);
  } else if ((strcmp(argv[1],"showmin")==0)) {
    sprintf(interp->result,"%2.2d:%2.2d",myfield->tm_hour,myfield->tm_min);
  }
  return TCL_OK;
}

/*
   **	Function name : GetPartZone var start stop zoneday(0-6)
   **
   **	Description : returns zone
   **	Input : <var> : the variable which should be changed
   **              <start, stop> : time for nightzone 
   **	Output : 1 for daytime, 2 for nighttime
*/
int GetPartZone(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
  time_t mytime;
  int i;
  char zone[]="1";
  char filename[100];
  struct tm *myfield;
  if (argc != 11) {
    interp->result = "wrong # args";
    return TCL_ERROR;
  }
  mytime=time(NULL);
  myfield=localtime(&mytime);
  if (atoi(argv[myfield->tm_wday+4])==1) {
    strcpy(zone,"2");
  }
  else {
    if (atoi(argv[2]) > atoi(argv[3])) {
      if ((myfield->tm_hour>=atoi(argv[2])) || (myfield->tm_hour<atoi(argv[3]))) 
	strcpy(zone,"2");
    }
    else {
      if ((myfield->tm_hour>=atoi(argv[2])) && (myfield->tm_hour<atoi(argv[3]))) 
	strcpy(zone,"2");
    }
  }
  if (zone != "2") {
    FILE *fd;
    int day;
    int nowday;
    nowday = (myfield->tm_mday * 100) + myfield->tm_mon + 1;
    sprintf(filename,"%s/.startppp_holidays",getenv("HOME"));
    fd=fopen(filename,"r");
    if (fd==NULL)
      return TCL_ERROR;
    while ((fscanf(fd,"%d",&day))!=EOF) {
      if (day == nowday) {
	strcpy(zone,"2");
	break;
      }
    }
    fclose (fd);
  }  
  sprintf(interp->result,"%s",zone); 
  Tcl_SetVar (interp, argv[1], zone,TCL_GLOBAL_ONLY);
  return TCL_OK;
}

/*
   **	Function name : SetIconName
   **
   **	Description :
   **	Input :
   **	Output :
*/
int SetIconName(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
  Tk_Window tkwin;
  if (argc != 1) {
    interp->result = "wrong # args";
    return TCL_ERROR;
  }
  tkwin = Tk_MainWindow(interp);
  /*  tkwin = (Tk_Window) clientData; */
  XSetIconName(Tk_Display(tkwin),Tk_WindowId(tkwin),"XlibIcon");
  
  return TCL_OK;
}

