#include "h/common.h"
#include <termios.h>
#include "h/terminal.h"

static struct termios oldterm;

void 
term_save(fd)
	int fd;
{
	tcgetattr(fd, &oldterm);
}

int
term_raw(fd, vmin, vtime, baud)
	int fd;
	u_int vmin;
	u_int vtime;
	int baud;
{
	struct termios tempio;
	
	tcgetattr(fd, &tempio);
	
	tempio.c_iflag = 0;
	tempio.c_oflag = 0;
	tempio.c_lflag = 0;
#if defined(__alpha) || defined(I_AM_NAUGHTY)
	/*
	 * This will improve interactive sessions, but will increase CPU usage
	 * by a fair whack (preliminary tests show up to 4-fold increase in CPU usage,
	 * especially with interactive sessions)
	 * It's also needed for Alpha because VTIME doesn't work
	 * with select in DEC OSF/1 !
	 * 
	 * Be nice and use the usual vmin and vtime values.
	 */
	tempio.c_cc[VMIN] = 1;
	tempio.c_cc[VTIME] = 0;
#else
	tempio.c_cc[VMIN] = vmin;
	tempio.c_cc[VTIME] = vtime;
#endif
	
/*	cfsetospeed(&tempio, baud);
 *	cfsetispeed(&tempio, baud);
 */
	return tcsetattr(fd, TCSANOW, &tempio);
}

void 
term_restore(fd)
	int fd;
{
	tcsetattr(fd, TCSANOW, &oldterm);
}

