/*
 * slirppp.h - definitions
 * 
 * Juha Pirkola 1995
 *
 * included through ppp.h and SLiRP's main.c
 *
 */ 

#ifndef __SLIRPPP_H__
#define __SLIRPPP_H_

#include <config.h>
#include "../h/common.h"
/* #include <netinet/in.h> */
#include <sys/types.h>

#define SLIRPPP_VERSION "v0.1"
#define PPP_LOGFILE	"ppplog"

/* special characters */
#define PPP_FLAG        0x7E    /* frame delimiter */
#define PPP_TRANS       0x20    /* transparency modifier */
#define PPP_ESC         0x7d    /* escape character */

/* protocols */
#define PROTO_IP       0x0021
#define PROTO_VJCOMP   0x002d
#define PROTO_VJUNCOMP 0x002f

/* FCS support */
#define PPP_FCS_INIT   0xffff
#define PPP_FCS_GOOD   0xf0b8


#define in_xmap(c)  (xmit_async_map[(c) >> 5] & (1 << ((c) & 0x1f)))
#define in_rmap(c)  ((((unsigned int) (unsigned char) (c)) < 0x20) && \
                        recv_async_map & (1 << (c)))

#ifndef GIDSET_TYPE			/* I'm not sure who needs this */
#define GIDSET_TYPE gid_t
#endif

#ifdef __linux__			/* Maybe both should be undef'd ? */
#define _linux_
#endif
										
struct ppp_out {
	unsigned char *buff;
	unsigned char *head;
	unsigned short fcs;
};

extern int debug;
extern FILE *logfile;

#endif /* __SLIRPPP_H__ */
