/* pppmon/src/pppmon.h
 *
 * Description:
 * Header file for the pppmon package
 *
 * This software is in the public domain.
 *
 * Please send all bug reports, requests for information, etc. to:
 *   Calle Karlsson
 *   KaSH Software AB
 *   calle@kash.se
 *
 * History:
 * 950525 ckn Initial coding
 * EndHistory.
 */

#ifndef __PPPMON_H__
#define __PPPMON_H__

/* Lots of probably unneeded include files */

#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/fcntl.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <sys/param.h>
#include <net/if.h>
#include <netdb.h>
#ifdef __linux__
#include <linux/ppp.h>
#endif
#include <netinet/ip.h>
#include <netinet/in.h>
#include <netinet/tcp.h>

typedef struct
{
   unsigned long UpTime;
   unsigned long RBytes, SBytes;
   unsigned long RTT;  /* Might come in handy later */
   unsigned long TimeSpent;
} DclPPPMonitorMsg;

#endif
