#!/bin/sh
cf=$HOME/.country
if test $# -lt 1 -o $# -gt 2 
then
	echo "Usage: osearch organisation [ country ]"
	exit
fi

if test $# -eq 2
then
	country=$2
	echo $country > $cf
else
	if test -f $cf
	then
		country=`cat $cf`
	else
		country=gb
		echo $country > $cf
	fi
fi
echo Searching in country \"$country\" for Organisations matching \"$1\"	
search @c=$country -filter "o~=$1 | o=\*$1\*"  -type description -type telephonenumber -show -singlelevel
