#!/bin/sh
#Calculate unique TCP port based on PID
ppid=$$
if ( test $ppid-lt10000 )
then
	ppid=`expr $ppid + 10000`
fi
DISHPROC="127.0.0.1 $ppid"
export DISHPROC
if ( bind )
then
	echo -n
else
	exit 1
fi
moveto @
echo "Searching ROOT"
search -filter objectclass=DSA -nokey -seq dsas -nosize -nopart -singlelevel
for i in `search -filter objectclass=quipunonleafobject -noname -seq x -nosize -nopart -singlelevel` 
do
	echo -n "Searching "
	moveto -seq x -nocheck $i -pwd
	search -filter objectclass=DSA -norel -seq dsas -nosize -nopart -singlelevel
	if ( search -filter objectclass=quipunonleafobject -nopart -noname -seq y -nosize -singlelevel > /tmp/dsalist 2>/dev/null )
	then
		for j in `cat /tmp/dsalist` 
		do 
			echo -n "Searching "
			moveto -seq y -nocheck $j -pwd
			if (search -filter objectclass=quipuDSA -norel -subtree -seq dsas -nosize -nopart >/tmp/dsalist 2>/dev/null )
			then
				cat /tmp/dsalist
			fi
		done
	fi
done
echo 
echo Summary...
squid -seq dsas
rm -f /tmp/dsalist
unbind
