/*
 * Configurable finger daemon
 * Header file
 *
 * by Ken Hollis for the Configurable Finger Daemon
 *
 * Copyright (C) 1995, Bitgate Software and Ken Hollis
 */

#ifndef NOBODY_UID
# error "You cannot compile this program without a NOBODY USER ID defined!"
#endif

#ifndef NOBODY_GID
# error "You cannot compile this program without a NOBODY GROUP ID defined!"
#endif

#ifndef TIMEOUT
# error "You cannot compile this program without a TIMEOUT defined!"
#endif

/* Include-file mania */
#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <netdb.h>
#include <errno.h>
#include <utmp.h>
#include <ctype.h>
#include <time.h>
#include <pwd.h>

#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/types.h>

#ifndef BOOL
#define	BOOL	int
#endif

#ifndef TRUE
#define	TRUE	1
#define	FALSE	0
#endif

#define	UNUSED(x)	void(x)

#include "proto.h"

#ifdef	BSD_OS
#include "getutent.h"
#endif

#define	NO_PRIV_UID	32767
#define	NO_PRIV_GID	32766

/* First configuration option bit pair */
#define	SHOW_SYSLOG	0x0001	/* Log all errors to the syslog daemon	*/
#define	SHOW_TOP	0x0002	/* Show the top file on a finger req.	*/
#define	SHOW_BOTTOM	0x0004	/* Show the bottom file on a finger req.*/
#define	SHOW_UNAME	0x0008	/* Show the user's login name		*/
#define	SHOW_REALNAME	0x0010	/* Show the user's real name		*/
#define	SHOW_DIR	0x0020	/* Show the user's home directory	*/
#define	SHOW_SHELL	0x0040	/* Show the user's shell program	*/
#define	SHOW_ROOM	0x0080	/* Show the user's room number		*/
#define	SHOW_WPHONE	0x0100	/* Show the user's work phone number	*/
#define	SHOW_HPHONE	0x0200	/* Show the user's home phone number	*/
#define	SHOW_OTHER	0x0400	/* Show the user's other information	*/
#define	SHOW_LTON	0x0800	/* Show the last time this user was on	*/
#define	SHOW_IFON	0x1000	/* Show if this user is currently on	*/
#define	SHOW_LRMAIL	0x2000	/* Show the last time mail was read	*/
#define	SHOW_MRDATE	0x4000	/* Show the last day that mail was read	*/
#define	SHOW_FROM	0x8000	/* Show where the last login originated	*/

/* Second configuration option bit pair -- ALWAYS room for improvement */
#define	SHOW_PLAN	0x0001	/* Show the user's plan file		*/
#define	SHOW_PROJECT	0x0002	/* Show the user's project file		*/
#define	SHOW_NN_BANNER	0x0004	/* Show banner if no name specified	*/
#define SHOW_REJECTED	0x0008	/* Show the rejected file if wanted	*/
#define	SHOW_SYSTEMLIST	0x0010	/* Show the user listing if wanted	*/
#define	SHOW_WILDCARD	0x0020	/* Treat hostnames as wildcards		*/
#define	SHOW_IP_MATCH	0x0040	/* Show if Hostname not found from IP	*/
#define	SHOW_NOUSER	0x0080	/* Show no-user matched banner		*/

/* Program exit states */
#define	PROGRAM_OKAY	0	/* Program exited fine			*/
#define	PROGRAM_SYSLOG	1	/* Program exited after a syslog report	*/
#define	PROGRAM_BUG	2	/* Program exited because of a bug	*/

/* Display strings (This could increase shortly) */
#define	D_USERNAME	0	/* Username string			*/
#define	D_REALNAME	1	/* Realname string			*/
#define	D_DIRECTORY	2	/* Directory string			*/
#define	D_SHELL		3	/* Shell string				*/
#define	D_ROOM		4	/* Room number string			*/
#define	D_WORK_PHONE	5	/* Work phone number string		*/
#define	D_HOME_PHONE	6	/* Home phone number string		*/
#define	D_OTHER		7	/* Other string				*/
#define	D_IP_NO_MATCH	8	/* No hostname matches IP string	*/
#define	D_NICE_FATAL	9	/* Nice-routine fatality string		*/
#define	D_STDIN_EMPTY	10	/* STDIN empty string			*/
#define	D_TRUST_HOST	11	/* Trusted host display string		*/
#define	D_REJECT_HOST	12	/* Rejected host display string		*/
#define	D_ROOT_FINGER	13	/* Root finger display string		*/
#define	D_SVC_FINGER	14	/* Service finger display string	*/
#define	D_ULIST_FINGER	15	/* Userlist finger display string	*/
#define	D_FAKE_USER	16	/* Fake user display string		*/
#define	D_WHOIS_USER	17	/* Whois user display string		*/

typedef struct {
    char *user;			/* Fake username */
    char *script;		/* Fake user's corresponding script */
    char *description;		/* Script description */
    BOOL searchable;		/* Searchable boolean ... are we searchable? */
} FAKEUSERS;

typedef struct {
    char *header[5];		/* Five headers for the top display */
    char *display_string;	/* Display string in printf format */
    int name_pos;		/* Position in the string to display name */
    int service_pos;		/* Position in the string to display service */
    int search_pos;		/* Position in the string to display search */
} SERVICES;

typedef struct {
    char *top_display_file;	/* Displayed at the top of the listing */
    char *bottom_display_file;	/* Displayed at the close of the listing */
    char *plan_file;		/* The generic plan file to use */
    char *project_file;		/* The generic project file to use */
    char *no_name_banner_file;	/* Banner file used if no name specified */
    char *no_user_banner_file;	/* Banner file used if no user is matched */
    char *no_finger_file;	/* File used if no finger is wanted */
    char *rejected_file;	/* Rejected host text file display */
    char *syslog_file;		/* Syslog output file */
    char *finger_program;	/* Program to run when no name is queried */
    char *rejected[80];		/* Rejected hosts */
    char *trusted[80];		/* Trusted hosts */
    char *p_strings[80];	/* Program-related context print strings */
    FAKEUSERS fusers[40];	/* Fake user name listings */
    SERVICES services;		/* Services configuration display */
    int  config_bits1;		/* First row of configuration bits */
    int  config_bits2;		/* Second row of configuration bits */
    int  local_config_bits1;	/* Local first row of config bits */
    int  local_config_bits2;	/* Local second row of config bits */
} CONFIG;

/* CFINGER_CONF should be defined in the Configure program.  If it isn't, it
   will be defined here. */
#ifndef CFINGER_CONF
#define CFINGER_CONF	"/etc/cfingerd.conf"
#endif

/* The amount of time that the program waits before it outputs any data
   to the opened socket.  This is definable; and is usually the standard
   here.  Set it in the Makefile if it appears there, otherwise change
   it here. */
#ifndef GRACE_PERIOD
#define	GRACE_PERIOD	0
#endif

#define	PROG_ID	"@(#) $Author: cfingerd 1.0.1 - by Ken Hollis - \
		khollis@bitgate.chatlink.com $"

extern CONFIG prog_config;
extern BOOL local_finger, trusted, rejected;
extern int  trusted_host_num, rejected_host_num, fakeuser_num, num_headers;
extern char *local_host;
