#!/usr/bin/perl
#
# Configurable Finger Daemon Makefile Configuration program v. 1.44
# by Ken Hollis
#
# Released under the GPL as part of the Security/Administrative Package.
# Please read the file "README" for more details.
#
# Note: Yes, I DO know other languages besides C, thank you very much!  :)

### Change this line if your dialog program is somewhere else.
$DIALOG="/bin/dialog";

$COMPILER="gcc";
$COMPILE_FLAGS="-Wall -O2 -m486";
$DEBUGGING="N";
$G_DEBUG="N";
$GRACE_PERIOD="0";
$TIMEOUT="10";
$SYSLOG="Y";
$INSTALL_DIR="/usr/sbin";
$WHOIS="/usr/bin/whois";
$CONFIG_FILE="cfingerd.conf";
$CONFIG_FILE_DEST="/etc";
$CFINGER_CONF="-DCFINGER_CONF=/etc/cfingerd.conf";
$CFINGER_HOME="-DCFINGER_HOME=/usr/sbin";
$MAN_PAGE="/usr/man/man1";
$VERSION="1.0.2/LINUX/BSDI";

system("clear");

sub make_makefile {
if ($DEBUGGING eq "Y") {
    $COMPILE_FLAGS = $COMPILE_FLAGS . " -DDEBUG";
}

$COMPILE_FLAGS = $COMPILE_FLAGS . " -DGRACE_PERIOD=${GRACE_PERIOD}";

$MADE_MAKE = "TRUE";

open(OUTFILE, ">Makefile");
print OUTFILE<<"EOT";
# Generic config file for the Configurable Finger Daemon
# by Ken Hollis
#
# Don't expect this to work on all machines.  This was designed to work
# on the Linux operating system, and it may not be compatible with all
# machines.  If you have a fix, mail me the fix!  :-)
#
# Uncomment the lines that you can fix.

### This is your compiler.  I like GCC, so shoot me.
COMPILER=${COMPILER}

### These are the compiler flags you want
COMPILE_FLAGS=${COMPILE_FLAGS}

### Installation directory (where to put the finger daemon)
INSTALL_DIR=${INSTALL_DIR}

### The configuration file
CONFIG_FILE=${CONFIG_FILE}

### The configuration file's destination during installation
CONFIG_FILE_DEST=${CONFIG_FILE_DEST}

### Manual page directory
MAN_PAGE=${MAN_PAGE}

### Time out phase
TIMEOUT=-DTIMEOUT=${TIMEOUT}

### Whois program
WHOIS=-DWHOIS=\\\"${WHOIS}\\\"

EOT

if ($SYSLOG eq "Y") {
    print OUTFILE "### Syslogging\n";
    print OUTFILE "SYSLOG=-DSYSLOG\n\n";
    print OUTFILE<<"EOT";
### All make file options in one (DO NOT CHANGE THIS LINE!)
ALL_OPTIONS=\$(COMPILE_FLAGS) \$(CFINGER_CONF) \$(CFINGER_HOME)\\
	-DCFINGER_CONF=\\\"${CONFIG_FILE_DEST}/${CONFIG_FILE}\\\"\\
	${NOBODY_UID} ${NOBODY_GID} \$(TIMEOUT) \$(WHOIS) \$(SYSLOG)
EOT
} else {
    print OUTFILE<<"EOT";
### All make file options in one (DO NOT CHANGE THIS LINE!)
ALL_OPTIONS=\$(COMPILE_FLAGS) \$(CFINGER_CONF) \$(CFINGER_HOME)\\
	-DCFINGER_CONF=\\\"${CONFIG_FILE_DEST}/${CONFIG_FILE}\\\"\\
	${NOBODY_UID} ${NOBODY_GID} \$(TIMEOUT) \$(WHOIS)
EOT
}

print OUTFILE<<"EOT";

### Link filenames (DO NOT CHANGE THIS LINE!)
LINK_NAMES=./src/configure.o ./src/cfingerd.o ./src/finger.o ./src/util.o \\
           ./src/signal.o ./src/strmcpy.o ./src/services.o ./src/pprintf.o \\
EOT

if ($system_name eq "BSD_OS") {
    print OUTFILE "	   ./src/getutent.o\n";
}

print OUTFILE<<"EOT";

all:
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/strmcpy.c -o ./src/strmcpy.o
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/pprintf.c -o ./src/pprintf.o
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/configure.c -o ./src/configure.o
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/cfingerd.c -o ./src/cfingerd.o
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/finger.c -o ./src/finger.o
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/util.c -o ./src/util.o
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/signal.c -o ./src/signal.o
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/services.c -o ./src/services.o
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/getutent.c -o ./src/getutent.o
	\$(COMPILER) ${G_DEBUG}-o in.fingerd \$(LINK_NAMES)
	\@ls -al | grep in.fingerd
	\@echo
EOT

if ($DEBUGGING eq "N") {
    print OUTFILE<<"EOT";
	\@echo \"Stripping executable...\"
	\@strip in.fingerd
	\@ls -al | grep in.fingerd
	\@echo
EOT
}

print OUTFILE<<"EOT";
	\@echo \"Installing cfingerd manual\"
	\@install -c ./docs/cfingerd.1 \$(MAN_PAGE)
	\@install -c ./docs/cfingerd.conf.1 \$(MAN_PAGE)
	\@echo \"Installing fingerd into \$(INSTALL_DIR)\"
	\@chmod 700 in.fingerd
	\@cp in.fingerd \$(INSTALL_DIR)
	\@echo
	\@if [ -e ${CONFIG_FILE_DEST}/${CONFIG_FILE} ]; then \\
	echo \"Skipping config file installation; file exists\"; \\
	else \\
	echo \"Installing the config file into \$(CONFIG_FILE_DEST)\"; \\
	cp \$(CONFIG_FILE) \$(CONFIG_FILE_DEST); \\
	chmod 600 \$(CONFIG_FILE_DEST)/\$(CONFIG_FILE); \\
	fi
	\@if [ -e ${CONFIG_FILE_DEST}/cfingerd ]; then \\
	echo \"Skipping creation and copy of cfingerd standard files\"; \\
	else \\
	echo \"Copying standard text files to ${CONFIG_FILE_DEST}/cfingerd\"; \\
	mkdir ${CONFIG_FILE_DEST}/cfingerd; \\
	cp ./cfingerd/* ${CONFIG_FILE_DEST}/cfingerd; \\
	fi
	\@if [ -e ${CONFIG_FILE_DEST}/cfingerd/scripts ]; then \\
	echo \"Skipping creation of copy of fakeuser script files\"; \\
	else \\
	echo \"Copying fakeuser script files\"; \\
	mkdir ${CONFIG_FILE_DEST}/cfingerd/scripts; \\
	cp ./cfingerd/scripts/* ${CONFIG_FILE_DEST}/cfingerd/scripts; \\
	chmod 500 ${CONFIG_FILE_DEST}/cfingerd/scripts/*; \\
	fi
	\@echo
	\@echo \"done.\"
	\@echo
	\@echo \"Make sure you edit your inetd.conf file according to the\"
	\@echo \"README file.  Also, make sure you kill -HUP the inetd\"
	\@echo \"process.  (I could do this, but I could also kill init :-)\"
	\@echo
	\@echo \"Cleaning out object files, Make file and the daemon\"
	\@rm -f ./src/*.o in.fingerd Makefile
	\@echo \"done.\"
	\@echo

compile:
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/strmcpy.c -o ./src/strmcpy.o
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/pprintf.c -o ./src/pprintf.o
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/configure.c -o ./src/configure.o
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/cfingerd.c -o ./src/cfingerd.o
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/finger.c -o ./src/finger.o
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/util.c -o ./src/util.o
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/signal.c -o ./src/signal.o
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/services.c -o ./src/services.o
	\$(COMPILER) ${G_DEBUG}\$(ALL_OPTIONS) -c ./src/getutent.c -o ./src/getutent.o
	\$(COMPILER) ${G_DEBUG}-o in.fingerd \$(LINK_NAMES)
	\@ls -al | grep in.fingerd
	\@echo
EOT

if ($DEBUGGING eq "N") {
    print OUTFILE<<"EOT";
	\@echo \"Stripping executable...\"
	\@strip in.fingerd
	\@ls -al | grep in.fingerd
	\@echo
EOT
}

print OUTFILE<<"EOT";
	\@echo \"Type \\\"make install\\\" to install the daemon.\"

install:
	\@echo \"Installing cfingerd manual\"
	\@install -c ./docs/cfingerd.1 \$(MAN_PAGE)
	\@install -c ./docs/cfingerd.conf.1 \$(MAN_PAGE)
	\@echo \"Installing fingerd into \$(INSTALL_DIR)\"
	\@chmod 700 in.fingerd
	\@cp in.fingerd \$(INSTALL_DIR)
	\@echo
	\@if [ -e ${CONFIG_FILE_DEST}/${CONFIG_FILE} ]; then \\
	echo \"Skipping config file installation; file exists\"; \\
	else \\
	echo \"Installing the config file into \$(CONFIG_FILE_DEST)\"; \\
	cp \$(CONFIG_FILE) \$(CONFIG_FILE_DEST); \\
	chmod 600 \$(CONFIG_FILE_DEST)/\$(CONFIG_FILE); \\
	fi
	\@if [ -e ${CONFIG_FILE_DEST}/cfingerd ]; then \\
	echo \"Skipping creation and copy of cfingerd standard files\"; \\
	else \\
	echo \"Copying standard text files to ${CONFIG_FILE_DEST}/cfingerd\"; \\
	mkdir ${CONFIG_FILE_DEST}/cfingerd; \\
	cp ./cfingerd/* ${CONFIG_FILE_DEST}/cfingerd; \\
	fi
	\@if [ -e ${CONFIG_FILE_DEST}/cfingerd/scripts ]; then \\
	echo \"Skipping creation of copy of fakeuser script files\"; \\
	else \\
	echo \"Copying fakeuser script files\"; \\
	mkdir ${CONFIG_FILE_DEST}/cfingerd/scripts; \\
	cp ./cfingerd/scripts/* ${CONFIG_FILE_DEST}/cfingerd/scripts; \\
	chmod 500 ${CONFIG_FILE_DEST}/cfingerd/scripts/*; \\
	fi
	\@echo
	\@echo \"done.\"
	\@echo
	\@echo \"Make sure you edit your inetd.conf file according to the\"
	\@echo \"README file.  Also, make sure you kill -HUP the inetd\"
	\@echo \"process.  (I could do this, but I could also kill init :-)\"
	\@echo

clean:
	\@echo \"Cleaning out object files, Make file and the daemon\"
	\@rm -f ./src/*.o in.fingerd Makefile
	\@echo \"done.\"

help:
	\@clear
	\@echo \"CFINGERD 1.0 Makefile by Ken Hollis\"
	\@echo \"Makefile version 1.45 (khollis\@bitgate.chatlink.com)\"
	\@echo
	\@echo \"Makefile help\"
	\@echo
	\@echo \"\\\"make\\\" by itself will make the makefile and install.\"
	\@echo \"\\\"make compile\\\" will compile the program and its elements.\"
	\@echo \"\\\"make install\\\" will install the program (after compile).\"
	\@echo \"\\\"make clean\\\" will clean all object files, Makefiles, and programs.\"
	\@echo \"\\\"make help\\\" will give you this screen.\"
	\@echo
EOT
close(OUTFILE);
}

sub config_shell {
print <<"EOT";
Program to configure cfingerd ${VERSION}
by Ken Hollis

If you are experiencing problems, please write to khollis\@bitgate.chatlink.com
to report them.  I'd appreciate it.

------------------------------------------------------------------------------

Please answer these questions below.  Default values are in brackets [], and
if you like the default value, simply hit the return key.  If you are 
paranoid that you've done something wrong, simply hit CTRL-C (or break) 
on your keyboard to back out of this and try again.

------------------------------------------------------------------------------

EOT

print "Please enter the name of the compiler you wish to use.  Since I am\n";
print "assuming you have the full pathnames set up correctly in your path\n";
print "variable, enter the name here, or enter the full path (ex. /bin/gcc)\n\n";
print "COMPILER [${COMPILER}]: ";

$COMPILER2 = <STDIN>;
chop($COMPILER2);

print "\n";
print "These are any compilation flags that you want to have installed.\n";
print "I usually put -DLINUX in here since this was designed for Linux, but\n";
print "you may want to put -DSYSV or what-not in here as well.\n\n";
print "COMPILE_FLAGS [${COMPILE_FLAGS}]: ";

$COMPILE_FLAGS2 = <STDIN>;
chop($COMPILE_FLAGS2);

print "\n";
print "Shall I enable debugging?  This gets a bit verbose, and it is used\n";
print "only for testing purposes (which I do alot of.)  This is normally\n";
print "\"N\" but if you're feeling looney, and you want to fill up your\n";
print "syslog file quickly, by all means; enable it.  :-)\n\n";
print "DEBUGGING [${DEBUGGING}]: ";

$DEBUGGING2 = <STDIN>;
chop($DEBUGGING2);
$DEBUGGING2 =~ tr/a-z/A-Z/;

if (($DEBUGGING eq "Y") && ($DEBUGGING2 eq "")) {
print "\n";
print "Shall I enable the \"-g\" option during compile time for use with the\n";
print "xups source-level debugger (if you're running X-Windows)?  This will\n";
print "make the binary size about 1 MB in length, but will make it so the\n";
print "entire symbol table is embedded in the source.  Do you want this\n";
print "enabled?  (Usually \"N\").\n\n";
print "G_DEBUG [${G_DEBUG}]: ";
$G_DEBUG2 = <STDIN>;
chop($G_DEBUG2);
$G_DEBUG2 =~ tr/a-z/A-Z/;
}

print "\n";
print "Please enter the GRACE PERIOD.  This is the period of time that the\n";
print "daemon waits until it starts displaying output to the screen.  Older\n";
print "versions of inetd have problems with timing out if you display the\n";
print "information too fast.  On older systems, you may want to set this\n";
print "grace period to 4.  The default value is 0.\n\n";
print "GRACE_PERIOD [${GRACE_PERIOD}]: ";

$GRACE_PERIOD2 = <STDIN>;
chop($GRACE_PERIOD2);

print "\n";
print "Please enter the directory that the compiled finger daemon will be\n";
print "placed in.  This is usually the directory that houses all of your\n";
print "other daemons.\n\n";
print "INSTALL_DIR [${INSTALL_DIR}]: ";

$INSTALL_DIR2 = <STDIN>;
chop($INSTALL_DIR2);

print "\n";
print "Please enter the name of the configuration file that you wish to\n";
print "use with cfingerd.  The norm here is cfingerd.conf, but some people\n";
print "like fingerd.conf or in.fingerd.conf.\n\n";
print "CONFIG_FILE [${CONFIG_FILE}]: ";

$CONFIG_FILE2 = <STDIN>;
chop($CONFIG_FILE2);

print "\n";
print "Please enter the destination for the configuration file.  This is\n";
print "normally /etc.\n\n";
print "CONFIG_FILE_DEST [${CONFIG_FILE_DEST}]: ";

$CONFIG_FILE_DEST2 = <STDIN>;
chop($CONFIG_FILE_DEST2);

print "\n";
print "Please enter the directory that houses your manual page.  This should\n";
print "be the un-preformatted directory.  Normally, I put this in /usr/man/man1\n";
print "but if you're brave, you can put it somewhere else.\n\n";
print "MAN_PAGE [${MAN_PAGE}]: ";

$MAN_PAGE2 = <STDIN>;
chop($MAN_PAGE2);

print "\n";
print "This is the amount of time that the program allows before causing a\n";
print "timeout in script execution.  This is usually 10.\n\n";
print "TIMEOUT [${TIMEOUT}]: ";

$TIMEOUT2 = <STDIN>;
chop($TIMEOUT2);

print "\n";
print "This is the program that you want to execute for the whois command.\n";
print "This is only for local whois requests, although this may change sometime\n";
print "in the near future.\n\n";
print "WHOIS [${WHOIS}]: ";

$WHOIS2 = <STDIN>;
chop($WHOIS2);

print "\n";
print "Do you want all reports to go to syslog or do you want it to report\n";
print "everything to stdout that it normally does?\n\n";
print "SYSLOG [${SYSLOG}]: ";

$SYSLOG2 = <STDIN>;
chop($SYSLOG2);

if ($COMPILER2 ne "") {
    $COMPILER = $COMPILER2;
}

if ($COMPILE_FLAGS2 ne "") {
    $COMPILE_FLAGS = $COMPILE_FLAGS2;
}

if ($DEBUGGING2 ne "") {
    $DEBUGGING = $DEBUGGING2;
}

if ($GRACE_PERIOD2 ne "") {
    $GRACE_PERIOD = $GRACE_PERIOD2;
}

if ($INSTALL_DIR2 ne "") {
    $INSTALL_DIR = $INSTALL_DIR2;
}

if ($CONFIG_FILE2 ne "") {
    $CONFIG_FILE = $CONFIG_FILE2;
}

if ($CONFIG_FILE_DEST2 ne "") {
    $CONFIG_FILE_DEST = $CONFIG_FILE_DEST2;
}

if ($MAN_PAGE2 ne "") {
    $MAN_PAGE = $MAN_PAGE2;
}

if ($G_DEBUG2 ne "") {
    $G_DEBUG = $G_DEBUG2;
}

if ($TIMEOUT2 ne "") {
    $TIMEOUT = $TIMEOUT2;
}

if ($WHOIS2 ne "") {
    $WHOIS = $WHOIS2;
}

if ($SYSLOG2 ne "") {
    $SYSLOG = $SYSLOG2;
}

print "\n";
print "---------------------------------------------------------------------------\n\n";
print "Your configuration is as follows:\n\n";
print "\tCOMPILER\t\t: ${COMPILER}\n";
print "\tCOMPILE_FLAGS\t\t: ${COMPILE_FLAGS}\n";
print "\tDEBUGGING\t\t: ${DEBUGGING}\n";
print "\tG_DEBUG\t\t\t: ${G_DEBUG}\n";
print "\tGRACE_PERIOD\t\t: ${GRACE_PERIOD}\n";
print "\tINSTALL_DIR\t\t: ${INSTALL_DIR}\n";
print "\tCONFIG_FILE\t\t: ${CONFIG_FILE}\n";
print "\tCONFIG_FILE_DEST\t: ${CONFIG_FILE_DEST}\n";
print "\tMAN_PAGE\t\t: ${MAN_PAGE}\n";
print "\tTIMEOUT\t\t\t: ${TIMEOUT}\n";
print "\tWHOIS\t\t\t: ${WHOIS}\n";
print "\tSYSLOG\t\t\t: ${SYSLOG}\n\n";
print "CORRECT? [Y]: ";

$CORRECT = <STDIN>;
chop($CORRECT);

$CORRECT =~ tr/a-z/A-Z/;

if ($CORRECT eq "N") {
    system("Configure");
    exit;
}

if ($G_DEBUG eq "Y") {
    $G_DEBUG = "-g ";
} else {
    $G_DEBUG = "";
}

print "\n";
print "---------------------------------------------------------------------------\n\n";
print "Great!  Creating the Makefile, please wait a sec.\n\n";

&make_makefile;

print "If all went well, you should have a Makefile ready.\n\n";
print "At this point you will want to type \"make\" to get\n";
print "things rolling.  When the program runs, check your syslog for any\n";
print "errors.\n\nGood luck!\n\n";
}

sub check_inetd {
    print "Checking /etc/inetd.conf...  ";
    open(INFILE, "/etc/inetd.conf") || die "/etc/inetd.conf: $!\n";
    while(<INFILE>) {
	chop;
	($servname, $socktype, $proto, $wait, $user, $serverprog, $servprogargs) = split(/\s+/);
	if (($servname eq "finger") || ($servname eq "fingerd")) {
	    if ($user eq "root") {
		print "finger runs as root.  Good.\n\n";
	    } else {
		print "\n\nINETD search reports finger is NOT running as root.  I can fix this\n";
		print "if you want.\n\n";
		print "Fix INETD entry for finger? [N]: ";
		$FIX_INETD = <STDIN>;
		print "\n";
		chop ($FIX_INETD);
		$FIX_INETD =~ tr/a-z/A-Z/;
		if ($FIX_INETD eq "Y") {
		    print "Changing INETD table (and backing up the old one)\n\n";
		    `cp /etc/inetd.conf /etc/inetd.conf.old`;
		    open(INETD1, "/etc/inetd.conf.old");
		    open(INETD2, ">/etc/inetd.conf");
		    while(<INETD1>) {
			if ((substr($_, 1, 1) eq "#") ||
			    (substr($_, 1, 1) eq "\n")) {
			    print INETD2 "$_";
			} else {
			    chop;
			    ($servname, $socktype, $proto, $wait, $user,
			     $serverprog, $servprogargs) = split(/\s+/);
			    if (($servname eq "finger") || ($servname eq "fingerd")) {
print INETD2 "${servname}\t${socktype}\t${proto}\t${wait}\troot\t${serverprog}\t${servprogargs}\n";
			    } else {
				print INETD2 "$_\n";
			    }
			}
		    }
		    close(INETD1);
		    close(INETD2);
		}
	    }
	}
    }
    close(INFILE);
}

sub prog_startup {
    $workdir = `pwd`;
    chop($workdir);

    $cd = "$workdir/scripts/Configure_Dialog.pl";
    $cg = "$workdir/scripts/Check_Groups.pl";

    require $cd;
    require $cg;

    $USE_DIALOG = "N";

    $system_name = `uname -s`;
    chop($system_name);
    $system_name =~ tr/a-z/A-Z/;
    $system_name =~ tr/\//_/;

    $COMPILE_FLAGS=$COMPILE_FLAGS . " -D${system_name}";
    $MADE_MAKE = "FALSE";

    if ($system_name eq "BSD_OS") {
	print "Ah HAH!  BSDI!\n\n";
    }

    if ($ARGV[0] eq "make") {
	&check_groups;
	&check_inetd;

	$G_DEBUG = "";
	print "Makefile option detected.  Creating makefile with defaults.\n";
	&make_makefile;
	print "Done.  Type \"make\" to make the file.\n\n";
	exit;
    } elsif ($ARGV[0] eq "auto") {
	$> && die "You *MUST* be superuser to do this!\n\n";
	&check_groups;
	&check_inetd;

	$G_DEBUG = "";
	print "Makefile option detected.  Creating makefile with defaults.\n";
	&make_makefile;
	print "Done.  Making the make file FOR you.\n\n";
	system("make");
	exit;
    } elsif ($ARGV[0] eq "inetd") {
	$> && die "You *MUST* be superuser to do this!\n\n";
	&check_inetd;
	exit;
    } elsif ($ARGV[0] eq "group") {
	$> && die "You *MUST* be superuser to do this!\n\n";
	&check_groups;
	exit;
    } elsif ($ARGV[0] eq "tests") {
	$> && die "You *MUST* be superuser to do this!\n\n";
	&check_inetd;
	&check_groups;
	exit;
    } elsif ($ARGV[0] eq "clean") {
	&make_makefile;
	system("make clean");
	exit;
    } elsif ($ARGV[0] eq "mhelp") {
	&make_makefile;
	system("make help");
	system("rm -f Makefile");
	exit;
    } elsif ($ARGV[0] eq "comp") {
	$> && print "You are not superuser...  This could pose problems.\n\n";
	&check_groups;
	$G_DEBUG = "";
	print "Creating the makefile and compiling.\n\n";
	&make_makefile;
	system("make compile");
	print "\nMakefile deleted.  If that didn't work, fix the errors.\n";
	`rm Makefile`;
	exit;
    } elsif ($ARGV[0] ne "") {
	print "CFINGERD 1.0 by Ken Hollis (khollis\@bitgate.chatlink.com)\n";
	print "Configuration file version 1.44 (Perl version)\n\n";
	print "Released under the GPL; use of this program for profit is prohibited.\n\n";
	print "Known options are:\n";
	print "\t\"make\"\tMakes the makefile according to standards\n";
	print "\t\"auto\"\tMakes the makefile and auto-makes for you\n";
	print "\t\"inetd\"\tChecks inetd.conf to make sure finger runs as root\n";
	print "\t\"group\"\tChecks to make sure you have a nobody password entry.\n";
	print "\t\"tests\"\tChecks the above two tests (inetd and group)\n";
	print "\t\"comp\"\tCompiles everything to make sure it works on your system\n";
	print "\t\"clean\"\tCleans out all object, executables, and Makefiles.\n";
	print "\t\"mhelp\"\tGives you the MAKEFILE help\n\n";
	exit;
    } elsif ($ARGV[0] eq "") {
	&check_groups;
	print "\n";
    }

    $> && print "This script *should* be run as superuser.\n\n";

    if (-e $DIALOG) {
	$USE_DIALOG = "Y";
	print <<"EOT";
I found the program \"dialog\" on your system.  You can choose to use it with
the configure program to make your configuration life easier, and make 
installation more smooth.  If you don't want to use it, type \"N\" here 
and you will be given a shell alternative.

EOT
	print "USE_DIALOG [${USE_DIALOG}] (Hit return to accept): ";
	$USE_DIALOG2 = <STDIN>;
	chop($USE_DIALOG2);
	$USE_DIALOG2 =~ tr/a-z/A-Z/;

	if ($USE_DIALOG2 ne "") {
	    $USE_DIALOG = $USE_DIALOG2;
	}
    }

    system("clear");

    if ($USE_DIALOG eq "Y") {
	&config_dialog;
    } else {
	&config_shell;
    }

    if ($MADE_MAKE eq "TRUE") {
	&check_inetd;
    }
}

&prog_startup;
