
/*
 *         PVM version 3.3:  Parallel Virtual Machine System
 *               University of Tennessee, Knoxville TN.
 *           Oak Ridge National Laboratory, Oak Ridge TN.
 *                   Emory University, Atlanta GA.
 *      Authors:  A. L. Beguelin, J. J. Dongarra, G. A. Geist,
 *    W. C. Jiang, R. J. Manchek, B. K. Moore, and V. S. Sunderam
 *                   (C) 1992 All Rights Reserved
 *
 *                              NOTICE
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted
 * provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * Neither the Institutions (Emory University, Oak Ridge National
 * Laboratory, and University of Tennessee) nor the Authors make any
 * representations about the suitability of this software for any
 * purpose.  This software is provided ``as is'' without express or
 * implied warranty.
 *
 * PVM version 3 was funded in part by the U.S. Department of Energy,
 * the National Science Foundation and the State of Tennessee.
 */

/*
 *	pvmmarch.c
 *
 *	Architecture classification.  Used to be archcode.c
 *
$Log: pvmarchc.c,v $
 * Revision 1.3  1994/11/07  22:46:08  manchek
 * added classes SGI64, SGIMP64, SCO, SX3
 *
 * Revision 1.2  1994/09/02  15:46:44  manchek
 * added CSPP, UXPM arches
 *
 * Revision 1.1  1994/06/03  20:38:21  manchek
 * Initial revision
 *
 * Revision 1.1  1993/08/30  23:26:46  manchek
 * Initial revision
 *
 */

#include "protoglarp.h"
#include "pvmalloc.h"
#ifdef	SYSVSTR
#include <string.h>
#else
#include <strings.h>
#endif

#ifndef	max
#define	max(a,b)	((a)>(b)?(a):(b))
#endif

struct archtypes {
	char *archname;
	int archnum;
};

struct nl {
	char *nl_name;
	int nl_num;
	struct nl *nl_next;
};

static char rcsid[] = "$Id: pvmarchc.c,v 1.3 1994/11/07 22:46:08 manchek Exp $";
static char pvmtxt[512];				/* scratch for error log */
static struct nl *morearches = 0;
static int lastarch = 0;

/*	This array groups machine types by data-representation compatibility
*	i.e.  machines that are integer, floating-point binary compatible
*	should be in the same class number.
*
*	The numbers are also used in process-process messages to identify
*	the data encoding used.  Stay away from 0 and 1, using for XDR
*	and foo.
*/

static struct archtypes arches[] = {
	{"", 10},

	{"AFX8", 11}, {"BFLY", 11}, {"CM2", 11}, {"CM5", 11},
	{"CNVX", 11}, {"CRAYSMP", 11}, {"CSPP", 11}, {"DGAV", 11}, {"E88K", 11},
	{"HP300", 11}, {"HPPA", 11}, {"MIPS", 11}, {"NEXT", 11},
	{"RS6K", 11}, {"POWER4", 11}, {"RT", 11}, {"SGI", 11}, {"SGI5", 11},
	{"SGI64", 11}, {"SGIMP64", 11},
	{"SGIMP", 11}, {"SUN3", 11}, {"SUN4", 11}, {"SUN4SOL2", 11},
	{"SUNMP", 11}, {"TITN", 11},

	{"BSD386", 12}, {"IPSC2", 12}, {"LINUX", 12}, {"MASPAR", 12},
	{"PMAX", 12}, {"SCO", 12}, {"SYMM", 12},

	{"I860", 13}, {"PGON", 13},

	{"BAL", 14},
	{"CNVXN", 15},
	{"CRAY", 16}, {"CRAY2", 16},
	{"KSR1", 17},
	{"UVAX", 18},
	{"VCM2", 19},
	{"ALPHA", 20}, {"ALPHAMP", 20},
	{"U370", 21}, {"UXPM", 21},
	{"SX3", 22},
	{"", 0}
};

/*	pvm_archcode()
*
*	Look up the integer code for a architecture string.  Make up
*	one if necessary and cache it.
*/

int
pvm_archcode(arch)
	char *arch;
{
	int i;
	struct nl *nlp;

	if (!arch)
		return -1;

	for (i = 0; arches[i].archnum; i++)
		if (!strcmp(arch, arches[i].archname))
			return arches[i].archnum;

	for (nlp = morearches; nlp; nlp = nlp->nl_next)
		if (!strcmp(arch, nlp->nl_name))
			return nlp->nl_num;

	if (!morearches)
		for (i = 0; arches[i].archnum; i++)
			lastarch = max(lastarch, arches[i].archnum);

	sprintf(pvmtxt, "pvm_archcode: Warning - unknown arch %s\n", arch);
	pvmlogerror(pvmtxt);
	if (nlp = TALLOC(1, struct nl, "nl")) {
		nlp->nl_name = STRALLOC(arch);
		nlp->nl_num = ++lastarch;
		nlp->nl_next = morearches;
		morearches = nlp;
		return nlp->nl_num;
	} else {
		pvmlogerror("pvm_archcode: can't malloc\n");
		return -1;
	}
}


